/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import gnu.trove.TIntHashSet;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComplementaryFontsRegistry {
    private static final Logger LOG = Logger.getInstance(ComplementaryFontsRegistry.class);
    private static final Object lock = new String("common lock");
    private static final List<String> ourFontNames;
    private static final Map<String, Pair<String, Integer>[]> ourStyledFontMap;
    private static final LinkedHashMap<FontKey, FontInfo> ourUsedFonts;
    private static FontKey ourSharedKeyInstance;
    private static FontInfo ourSharedDefaultFont;
    private static final TIntHashSet ourUndisplayableChars;
    private static boolean ourOldUseAntialiasing;
    private static final String[] BOLD_NAMES;
    private static final String[] ITALIC_NAMES;
    private static final String[] BOLD_ITALIC_NAMES;
    private static final Map<String, Integer> FONT_NAME_TO_STYLE;
    @NonNls
    private static final String BOLD_SUFFIX = ".bold";
    @NonNls
    private static final String ITALIC_SUFFIX = ".italic";

    private ComplementaryFontsRegistry() {
    }

    private static void fillStyledFontMap() {
        Font[] allFonts;
        for (Font font : allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String name = font.getName();
            Integer style = null;
            if (!SystemInfo.isAppleJvm) {
                style = FONT_NAME_TO_STYLE.get(name);
            }
            if (style == null) {
                if (!Patches.JDK_MAC_FONT_STYLE_BUG) continue;
                style = ComplementaryFontsRegistry.getFontStyle(name);
            }
            if (style == 0) continue;
            String familyName = font.getFamily();
            Pair<String, Integer>[] entry = ourStyledFontMap.get(familyName);
            if (entry == null) {
                entry = new Pair[4];
                for (int i = 1; i < 4; ++i) {
                    entry[i] = Pair.create((Object)familyName, (Object)i);
                }
                ourStyledFontMap.put(familyName, entry);
            }
            entry[style.intValue()] = Pair.create((Object)name, (Object)0);
        }
    }

    @JdkConstants.FontStyle
    static int getFontStyle(String fontName) {
        fontName = fontName.toLowerCase(Locale.getDefault());
        for (String name : BOLD_ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 3;
        }
        for (String name : ITALIC_NAMES) {
            if (!fontName.contains(name)) continue;
            return 2;
        }
        for (String name : BOLD_NAMES) {
            if (!fontName.contains(name)) continue;
            return 1;
        }
        return 0;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, @JdkConstants.FontStyle int style, @NotNull FontPreferences preferences) {
        FontInfo result;
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        boolean tryDefaultFont = true;
        List fontFamilies = preferences.getEffectiveFontFamilies();
        boolean useLigatures = preferences.useLigatures();
        int len = fontFamilies.size();
        for (int i = 0; i < len; ++i) {
            String fontFamily = (String)fontFamilies.get(i);
            result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, preferences.getSize(fontFamily), style, fontFamily, useLigatures);
            if (result != null) {
                FontInfo fontInfo = result;
                if (fontInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
                }
                return fontInfo;
            }
            tryDefaultFont &= !FontPreferences.DEFAULT_FONT_NAME.equals(fontFamily);
        }
        int size = FontPreferences.DEFAULT_FONT_SIZE;
        if (!fontFamilies.isEmpty()) {
            size = preferences.getSize((String)fontFamilies.get(0));
        }
        if (tryDefaultFont && (result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, FontPreferences.DEFAULT_FONT_NAME, useLigatures)) != null) {
            FontInfo fontInfo = result;
            if (fontInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
            }
            return fontInfo;
        }
        result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, useLigatures);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fallback font: " + result.getFont().getFontName());
        }
        FontInfo fontInfo = result;
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        return fontInfo;
    }

    @NotNull
    public static FontInfo getFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, @NotNull String defaultFontFamily) {
        if (defaultFontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultFontFamily", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        FontInfo result = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, defaultFontFamily, false);
        if (result != null) {
            FontInfo fontInfo = result;
            if (fontInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
            }
            return fontInfo;
        }
        FontInfo fontInfo = ComplementaryFontsRegistry.doGetFontAbleToDisplay(codePoint, size, style, false);
        if (fontInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "getFontAbleToDisplay"));
        }
        return fontInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static FontInfo doGetFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int originalStyle, @NotNull String defaultFontFamily, boolean useLigatures) {
        if (defaultFontFamily == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultFontFamily", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
        }
        Object object = lock;
        synchronized (object) {
            Pair<String, Integer>[] replacement;
            int style = originalStyle;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND && style > 0 && style < 4 && (replacement = ourStyledFontMap.get(defaultFontFamily)) != null) {
                defaultFontFamily = (String)replacement[style].first;
                style = (Integer)replacement[style].second;
            }
            if (ourSharedKeyInstance.mySize == size && ourSharedKeyInstance.myStyle == style && ourSharedKeyInstance.myFamilyName != null && ourSharedKeyInstance.myFamilyName.equals(defaultFontFamily) && ourSharedKeyInstance.myUseLigatures == useLigatures && ourSharedDefaultFont != null && (codePoint < 128 || ourSharedDefaultFont.canDisplay(codePoint))) {
                return ourSharedDefaultFont;
            }
            ourSharedKeyInstance.myFamilyName = defaultFontFamily;
            ourSharedKeyInstance.mySize = size;
            ourSharedKeyInstance.myStyle = style;
            ourSharedKeyInstance.myUseLigatures = useLigatures;
            FontInfo defaultFont = ourUsedFonts.get(ourSharedKeyInstance);
            if (defaultFont == null) {
                defaultFont = new FontInfo(defaultFontFamily, size, style, originalStyle, useLigatures);
                ourUsedFonts.put(ourSharedKeyInstance, defaultFont);
                ourSharedKeyInstance = new FontKey("", 0, 0, false);
            }
            ourSharedDefaultFont = defaultFont;
            if (codePoint < 128 || defaultFont.canDisplay(codePoint)) {
                return defaultFont;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static FontInfo doGetFontAbleToDisplay(int codePoint, int size, @JdkConstants.FontStyle int style, boolean useLigatures) {
        FontInfo fontInfo;
        Object object = lock;
        synchronized (object) {
            if (ourUndisplayableChars.contains(codePoint)) {
                FontInfo fontInfo2 = ourSharedDefaultFont;
                // MONITOREXIT @DISABLED, blocks:[4, 10] lbl5 : MonitorExitStatement: MONITOREXIT : var4_4
                if (fontInfo2 != null) return fontInfo2;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            Collection<FontInfo> descriptors = ourUsedFonts.values();
            for (FontInfo font : descriptors) {
                if (font.getSize() != size || font.getStyle() != style || font.areLigaturesEnabled() != useLigatures || !font.canDisplay(codePoint)) continue;
                FontInfo fontInfo3 = font;
                // MONITOREXIT @DISABLED, blocks:[4, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                if (fontInfo3 != null) return fontInfo3;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            for (int i = 0; i < ourFontNames.size(); ++i) {
                String name = ourFontNames.get(i);
                FontInfo font = new FontInfo(name, size, style, style, useLigatures);
                if (!font.canDisplay(codePoint)) continue;
                ourUsedFonts.put(new FontKey(name, size, style, useLigatures), font);
                ourFontNames.remove(i);
                FontInfo fontInfo4 = font;
                // MONITOREXIT @DISABLED, blocks:[4, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var4_4
                if (fontInfo4 != null) return fontInfo4;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
            }
            ourUndisplayableChars.add(codePoint);
            fontInfo = ourSharedDefaultFont;
        }
        if (fontInfo != null) return fontInfo;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry", "doGetFontAbleToDisplay"));
    }

    static {
        ourStyledFontMap = new HashMap<String, Pair<String, Integer>[]>();
        ourSharedKeyInstance = new FontKey("", 0, 0, false);
        ourUndisplayableChars = new TIntHashSet();
        BOLD_NAMES = new String[]{"bold", "demibold", "demi-bold", "demi bold", "negreta", "demi"};
        ITALIC_NAMES = new String[]{"italic", "cursiva", "oblique", "inclined"};
        BOLD_ITALIC_NAMES = new String[]{"bolditalic", "bold-italic", "bold italic", "boldoblique", "bold-oblique", "bold oblique", "demibold italic", "negreta cursiva", "demi oblique"};
        FONT_NAME_TO_STYLE = new HashMap<String, Integer>();
        FONT_NAME_TO_STYLE.put("AnkaCoder-b", 1);
        FONT_NAME_TO_STYLE.put("AnkaCoder-i", 2);
        FONT_NAME_TO_STYLE.put("AnkaCoder-bi", 3);
        FONT_NAME_TO_STYLE.put("SourceCodePro-It", 2);
        FONT_NAME_TO_STYLE.put("SourceCodePro-BoldIt", 3);
        FONT_NAME_TO_STYLE.put("Hasklig-It", 2);
        FONT_NAME_TO_STYLE.put("Hasklig-BoldIt", 3);
        final UISettings settings = UISettings.getInstance();
        ourOldUseAntialiasing = !AntialiasingType.OFF.equals((Object)settings.EDITOR_AA_TYPE);
        settings.addUISettingsListener(new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                if (ourOldUseAntialiasing ^ !AntialiasingType.OFF.equals((Object)settings.EDITOR_AA_TYPE)) {
                    ourOldUseAntialiasing = !AntialiasingType.OFF.equals((Object)settings.EDITOR_AA_TYPE);
                    for (FontInfo fontInfo : ourUsedFonts.values()) {
                        fontInfo.reset();
                    }
                    ourUsedFonts.clear();
                }
            }
        }, (Disposable)ApplicationManager.getApplication());
        ourFontNames = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourFontNames.add("Monospaced");
        } else {
            String[] fontNames;
            if (Patches.JDK_MAC_FONT_STYLE_DETECTION_WORKAROUND) {
                ComplementaryFontsRegistry.fillStyledFontMap();
            }
            for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (fontName.endsWith(BOLD_SUFFIX) || fontName.endsWith(ITALIC_SUFFIX)) continue;
                ourFontNames.add(fontName);
            }
        }
        ourUsedFonts = new LinkedHashMap();
    }

    private static class FontKey {
        private String myFamilyName;
        private int mySize;
        private int myStyle;
        private boolean myUseLigatures;

        public FontKey(@NotNull String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures) {
            if (familyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "familyName", "com/intellij/openapi/editor/impl/ComplementaryFontsRegistry$FontKey", "<init>"));
            }
            this.myFamilyName = familyName;
            this.mySize = size;
            this.myStyle = style;
            this.myUseLigatures = useLigatures;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FontKey fontKey = (FontKey)o;
            if (this.mySize != fontKey.mySize) {
                return false;
            }
            if (this.myStyle != fontKey.myStyle) {
                return false;
            }
            if (this.myUseLigatures != fontKey.myUseLigatures) {
                return false;
            }
            return this.myFamilyName.equals(fontKey.myFamilyName);
        }

        public int hashCode() {
            int result = this.myFamilyName.hashCode();
            result = 29 * result + this.mySize;
            result = 29 * result + this.myStyle;
            if (this.myUseLigatures) {
                result = 29 * result + 1;
            }
            return result;
        }
    }
}

