/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.event.EditorEventMulticasterImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorFactoryImpl
extends EditorFactory
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFactoryImpl");
    private final EditorEventMulticasterImpl myEditorEventMulticaster = new EditorEventMulticasterImpl();
    private final EventDispatcher<EditorFactoryListener> myEditorFactoryEventDispatcher = EventDispatcher.create(EditorFactoryListener.class);
    private final List<Editor> myEditors = ContainerUtil.createLockFreeCopyOnWriteList();

    public EditorFactoryImpl(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(final Project project2) {
                Disposer.register((Disposable)project2, (Disposable)new Disposable(){

                    public void dispose() {
                        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                        boolean isLastProjectClosed = openProjects.length == 0;
                        EditorFactoryImpl.this.validateEditorsAreReleased(project2, isLastProjectClosed);
                    }
                });
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("EditorFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getComponentName"));
        }
        return "EditorFactory";
    }

    public void initComponent() {
        ModalityStateListener myModalityStateListener = new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering) {
                for (Editor editor : EditorFactoryImpl.this.myEditors) {
                    ((EditorImpl)editor).beforeModalityStateChanged();
                }
            }
        };
        LaterInvocator.addModalityStateListener(myModalityStateListener, (Disposable)ApplicationManager.getApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateEditorsAreReleased(Project project2, boolean isLastProjectClosed) {
        for (Editor editor : this.myEditors) {
            if (editor.getProject() != project2 && (editor.getProject() != null || !isLastProjectClosed)) continue;
            try {
                EditorFactoryImpl.throwNotReleasedError(editor);
            }
            finally {
                this.releaseEditor(editor);
            }
        }
    }

    @NonNls
    public static void throwNotReleasedError(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "throwNotReleasedError"));
        }
        if (!(editor instanceof EditorImpl)) {
            throw new RuntimeException("Editor of " + editor.getClass() + " and the following text hasn't been released:\n" + editor.getDocument().getText());
        }
        ((EditorImpl)editor).throwEditorNotDisposedError("Editor of " + editor.getClass() + " hasn't been released:");
    }

    public void disposeComponent() {
    }

    @NotNull
    public Document createDocument(@NotNull char[] text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        Document document = this.createDocument((CharSequence)new CharArrayCharSequence(text));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        DocumentImpl document = new DocumentImpl(text);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(boolean allowUpdatesWithoutWriteAction) {
        DocumentImpl document = new DocumentImpl("", allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    @NotNull
    public Document createDocument(@NotNull CharSequence text, boolean acceptsSlashR, boolean allowUpdatesWithoutWriteAction) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        DocumentImpl document = new DocumentImpl(text, acceptsSlashR, allowUpdatesWithoutWriteAction);
        this.myEditorEventMulticaster.registerDocument(document);
        DocumentImpl documentImpl = document;
        if (documentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createDocument"));
        }
        return documentImpl;
    }

    public void refreshAllEditors() {
        for (Editor editor : this.myEditors) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public Editor createEditor(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        return this.createEditor(document, false, null);
    }

    public Editor createViewer(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createViewer"));
        }
        return this.createEditor(document, true, null);
    }

    public Editor createEditor(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        return this.createEditor(document, false, project2);
    }

    public Editor createViewer(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createViewer"));
        }
        return this.createEditor(document, true, project2);
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull FileType fileType, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, fileType));
        return editor;
    }

    public Editor createEditor(@NotNull Document document, Project project2, @NotNull VirtualFile file2, boolean isViewer) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Editor editor = this.createEditor(document, isViewer, project2);
        ((EditorEx)editor).setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project2, file2));
        return editor;
    }

    private Editor createEditor(@NotNull Document document, boolean isViewer, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "createEditor"));
        }
        Document hostDocument = document instanceof DocumentWindow ? ((DocumentWindow)document).getDelegate() : document;
        EditorImpl editor = new EditorImpl(hostDocument, isViewer, project2);
        this.myEditors.add(editor);
        this.myEditorEventMulticaster.registerEditor(editor);
        ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorCreated(new EditorFactoryEvent((EditorFactory)this, (Editor)editor));
        if (LOG.isDebugEnabled()) {
            LOG.debug("number of Editor's:" + this.myEditors.size());
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "releaseEditor"));
        }
        try {
            ((EditorFactoryListener)this.myEditorFactoryEventDispatcher.getMulticaster()).editorReleased(new EditorFactoryEvent((EditorFactory)this, editor));
        }
        finally {
            try {
                ((EditorImpl)editor).release();
            }
            finally {
                this.myEditors.remove(editor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("number of Editor's:" + this.myEditors.size());
                }
            }
        }
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document, Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        List list = null;
        for (Editor editor : this.myEditors) {
            Project project1 = editor.getProject();
            if (!editor.getDocument().equals(document) || project2 != null && project1 != null && !project1.equals(project2)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(editor);
        }
        Editor[] editorArray = list == null ? Editor.EMPTY_ARRAY : list.toArray(new Editor[list.size()]);
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getEditors(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        Editor[] editorArray = this.getEditors(document, null);
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEditors"));
        }
        return editorArray;
    }

    @NotNull
    public Editor[] getAllEditors() {
        Editor[] editorArray = (Editor[])ArrayUtil.stripTrailingNulls((Object[])this.myEditors.toArray(new Editor[this.myEditors.size()]));
        if (editorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getAllEditors"));
        }
        return editorArray;
    }

    @Deprecated
    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2);
    }

    public void addEditorFactoryListener(@NotNull EditorFactoryListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "addEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Deprecated
    public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "removeEditorFactoryListener"));
        }
        this.myEditorFactoryEventDispatcher.removeListener((EventListener)listener2);
    }

    @NotNull
    public EditorEventMulticaster getEventMulticaster() {
        EditorEventMulticasterImpl editorEventMulticasterImpl = this.myEditorEventMulticaster;
        if (editorEventMulticasterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorFactoryImpl", "getEventMulticaster"));
        }
        return editorEventMulticasterImpl;
    }
}

