/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.Alarm;
import gnu.trove.TLongArrayList;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EditorSizeAdjustmentStrategy {
    private static final long TIMING_TTL_MILLIS = 10000L;
    private static final int FREQUENT_SIZE_CHANGES_NUMBER = 10;
    private static final int DEFAULT_RESERVE_COLUMNS_NUMBER = 4;
    private final Alarm myAlarm = new Alarm();
    private final TLongArrayList myTimings = new TLongArrayList();
    private int myReserveColumns = 4;
    private boolean myInsideValidation;

    EditorSizeAdjustmentStrategy() {
    }

    @NotNull
    Dimension adjust(@NotNull Dimension newPreferredSize, @Nullable Dimension oldPreferredSize, @NotNull EditorImpl editor) {
        Dimension result;
        boolean increaseWidth;
        if (newPreferredSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPreferredSize", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
        }
        if (oldPreferredSize == null || this.myInsideValidation) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
            }
            return dimension;
        }
        if (newPreferredSize.height != oldPreferredSize.height) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
            }
            return dimension;
        }
        this.stripTimings();
        this.myTimings.add(System.currentTimeMillis());
        if (this.myTimings.size() < 10) {
            Dimension dimension = newPreferredSize;
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
            }
            return dimension;
        }
        boolean bl = increaseWidth = newPreferredSize.width > oldPreferredSize.width;
        if (increaseWidth) {
            int spaceWidth = EditorUtil.getSpaceWidth(0, editor);
            newPreferredSize.width += this.myReserveColumns * spaceWidth;
            this.myReserveColumns += 3;
            result = newPreferredSize;
        } else {
            result = oldPreferredSize;
        }
        this.scheduleSizeUpdate(editor);
        Dimension dimension = result;
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "adjust"));
        }
        return dimension;
    }

    void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    private void stripTimings() {
        int endIndex;
        long limit = System.currentTimeMillis() - 10000L;
        for (endIndex = 0; endIndex < this.myTimings.size() && this.myTimings.get(endIndex) <= limit; ++endIndex) {
        }
        if (endIndex > 0) {
            this.myTimings.remove(0, endIndex);
        }
    }

    private void scheduleSizeUpdate(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy", "scheduleSizeUpdate"));
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)new UpdateSizeTask(editor), 1000);
    }

    private class UpdateSizeTask
    implements Runnable {
        private final EditorImpl myEditor;

        UpdateSizeTask(EditorImpl editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorSizeAdjustmentStrategy$UpdateSizeTask", "<init>"));
            }
            this.myEditor = editor;
        }

        @Override
        public void run() {
            EditorSizeAdjustmentStrategy.this.myInsideValidation = true;
            EditorSizeAdjustmentStrategy.this.myReserveColumns = 4;
            EditorSizeAdjustmentStrategy.this.myTimings.clear();
            try {
                this.myEditor.validateSize();
            }
            finally {
                EditorSizeAdjustmentStrategy.this.myInsideValidation = false;
            }
        }
    }
}

