/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import org.jetbrains.annotations.NotNull;

public class PreciseMouseWheelScroller
implements MouseWheelListener {
    private static final Logger LOGGER = Logger.getInstance(PreciseMouseWheelScroller.class);
    private static Method PRECISE_WHEEL_ROTATION_GETTER;
    private final JScrollPane myScrollPane;

    public static void install(@NotNull JScrollPane scrollPane) {
        if (scrollPane == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPane", "com/intellij/openapi/editor/impl/PreciseMouseWheelScroller", "install"));
        }
        scrollPane.setWheelScrollingEnabled(false);
        scrollPane.addMouseWheelListener(new PreciseMouseWheelScroller(scrollPane));
    }

    private PreciseMouseWheelScroller(JScrollPane scrollPane) {
        this.myScrollPane = scrollPane;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        if (e.getWheelRotation() != 0) {
            int direction;
            int orientation = 1;
            JScrollBar toScroll = this.myScrollPane.getVerticalScrollBar();
            if (toScroll == null || !toScroll.isVisible() || e.isShiftDown()) {
                orientation = 0;
                toScroll = this.myScrollPane.getHorizontalScrollBar();
                if (toScroll == null || !toScroll.isVisible()) {
                    return;
                }
            }
            int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
            if (e.getScrollType() == 0) {
                JViewport vp = this.myScrollPane.getViewport();
                Component comp = vp.getView();
                boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                Scrollable scrollComp = (Scrollable)((Object)comp);
                Rectangle viewRect = vp.getViewRect();
                int scrollMin = toScroll.getMinimum();
                int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                if (limitScroll) {
                    int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                    if (direction < 0) {
                        scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                    } else {
                        scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                    }
                }
                double units = PreciseMouseWheelScroller.getUnitsToScroll(e);
                double shift = (double)scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction) * units;
                if (orientation == 1) {
                    viewRect.y = (int)((double)viewRect.y + shift);
                    if (direction < 0) {
                        if (viewRect.y <= scrollMin) {
                            viewRect.y = scrollMin;
                        }
                    } else if (viewRect.y >= scrollMax) {
                        viewRect.y = scrollMax;
                    }
                    toScroll.setValue(viewRect.y);
                } else {
                    viewRect.x = (int)((double)viewRect.x + shift);
                    if (direction < 0) {
                        if (viewRect.x < scrollMin) {
                            viewRect.x = scrollMin;
                        }
                    } else if (viewRect.x > scrollMax) {
                        viewRect.x = scrollMax;
                    }
                    toScroll.setValue(viewRect.x);
                }
            } else if (e.getScrollType() == 1) {
                int oldValue = toScroll.getValue();
                int blockIncrement = toScroll.getBlockIncrement(direction);
                int delta = blockIncrement * direction;
                int newValue = oldValue + delta;
                if (delta > 0 && newValue < oldValue) {
                    newValue = toScroll.getMaximum();
                } else if (delta < 0 && newValue > oldValue) {
                    newValue = toScroll.getMinimum();
                }
                toScroll.setValue(newValue);
            }
        }
    }

    private static double getUnitsToScroll(MouseWheelEvent e) {
        if (PRECISE_WHEEL_ROTATION_GETTER != null) {
            try {
                Double value = (Double)PRECISE_WHEEL_ROTATION_GETTER.invoke((Object)e, new Object[0]);
                return (double)e.getScrollAmount() * value;
            }
            catch (Exception ex) {
                LOGGER.debug("Error calling getPreciseWheelRotation method", (Throwable)ex);
            }
        }
        return e.getUnitsToScroll();
    }

    static {
        if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
            try {
                Method method = MouseWheelEvent.class.getMethod("getPreciseWheelRotation", new Class[0]);
                Class<?> returnType = method.getReturnType();
                if (!returnType.equals(Double.TYPE)) {
                    throw new RuntimeException("Unexpected method return type: " + returnType);
                }
                PRECISE_WHEEL_ROTATION_GETTER = method;
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't access getPreciseWheelRotation method", (Throwable)e);
            }
        }
    }
}

