/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483647)
public class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "getTargetDataKey"));
        }
        return key;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<ModuleData>> toImport, final @NotNull ProjectData projectData, @NotNull Project project2, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (projectData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectData", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        Computable<Collection<Module>> computable = new Computable<Collection<Module>>(){

            public Collection<Module> compute() {
                List orphanIdeModules = ContainerUtil.newSmartList();
                for (Module module2 : modelsProvider.getModules()) {
                    if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData.getOwner(), (Module)module2) || ExternalSystemApiUtil.getExternalModuleType((Module)module2) != null) continue;
                    String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
                    if (!projectData.getLinkedExternalProjectPath().equals(rootProjectPath) || module2.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                    orphanIdeModules.add(module2);
                }
                return orphanIdeModules;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "computeOrphanData"));
        }
        return computable;
    }
}

