/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class CacheUpdateRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.CacheUpdateRunner");
    private static final Key<Boolean> FAILED_TO_INDEX = Key.create((String)"FAILED_TO_INDEX");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int FILE_SIZE_TO_SHOW_THRESHOLD = 512000;

    public static void processFiles(final ProgressIndicator indicator, boolean processInReadAction, Collection<VirtualFile> files, Project project2, Consumer<FileContent> processor2) {
        indicator.checkCanceled();
        FileContentQueue queue = new FileContentQueue();
        final double total = files.size();
        queue.queue(files, indicator);
        Consumer<VirtualFile> progressUpdater = new Consumer<VirtualFile>(){
            final Set<VirtualFile> processed = new THashSet();
            private boolean fileNameWasShown;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(VirtualFile virtualFile) {
                indicator.checkCanceled();
                Set<VirtualFile> set = this.processed;
                synchronized (set) {
                    boolean added = this.processed.add(virtualFile);
                    indicator.setFraction((double)this.processed.size() / total);
                    if (!added || virtualFile.isValid() && virtualFile.getLength() > 512000L) {
                        indicator.setText2(virtualFile.getPresentableUrl());
                        this.fileNameWasShown = true;
                    } else if (this.fileNameWasShown) {
                        indicator.setText2("");
                        this.fileNameWasShown = false;
                    }
                }
            }
        };
        while (!project2.isDisposed()) {
            indicator.checkCanceled();
            if (!CacheUpdateRunner.processSomeFilesWhileUserIsInactive(queue, progressUpdater, processInReadAction, project2, processor2)) continue;
        }
        if (project2.isDisposed()) {
            indicator.cancel();
            indicator.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue, @NotNull Consumer<VirtualFile> progressUpdater, boolean processInReadAction, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (fileProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        final ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                innerIndicator.cancel();
            }
        };
        final Application application = ApplicationManager.getApplication();
        application.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                application.addApplicationListener((ApplicationListener)canceller);
            }
        }, ModalityState.any());
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = CacheUpdateRunner.indexingThreadCount();
            if (threadsCount == 1 || application.isWriteAccessAllowed()) {
                MyRunnable process = new MyRunnable(innerIndicator, queue, isFinished, progressUpdater, processInReadAction, project2, fileProcessor);
                ProgressManager.getInstance().runProcess((Runnable)process, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    AtomicBoolean ref;
                    finishedRefs[i] = ref = new AtomicBoolean();
                    MyRunnable process = new MyRunnable(innerIndicator, queue, ref, progressUpdater, processInReadAction, project2, fileProcessor);
                    futures[i] = application.executeOnPooledThread((Runnable)process);
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished.get();
    }

    public static int indexingThreadCount() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(PROC_COUNT - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    private static boolean waitForAll(@NotNull AtomicBoolean[] finishedRefs, @NotNull Future<?>[] futures) {
        if (finishedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishedRefs", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        if (futures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "futures", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        try {
            for (Future<?> future2 : futures) {
                future2.get();
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (InterruptedException allFinished) {
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        return false;
    }

    private static class MyRunnable
    implements Runnable {
        private final ProgressIndicatorBase myInnerIndicator;
        private final FileContentQueue myQueue;
        private final AtomicBoolean myFinished;
        private final Consumer<VirtualFile> myProgressUpdater;
        private final boolean myProcessInReadAction;
        @NotNull
        private final Project myProject;
        @NotNull
        private final Consumer<FileContent> myProcessor;

        public MyRunnable(@NotNull ProgressIndicatorBase innerIndicator, @NotNull FileContentQueue queue, @NotNull AtomicBoolean finished, @NotNull Consumer<VirtualFile> progressUpdater, boolean processInReadAction, @NotNull Project project2, @NotNull Consumer<FileContent> fileProcessor) {
            if (innerIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerIndicator", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (finished == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finished", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (progressUpdater == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressUpdater", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (fileProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProcessor", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            this.myInnerIndicator = innerIndicator;
            this.myQueue = queue;
            this.myFinished = finished;
            this.myProgressUpdater = progressUpdater;
            this.myProcessInReadAction = processInReadAction;
            this.myProject = project2;
            this.myProcessor = fileProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.myProject.isDisposed() && !this.myInnerIndicator.isCanceled()) {
                try {
                    final FileContent fileContent = this.myQueue.take(this.myInnerIndicator);
                    if (fileContent == null) {
                        this.myFinished.set(true);
                        return;
                    }
                    final Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            myInnerIndicator.checkCanceled();
                            if (!myProject.isDisposed()) {
                                VirtualFile file2 = fileContent.getVirtualFile();
                                try {
                                    myProgressUpdater.consume((Object)file2);
                                    if (!file2.isDirectory() && !Boolean.TRUE.equals(file2.getUserData(FAILED_TO_INDEX))) {
                                        myProcessor.consume((Object)fileContent);
                                    }
                                }
                                catch (ProcessCanceledException e) {
                                    throw e;
                                }
                                catch (Throwable e) {
                                    LOG.error("Error while indexing " + file2.getPresentableUrl() + "\n" + "To reindex this file IDEA has to be restarted", e);
                                    file2.putUserData(FAILED_TO_INDEX, (Object)Boolean.TRUE);
                                }
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(){

                            @Override
                            public void run() {
                                if (myProcessInReadAction) {
                                    if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)) {
                                        throw new ProcessCanceledException();
                                    }
                                } else {
                                    action.run();
                                }
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(this.myInnerIndicator));
                    }
                    catch (ProcessCanceledException e) {
                        this.myQueue.pushBack(fileContent);
                        return;
                    }
                    finally {
                        this.myQueue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
            return;
        }
    }
}

