/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;
    private final ContentFilter myContentFilter;

    public ProjectFileIndexImpl(@NotNull Project project2, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeManager", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        super(directoryIndex, fileTypeManager, project2);
        this.myProject = project2;
        this.myContentFilter = new ContentFilter();
    }

    public boolean iterateContent(@NotNull ContentIterator iterator) {
        Module[] modules;
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContent"));
        }
        for (Module module2 : modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return ModuleManager.getInstance((Project)ProjectFileIndexImpl.this.myProject).getModules();
            }
        })) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module2)) {
                boolean finished = VfsUtilCore.iterateChildrenRecursively((VirtualFile)contentRoot, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
                if (finished) continue;
                return false;
            }
        }
        return true;
    }

    private List<VirtualFile> getRootsToIterate(final Module module2) {
        return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<VirtualFile>>(){

            public List<VirtualFile> compute() {
                if (module2.isDisposed()) {
                    return Collections.emptyList();
                }
                ArrayList result = ContainerUtil.newArrayList();
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(contentRoot);
                    if (!info.isInProject() || !module2.equals(info.getModule()) || (parent = contentRoot.getParent()) != null && (parentInfo = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(parent)).isInProject() && parentInfo.getModule() != null) continue;
                    result.add(contentRoot);
                }
                return result;
            }
        });
    }

    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        return VfsUtilCore.iterateChildrenRecursively((VirtualFile)dir, (VirtualFileFilter)this.myContentFilter, (ContentIterator)iterator);
    }

    public boolean isExcluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isExcluded"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file2);
        return info.isIgnored() || info.isExcluded();
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderIgnored"));
        }
        return this.getInfoForFileOrDirectory(file2).isIgnored();
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getModuleForFile"));
        }
        return this.getModuleForFile(file2, true);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        DirectoryInfo info;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getModuleForFile"));
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file2)).isInProject() || !honorExclusion && info.isExcluded()) {
            return info.getModule();
        }
        return null;
    }

    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        List<OrderEntry> list = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        return list;
    }

    public VirtualFile getClassRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getClassRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file2);
        if (!info.isInProject()) {
            return null;
        }
        return info.getLibraryClassRoot();
    }

    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getSourceRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file2);
        if (!info.isInProject()) {
            return null;
        }
        return info.getSourceRoot();
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getContentRootForFile"));
        }
        return this.getContentRootForFile(file2, true);
    }

    public VirtualFile getContentRootForFile(@NotNull VirtualFile file2, boolean honorExclusion) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getContentRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file2);
        if (info.isInProject() || !honorExclusion && info.isExcluded()) {
            return info.getContentRoot();
        }
        return null;
    }

    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getPackageNameByDirectory"));
        }
        LOG.assertTrue(dir.isDirectory(), (Object)dir.getPresentableUrl());
        return this.myDirectoryIndex.getPackageName(dir);
    }

    public boolean isLibraryClassFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isLibraryClassFile"));
        }
        if (file2.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file2);
        return parentInfo.isInProject() && parentInfo.hasLibraryClassRoot();
    }

    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSource"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() || info.isInLibrarySource();
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibraryClasses"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && info.hasLibraryClassRoot();
    }

    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibrarySource"));
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInLibrarySource();
    }

    public boolean isIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isIgnored"));
        }
        return this.isExcluded(file2);
    }

    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && info.getModule() != null;
    }

    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSourceContent"));
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource();
    }

    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInTestSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        public boolean accept(final @NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl$ContentFilter", "accept"));
            }
            return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    DirectoryInfo info = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(file2);
                    if (!info.isInProject() || info.getModule() == null) {
                        return false;
                    }
                    if (file2.isDirectory()) {
                        return true;
                    }
                    return !ProjectFileIndexImpl.this.myFileTypeRegistry.isFileIgnored(file2);
                }
            });
        }
    }
}

