/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.server.BuildManager;
import com.intellij.facet.Facet;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ErrorPaneConfigurable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurableContributor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurableFilter;
import com.intellij.openapi.roots.ui.configuration.SidePanel;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkListConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Place.Navigator,
Configurable.NoMargin,
Configurable.NoScroll {
    public static final DataKey<ProjectStructureConfigurable> KEY = DataKey.create((String)"ProjectStructureConfiguration");
    protected final UIState myUiState = new UIState();
    private JBSplitter mySplitter;
    private JComponent myToolbarComponent;
    @NonNls
    public static final String CATEGORY = "category";
    private JComponent myToFocus;
    private final Project myProject;
    private final FacetStructureConfigurable myFacetStructureConfigurable;
    private final ArtifactsStructureConfigurable myArtifactsStructureConfigurable;
    private History myHistory = new History((Place.Navigator)this);
    private SidePanel mySidePanel;
    private JPanel myComponent;
    private final Wrapper myDetails = new Wrapper();
    private Configurable mySelectedConfigurable;
    private final ProjectSdksModel myProjectJdksModel = new ProjectSdksModel();
    private ProjectConfigurable myProjectConfig;
    private final ProjectLibrariesConfigurable myProjectLibrariesConfig;
    private final GlobalLibrariesConfigurable myGlobalLibrariesConfig;
    private ModuleStructureConfigurable myModulesConfig;
    private boolean myUiInitialized;
    private final List<Configurable> myName2Config = new ArrayList<Configurable>();
    private final StructureConfigurableContext myContext;
    private final ModulesConfigurator myModuleConfigurator;
    private JdkListConfigurable myJdkListConfig;
    private final JLabel myEmptySelection = new JLabel("<html><body><center>Select a setting to view or edit its details here</center></body></html>", 0);

    public ProjectStructureConfigurable(Project project2, ProjectLibrariesConfigurable projectLibrariesConfigurable, GlobalLibrariesConfigurable globalLibrariesConfigurable, ModuleStructureConfigurable moduleStructureConfigurable, FacetStructureConfigurable facetStructureConfigurable, ArtifactsStructureConfigurable artifactsStructureConfigurable) {
        this.myProject = project2;
        this.myFacetStructureConfigurable = facetStructureConfigurable;
        this.myArtifactsStructureConfigurable = artifactsStructureConfigurable;
        this.myModuleConfigurator = new ModulesConfigurator(this.myProject);
        this.myContext = new StructureConfigurableContext(this.myProject, this.myModuleConfigurator);
        this.myModuleConfigurator.setContext(this.myContext);
        this.myProjectLibrariesConfig = projectLibrariesConfigurable;
        this.myGlobalLibrariesConfig = globalLibrariesConfigurable;
        this.myModulesConfig = moduleStructureConfigurable;
        this.myProjectLibrariesConfig.init(this.myContext);
        this.myGlobalLibrariesConfig.init(this.myContext);
        this.myModulesConfig.init(this.myContext);
        this.myFacetStructureConfigurable.init(this.myContext);
        if (!project2.isDefault()) {
            this.myArtifactsStructureConfigurable.init(this.myContext, this.myModulesConfig, this.myProjectLibrariesConfig, this.myGlobalLibrariesConfig);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        this.myUiState.lastEditedConfigurable = propertiesComponent.getValue("project.structure.last.edited");
        String proportion = propertiesComponent.getValue("project.structure.proportion");
        this.myUiState.proportion = proportion != null ? Float.parseFloat(proportion) : 0.0f;
        String sideProportion = propertiesComponent.getValue("project.structure.side.proportion");
        this.myUiState.sideProportion = sideProportion != null ? Float.parseFloat(sideProportion) : 0.0f;
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.structure" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "getId"));
        }
        return "project.structure";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return ProjectBundle.message((String)"project.settings.display.name", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.mySelectedConfigurable != null ? this.mySelectedConfigurable.getHelpTopic() : "";
    }

    public JComponent createComponent() {
        this.myComponent = new MyPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.15f);
        this.mySplitter.setSplitterProportionKey("ProjectStructure.TopLevelElements");
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.initSidePanel();
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new BackAction((JComponent)this.myComponent));
        toolbarGroup.add((AnAction)new ForwardAction((JComponent)this.myComponent));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)this.myComponent);
        this.myToolbarComponent = toolbar.getComponent();
        left.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        this.myToolbarComponent.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        left.add((Component)this.myToolbarComponent, "North");
        left.add((Component)this.mySidePanel, "Center");
        this.mySplitter.setFirstComponent((JComponent)left);
        this.mySplitter.setSecondComponent((JComponent)this.myDetails);
        this.myComponent.add((Component)this.mySplitter, "Center");
        this.myUiInitialized = true;
        return this.myComponent;
    }

    private void initSidePanel() {
        ProjectStructureConfigurableContributor[] adders;
        boolean isDefaultProject = this.myProject == ProjectManager.getInstance().getDefaultProject();
        this.mySidePanel = new SidePanel(this, this.myHistory);
        this.mySidePanel.addSeparator("Project Settings");
        this.addProjectConfig();
        if (!isDefaultProject) {
            this.addModulesConfig();
        }
        this.addProjectLibrariesConfig();
        if (!isDefaultProject) {
            this.addFacetsConfig();
            this.addArtifactsConfig();
        }
        for (ProjectStructureConfigurableContributor adder : adders = (ProjectStructureConfigurableContributor[])ProjectStructureConfigurableContributor.EP_NAME.getExtensions()) {
            for (Configurable configurable : adder.getExtraProjectConfigurables(this.myProject, this.myContext)) {
                this.addConfigurable(configurable, true);
            }
        }
        this.mySidePanel.addSeparator("Platform Settings");
        this.addJdkListConfig();
        this.addGlobalLibrariesConfig();
        for (ProjectStructureConfigurableContributor adder : adders) {
            for (Configurable configurable : adder.getExtraPlatformConfigurables(this.myProject, this.myContext)) {
                this.addConfigurable(configurable, true);
            }
        }
        this.mySidePanel.addSeparator("--");
        this.addErrorPane();
    }

    private void addArtifactsConfig() {
        this.addConfigurable((Configurable)this.myArtifactsStructureConfigurable, ProjectStructureConfigurableFilter.ConfigurableId.ARTIFACTS);
    }

    private void addConfigurable(Configurable configurable, ProjectStructureConfigurableFilter.ConfigurableId configurableId) {
        this.addConfigurable(configurable, this.isAvailable(configurableId));
    }

    private boolean isAvailable(ProjectStructureConfigurableFilter.ConfigurableId id) {
        for (ProjectStructureConfigurableFilter filter : (ProjectStructureConfigurableFilter[])ProjectStructureConfigurableFilter.EP_NAME.getExtensions()) {
            if (filter.isAvailable(id, this.myProject)) continue;
            return false;
        }
        return true;
    }

    public ArtifactsStructureConfigurable getArtifactsStructureConfigurable() {
        return this.myArtifactsStructureConfigurable;
    }

    private void addFacetsConfig() {
        if (this.myFacetStructureConfigurable.isVisible()) {
            this.addConfigurable((Configurable)this.myFacetStructureConfigurable, ProjectStructureConfigurableFilter.ConfigurableId.FACETS);
        }
    }

    private void addJdkListConfig() {
        if (this.myJdkListConfig == null) {
            this.myJdkListConfig = JdkListConfigurable.getInstance(this.myProject);
            this.myJdkListConfig.init(this.myContext);
        }
        this.addConfigurable((Configurable)this.myJdkListConfig, ProjectStructureConfigurableFilter.ConfigurableId.JDK_LIST);
    }

    private void addProjectConfig() {
        this.myProjectConfig = new ProjectConfigurable(this.myProject, this.myContext, this.myModuleConfigurator, this.myProjectJdksModel);
        this.addConfigurable((Configurable)this.myProjectConfig, ProjectStructureConfigurableFilter.ConfigurableId.PROJECT);
    }

    private void addProjectLibrariesConfig() {
        this.addConfigurable((Configurable)this.myProjectLibrariesConfig, ProjectStructureConfigurableFilter.ConfigurableId.PROJECT_LIBRARIES);
    }

    private void addErrorPane() {
        this.addConfigurable((Configurable)new ErrorPaneConfigurable(this.myProject, this.myContext, new Runnable(){

            @Override
            public void run() {
                ProjectStructureConfigurable.this.mySidePanel.getList().repaint();
            }
        }), true);
    }

    private void addGlobalLibrariesConfig() {
        this.addConfigurable((Configurable)this.myGlobalLibrariesConfig, ProjectStructureConfigurableFilter.ConfigurableId.GLOBAL_LIBRARIES);
    }

    private void addModulesConfig() {
        this.myModulesConfig = ModuleStructureConfigurable.getInstance(this.myProject);
        this.addConfigurable((Configurable)this.myModulesConfig, ProjectStructureConfigurableFilter.ConfigurableId.MODULES);
    }

    public boolean isModified() {
        for (Configurable each : this.myName2Config) {
            if (!each.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.myName2Config) {
            if (!(configurable instanceof BaseStructureConfigurable) || !configurable.isModified()) continue;
            ((BaseStructureConfigurable)configurable).checkCanApply();
        }
        Ref exceptionRef = Ref.create();
        try {
            for (Configurable each : this.myName2Config) {
                if (!each.isModified()) continue;
                each.apply();
            }
        }
        catch (ConfigurationException configurationException) {
            exceptionRef.set((Object)configurationException);
        }
        if (!exceptionRef.isNull()) {
            throw (ConfigurationException)((Object)exceptionRef.get());
        }
        this.myContext.getDaemonAnalyzer().clearCaches();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BuildManager.getInstance().scheduleAutoMake();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AccessToken token = HeavyProcessLatch.INSTANCE.processStarted("Resetting Project Structure");
        try {
            this.myContext.reset();
            this.myProjectJdksModel.reset(this.myProject);
            Configurable toSelect = null;
            for (Configurable each : this.myName2Config) {
                if (this.myUiState.lastEditedConfigurable != null && this.myUiState.lastEditedConfigurable.equals(each.getDisplayName())) {
                    toSelect = each;
                }
                if (each instanceof MasterDetailsComponent) {
                    ((MasterDetailsComponent)each).setHistory(this.myHistory);
                }
                each.reset();
            }
            this.myHistory.clear();
            if (toSelect == null && this.myName2Config.size() > 0) {
                toSelect = this.myName2Config.iterator().next();
            }
            this.removeSelected();
            this.navigateTo(toSelect != null ? ProjectStructureConfigurable.createPlaceFor(toSelect) : null, false);
            if (this.myUiState.proportion > 0.0f) {
                this.mySplitter.setProportion(this.myUiState.proportion);
            }
        }
        finally {
            token.finish();
        }
    }

    public void hideSidePanel() {
        this.mySplitter.getFirstComponent().setVisible(false);
    }

    public void disposeUIResources() {
        if (!this.myUiInitialized) {
            return;
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        propertiesComponent.setValue("project.structure.last.edited", this.myUiState.lastEditedConfigurable);
        propertiesComponent.setValue("project.structure.proportion", String.valueOf(this.myUiState.proportion));
        propertiesComponent.setValue("project.structure.side.proportion", String.valueOf(this.myUiState.sideProportion));
        this.myUiState.proportion = this.mySplitter.getProportion();
        this.saveSideProportion();
        this.myContext.getDaemonAnalyzer().stop();
        for (Configurable each : this.myName2Config) {
            each.disposeUIResources();
        }
        this.myContext.clear();
        this.myName2Config.clear();
        this.myModuleConfigurator.getFacetsConfigurator().clearMaps();
        this.myUiInitialized = false;
    }

    public boolean isUiInitialized() {
        return this.myUiInitialized;
    }

    public History getHistory() {
        return this.myHistory;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "queryPlace"));
        }
        place.putPath(CATEGORY, (Object)this.mySelectedConfigurable);
        Place.queryFurther((Object)this.mySelectedConfigurable, (Place)place);
    }

    public ActionCallback selectProjectGeneralSettings(boolean requestFocus) {
        return this.navigateTo(this.createProjectConfigurablePlace(), requestFocus);
    }

    public Place createProjectConfigurablePlace() {
        return ProjectStructureConfigurable.createPlaceFor((Configurable)this.myProjectConfig);
    }

    public ActionCallback select(@Nullable String moduleToSelect, @Nullable String editorNameToSelect, boolean requestFocus) {
        Place place = this.createModulesPlace();
        if (moduleToSelect != null) {
            Module module2 = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module2 != null);
            place = place.putPath("treeObject", (Object)module2).putPath("selectedEditor", (Object)editorNameToSelect);
        }
        return this.navigateTo(place, requestFocus);
    }

    public Place createModulesPlace() {
        return ProjectStructureConfigurable.createPlaceFor((Configurable)this.myModulesConfig);
    }

    public Place createModulePlace(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "createModulePlace"));
        }
        return this.createModulesPlace().putPath("treeObject", (Object)module2);
    }

    public ActionCallback select(@Nullable Facet facetToSelect, boolean requestFocus) {
        Place place = this.createModulesPlace();
        if (facetToSelect != null) {
            place = place.putPath("treeObject", (Object)facetToSelect);
        }
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback select(@NotNull Sdk sdk, boolean requestFocus) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "select"));
        }
        Place place = ProjectStructureConfigurable.createPlaceFor((Configurable)this.myJdkListConfig);
        place.putPath("treeName", (Object)sdk.getName());
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback selectGlobalLibraries(boolean requestFocus) {
        Place place = ProjectStructureConfigurable.createPlaceFor((Configurable)this.myGlobalLibrariesConfig);
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback selectProjectOrGlobalLibrary(@NotNull Library library, boolean requestFocus) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "selectProjectOrGlobalLibrary"));
        }
        Place place = this.createProjectOrGlobalLibraryPlace(library);
        return this.navigateTo(place, requestFocus);
    }

    public Place createProjectOrGlobalLibraryPlace(Library library) {
        Place place = ProjectStructureConfigurable.createPlaceFor((Configurable)this.getConfigurableFor(library));
        place.putPath("treeName", (Object)library.getName());
        return place;
    }

    public ActionCallback select(@Nullable Artifact artifact, boolean requestFocus) {
        Place place = this.createArtifactPlace(artifact);
        return this.navigateTo(place, requestFocus);
    }

    public Place createArtifactPlace(Artifact artifact) {
        Place place = ProjectStructureConfigurable.createPlaceFor((Configurable)this.myArtifactsStructureConfigurable);
        if (artifact != null) {
            place.putPath("treeName", (Object)artifact.getName());
        }
        return place;
    }

    public ActionCallback select(@NotNull LibraryOrderEntry libraryOrderEntry, boolean requestFocus) {
        if (libraryOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryOrderEntry", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "select"));
        }
        Library lib = libraryOrderEntry.getLibrary();
        if (lib == null || lib.getTable() == null) {
            return this.selectOrderEntry(libraryOrderEntry.getOwnerModule(), (OrderEntry)libraryOrderEntry);
        }
        Place place = ProjectStructureConfigurable.createPlaceFor((Configurable)this.getConfigurableFor(lib));
        place.putPath("treeName", (Object)libraryOrderEntry.getLibraryName());
        return this.navigateTo(place, requestFocus);
    }

    public ActionCallback selectOrderEntry(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/ProjectStructureConfigurable", "selectOrderEntry"));
        }
        return ModuleStructureConfigurable.getInstance(this.myProject).selectOrderEntry(module2, orderEntry);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        Configurable toSelect = (Configurable)place.getPath(CATEGORY);
        JComponent detailsContent = this.myDetails.getTargetComponent();
        if (this.mySelectedConfigurable != toSelect) {
            if (this.mySelectedConfigurable instanceof BaseStructureConfigurable) {
                ((BaseStructureConfigurable)this.mySelectedConfigurable).onStructureUnselected();
            }
            this.saveSideProportion();
            this.removeSelected();
            if (toSelect != null) {
                detailsContent = toSelect.createComponent();
                this.myDetails.setContent(detailsContent);
            }
            this.mySelectedConfigurable = toSelect;
            if (this.mySelectedConfigurable != null) {
                this.myUiState.lastEditedConfigurable = this.mySelectedConfigurable.getDisplayName();
            }
            if (toSelect instanceof MasterDetailsComponent) {
                MasterDetailsComponent masterDetails = (MasterDetailsComponent)toSelect;
                if (this.myUiState.sideProportion > 0.0f) {
                    masterDetails.getSplitter().setProportion(this.myUiState.sideProportion);
                }
                masterDetails.setHistory(this.myHistory);
            }
            if (toSelect instanceof DetailsComponent.Facade) {
                ((DetailsComponent.Facade)toSelect).getDetailsComponent().setBannerMinHeight(this.myToolbarComponent.getPreferredSize().height);
            }
            if (toSelect instanceof BaseStructureConfigurable) {
                ((BaseStructureConfigurable)toSelect).onStructureSelected();
            }
        }
        if (detailsContent != null) {
            JComponent toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(detailsContent);
            if (toFocus == null) {
                toFocus = detailsContent;
            }
            if (requestFocus) {
                this.myToFocus = toFocus;
                UIUtil.requestFocus((JComponent)toFocus);
            }
        }
        ActionCallback result = new ActionCallback();
        Place.goFurther((Object)toSelect, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
        this.myDetails.revalidate();
        this.myDetails.repaint();
        if (toSelect != null) {
            this.mySidePanel.select(ProjectStructureConfigurable.createPlaceFor(toSelect));
        }
        if (!this.myHistory.isNavigatingNow() && this.mySelectedConfigurable != null) {
            this.myHistory.pushQueryPlace();
        }
        return result;
    }

    private void saveSideProportion() {
        if (this.mySelectedConfigurable instanceof MasterDetailsComponent) {
            this.myUiState.sideProportion = ((MasterDetailsComponent)this.mySelectedConfigurable).getSplitter().getProportion();
        }
    }

    private void removeSelected() {
        this.myDetails.removeAll();
        this.mySelectedConfigurable = null;
        this.myUiState.lastEditedConfigurable = null;
        this.myDetails.add((Component)this.myEmptySelection, (Object)"Center");
    }

    public static ProjectStructureConfigurable getInstance(Project project2) {
        return (ProjectStructureConfigurable)((Object)ServiceManager.getService((Project)project2, ProjectStructureConfigurable.class));
    }

    public ProjectSdksModel getProjectJdksModel() {
        return this.myProjectJdksModel;
    }

    public JdkListConfigurable getJdkConfig() {
        return this.myJdkListConfig;
    }

    public ProjectLibrariesConfigurable getProjectLibrariesConfig() {
        return this.myProjectLibrariesConfig;
    }

    public GlobalLibrariesConfigurable getGlobalLibrariesConfig() {
        return this.myGlobalLibrariesConfig;
    }

    public ModuleStructureConfigurable getModulesConfig() {
        return this.myModulesConfig;
    }

    public ProjectConfigurable getProjectConfig() {
        return this.myProjectConfig;
    }

    private void addConfigurable(Configurable configurable, boolean addToSidePanel) {
        this.myName2Config.add(configurable);
        if (addToSidePanel) {
            this.mySidePanel.addPlace(ProjectStructureConfigurable.createPlaceFor(configurable), new Presentation(configurable.getDisplayName()));
        }
    }

    private static Place createPlaceFor(Configurable configurable) {
        return new Place().putPath(CATEGORY, (Object)configurable);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    public BaseLibrariesConfigurable getConfigurableFor(Library library) {
        if ("project".equals(library.getTable().getTableLevel())) {
            return this.myProjectLibrariesConfig;
        }
        return this.myGlobalLibrariesConfig;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToFocus;
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel() {
            super(new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (KEY.is(dataId)) {
                return ProjectStructureConfigurable.this;
            }
            if (History.KEY.is(dataId)) {
                return ProjectStructureConfigurable.this.getHistory();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)1024, (int)768);
        }
    }

    public static class UIState {
        public float proportion;
        public float sideProportion;
        public String lastEditedConfigurable;
    }
}

