/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonCheckinAction
extends AbstractVcsAction {
    private static final Logger LOG = Logger.getInstance(AbstractCommonCheckinAction.class);

    @Override
    public void actionPerformed(final @NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "actionPerformed"));
        }
        LOG.debug("actionPerformed. ");
        final Project project2 = context.getProject();
        if (project2 == null) {
            LOG.debug("project is null. returning.");
            return;
        }
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification("Can not " + this.getMnemonicsFreeActionName(context) + " now")) {
            LOG.debug("ChangeListManager is freezed. returning.");
            return;
        }
        if (ProjectLevelVcsManager.getInstance((Project)project2).isBackgroundVcsOperationRunning()) {
            LOG.debug("Background operation is running. returning.");
            return;
        }
        final FilePath[] roots = this.prepareRootsForCommit(this.getRoots(context), project2);
        ChangeListManager.getInstance((Project)project2).invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                AbstractCommonCheckinAction.this.performCheckIn(context, project2, roots);
            }
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
    }

    protected void performCheckIn(@NotNull VcsContext context, @NotNull Project project2, @NotNull FilePath[] roots) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "performCheckIn"));
        }
        LOG.debug("invoking commit dialog after update");
        LocalChangeList initialSelection = this.getInitiallySelectedChangeList(context, project2);
        Change[] changes = context.getSelectedChanges();
        if (changes != null && changes.length > 0) {
            CommitChangeListDialog.commitChanges(project2, Arrays.asList(changes), initialSelection, this.getExecutor(project2), null);
        } else {
            CommitChangeListDialog.commitPaths(project2, Arrays.asList(roots), initialSelection, this.getExecutor(project2), null);
        }
    }

    @NotNull
    protected FilePath[] prepareRootsForCommit(@NotNull FilePath[] roots, @NotNull Project project2) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().saveAll();
        }
        FilePath[] filePathArray = AbstractCommonCheckinAction.filterDescindingFiles(roots, project2);
        if (filePathArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/AbstractCommonCheckinAction", "prepareRootsForCommit"));
        }
        return filePathArray;
    }

    protected String getMnemonicsFreeActionName(VcsContext context) {
        return this.getActionName(context);
    }

    @Nullable
    protected CommitExecutor getExecutor(Project project2) {
        return null;
    }

    @Nullable
    protected LocalChangeList getInitiallySelectedChangeList(VcsContext context, Project project2) {
        Change[] selectedChanges;
        ChangeList[] selectedChangeLists = context.getSelectedChangeLists();
        LocalChangeList initialSelection = selectedChangeLists != null && selectedChangeLists.length > 0 ? ChangeListManager.getInstance((Project)project2).findChangeList(selectedChangeLists[0].getName()) : ((selectedChanges = context.getSelectedChanges()) != null && selectedChanges.length > 0 ? ChangeListManager.getInstance((Project)project2).getChangeList(selectedChanges[0]) : ChangeListManager.getInstance((Project)project2).getDefaultChangeList());
        return initialSelection;
    }

    @Nullable
    protected static AbstractVcs getCommonVcsFor(FilePath[] roots, Project project2) {
        if (roots.length == 0) {
            return null;
        }
        AbstractVcs firstVcs = VcsUtil.getVcsFor((Project)project2, (FilePath)roots[0]);
        if (firstVcs == null) {
            return null;
        }
        for (FilePath file2 : roots) {
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project2, (FilePath)file2);
            if (vcs == null) {
                return null;
            }
            if (firstVcs == vcs) continue;
            return null;
        }
        return firstVcs;
    }

    protected abstract String getActionName(@NotNull VcsContext var1);

    @NotNull
    protected abstract FilePath[] getRoots(@NotNull VcsContext var1);

    protected abstract boolean approximatelyHasRoots(VcsContext var1);

    @Override
    protected void update(VcsContext vcsContext, Presentation presentation) {
        Project project2 = vcsContext.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        ProjectLevelVcsManager plVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        if (!plVcsManager.hasActiveVcss()) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        if (!this.approximatelyHasRoots(vcsContext)) {
            presentation.setEnabled(false);
            return;
        }
        String actionName = this.getActionName(vcsContext) + "...";
        presentation.setText(actionName);
        presentation.setEnabled(!plVcsManager.isBackgroundVcsOperationRunning());
        presentation.setVisible(true);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected abstract boolean filterRootsBeforeAction();

    protected static FilePath[] getAllContentRoots(VcsContext context) {
        VirtualFile[] roots;
        Project project2 = context.getProject();
        ArrayList<FilePath> virtualFiles = new ArrayList<FilePath>();
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project2);
        for (VirtualFile root : roots = manager.getAllVersionedRoots()) {
            virtualFiles.add(VcsUtil.getFilePath((VirtualFile)root));
        }
        return virtualFiles.toArray(new FilePath[virtualFiles.size()]);
    }
}

