/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.actions.SplittingIterator;
import java.util.ArrayList;
import java.util.List;

public class ContentsLines {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.actions.ContentsLines");
    private final SplittingIterator mySplittingIterator;
    private final List<Integer> myLinesStartOffsets;
    private final String myContents;
    private boolean myLineEndsFinished;

    public ContentsLines(String contents) {
        this.myContents = contents;
        this.mySplittingIterator = new SplittingIterator(contents);
        this.myLinesStartOffsets = new ArrayList<Integer>();
    }

    public String getLineContents(int number) {
        assert (!this.myLineEndsFinished || this.myLinesStartOffsets.size() > number);
        if (this.myLineEndsFinished || this.myLinesStartOffsets.size() > number + 1) {
            return this.extractCalculated(number);
        }
        while (this.myLinesStartOffsets.size() - 1 < number + 1 && !this.myLineEndsFinished && this.mySplittingIterator.hasNext()) {
            Integer nextStart = this.mySplittingIterator.next();
            this.myLinesStartOffsets.add(nextStart);
        }
        this.myLineEndsFinished = this.myLinesStartOffsets.size() < number + 1;
        return this.extractCalculated(number);
    }

    private String extractCalculated(int number) {
        try {
            String text = this.myContents.substring(this.myLinesStartOffsets.get(number), number + 1 >= this.myLinesStartOffsets.size() ? this.myContents.length() : this.myLinesStartOffsets.get(number + 1).intValue());
            text = text.endsWith("\r\n") ? text.substring(0, text.length() - 2) : text;
            text = text.endsWith("\r") || text.endsWith("\n") ? text.substring(0, text.length() - 1) : text;
            return text;
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error("Loaded contents lines: " + StringUtil.getLineBreakCount((CharSequence)this.myContents), (Throwable)e);
            throw e;
        }
    }

    public boolean isLineEndsFinished() {
        return this.myLineEndsFinished;
    }

    public int getKnownLinesNumber() {
        return this.myLineEndsFinished ? this.myLinesStartOffsets.size() : -1;
    }
}

