/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class CompoundShelfFileProcessor {
    private final File shelfDir;

    public CompoundShelfFileProcessor(@NotNull File shelfDir) {
        if (shelfDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shelfDir", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "<init>"));
        }
        this.shelfDir = shelfDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePathFile(@NotNull ContentProvider contentProvider, @NotNull File patchPath, @NotNull CommitContext commitContext) throws IOException {
        if (contentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentProvider", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "savePathFile"));
        }
        if (patchPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchPath", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "savePathFile"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "savePathFile"));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(patchPath), CharsetToolkit.UTF8_CHARSET);){
            contentProvider.writeContentTo(writer, commitContext);
        }
    }

    @NotNull
    public File getBaseDir() {
        File file2 = this.shelfDir;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/CompoundShelfFileProcessor", "getBaseDir"));
        }
        return file2;
    }

    public static interface ContentProvider {
        public void writeContentTo(@NotNull Writer var1, @NotNull CommitContext var2) throws IOException;
    }
}

