/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.PatchEP;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.SelectFilesToAddTextsToPatchPanel;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcessor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.FilesProgress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesManager
extends AbstractProjectComponent
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager");
    @NonNls
    private static final String ELEMENT_CHANGELIST = "changelist";
    @NonNls
    private static final String ELEMENT_RECYCLED_CHANGELIST = "recycled_changelist";
    @NonNls
    private static final String DEFAULT_PATCH_NAME = "shelved";
    @NonNls
    private static final String REMOVE_FILES_FROM_SHELF_STRATEGY = "remove_strategy";
    @NotNull
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    @NotNull
    private final SchemesManager<ShelvedChangeList, ShelvedChangeList> mySchemeManager;
    private boolean myRemoveFilesFromShelf;
    private static final String SHELVE_MANAGER_DIR_PATH = "shelf";
    private final MessageBus myBus;
    @NonNls
    private static final String ATTRIBUTE_SHOW_RECYCLED = "show_recycled";
    @NotNull
    private final CompoundShelfFileProcessor myFileProcessor;
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);
    private boolean myShowRecycled;

    public static ShelveChangesManager getInstance(Project project2) {
        return (ShelveChangesManager)((Object)PeriodicalTasksCloser.getInstance().safeGetComponent(project2, ShelveChangesManager.class));
    }

    public ShelveChangesManager(Project project2, MessageBus bus) {
        super(project2);
        this.myPathMacroSubstitutor = PathMacroManager.getInstance((ComponentManager)this.myProject).createTrackingSubstitutor();
        this.myBus = bus;
        this.mySchemeManager = SchemesManagerFactory.getInstance((Project)project2).create(SHELVE_MANAGER_DIR_PATH, (SchemeProcessor)new SchemeProcessor<ShelvedChangeList>(){

            @Nullable
            public ShelvedChangeList readScheme(@NotNull Element element) throws InvalidDataException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$1", "readScheme"));
                }
                return ShelveChangesManager.this.readOneShelvedChangeList(element);
            }

            public Parent writeScheme(@NotNull ShelvedChangeList scheme) throws WriteExternalException {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$1", "writeScheme"));
                }
                Element child = new Element(ShelveChangesManager.ELEMENT_CHANGELIST);
                scheme.writeExternal(child);
                ShelveChangesManager.this.myPathMacroSubstitutor.collapsePaths(child);
                return child;
            }
        });
        File shelfDirectory = this.mySchemeManager.getRootDirectory();
        this.myFileProcessor = new CompoundShelfFileProcessor(shelfDirectory);
        if (shelfDirectory.exists()) {
            ChangeListManager.getInstance((Project)project2).addDirectoryToIgnoreImplicitly(shelfDirectory.getAbsolutePath());
        }
    }

    public void projectOpened() {
        try {
            this.mySchemeManager.loadSchemes();
            this.filterNonValidShelvedChangeLists();
        }
        catch (Exception e) {
            LOG.error("Couldn't read shelf information", (Throwable)e);
        }
    }

    private void filterNonValidShelvedChangeLists() {
        ArrayList allSchemes = ContainerUtil.newArrayList((Iterable)this.mySchemeManager.getAllSchemes());
        ContainerUtil.process((List)allSchemes, (Processor)new Processor<ShelvedChangeList>(){

            public boolean process(ShelvedChangeList shelvedChangeList) {
                if (!shelvedChangeList.isValid()) {
                    ShelveChangesManager.this.mySchemeManager.removeScheme((Scheme)shelvedChangeList);
                }
                return true;
            }
        });
    }

    @NotNull
    public File getShelfResourcesDirectory() {
        File file2 = this.myFileProcessor.getBaseDir();
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getShelfResourcesDirectory"));
        }
        return file2;
    }

    @NotNull
    private ShelvedChangeList readOneShelvedChangeList(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "readOneShelvedChangeList"));
        }
        ShelvedChangeList data = new ShelvedChangeList();
        this.myPathMacroSubstitutor.expandPaths(element);
        data.readExternal(element);
        ShelvedChangeList shelvedChangeList = data;
        if (shelvedChangeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "readOneShelvedChangeList"));
        }
        return shelvedChangeList;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelveChangesManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getComponentName"));
        }
        return "ShelveChangesManager";
    }

    public void readExternal(Element element) throws InvalidDataException {
        String showRecycled = element.getAttributeValue(ATTRIBUTE_SHOW_RECYCLED);
        this.myShowRecycled = showRecycled == null || Boolean.parseBoolean(showRecycled);
        String removeFilesStrategy = JDOMExternalizerUtil.readField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY);
        this.myRemoveFilesFromShelf = removeFilesStrategy != null && Boolean.parseBoolean(removeFilesStrategy);
        this.migrateOldShelfInfo(element, true);
        this.migrateOldShelfInfo(element, false);
    }

    private void migrateOldShelfInfo(@NotNull Element element, boolean recycled) throws InvalidDataException {
        Element changeSetElement;
        ShelvedChangeList list;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "migrateOldShelfInfo"));
        }
        Iterator iterator = element.getChildren(recycled ? ELEMENT_RECYCLED_CHANGELIST : ELEMENT_CHANGELIST).iterator();
        while (iterator.hasNext() && (list = this.readOneShelvedChangeList(changeSetElement = (Element)iterator.next())).isValid()) {
            File uniqueDir = this.generateUniqueSchemePatchDir(list.DESCRIPTION, false);
            list.setName(uniqueDir.getName());
            list.setRecycled(recycled);
            this.mySchemeManager.addNewScheme((Scheme)list, false);
        }
    }

    @NotNull
    public Collection<String> checkAndMigrateOldPatchResourcesToNewSchemeStorage() {
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        for (ShelvedChangeList list : this.mySchemeManager.getAllSchemes()) {
            File patchDir = new File(this.myFileProcessor.getBaseDir(), list.getName());
            nonMigratedPaths.addAll(ShelveChangesManager.migrateIfNeededToSchemeDir(list, patchDir));
        }
        ArrayList arrayList = nonMigratedPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "checkAndMigrateOldPatchResourcesToNewSchemeStorage"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> migrateIfNeededToSchemeDir(@NotNull ShelvedChangeList list, @NotNull File targetDirectory) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "migrateIfNeededToSchemeDir"));
        }
        if (targetDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDirectory", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "migrateIfNeededToSchemeDir"));
        }
        if (targetDirectory.exists() || !targetDirectory.mkdirs()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "migrateIfNeededToSchemeDir"));
            }
            return list2;
        }
        ArrayList nonMigratedPaths = ContainerUtil.newArrayList();
        File patchFile = new File(list.PATH);
        if (patchFile.exists()) {
            File newPatchFile = ShelveChangesManager.getPatchFileInConfigDir(targetDirectory);
            try {
                FileUtil.copy((File)patchFile, (File)newPatchFile);
                list.PATH = FileUtil.toSystemIndependentName((String)newPatchFile.getPath());
                FileUtil.delete((File)patchFile);
            }
            catch (IOException e) {
                nonMigratedPaths.add(list.PATH);
            }
        }
        for (ShelvedBinaryFile file2 : list.getBinaryFiles()) {
            if (file2.SHELVED_PATH == null) continue;
            File shelvedFile = new File(file2.SHELVED_PATH);
            if (StringUtil.isEmptyOrSpaces((String)file2.AFTER_PATH) || !shelvedFile.exists()) continue;
            File newShelvedFile = new File(targetDirectory, PathUtil.getFileName((String)file2.AFTER_PATH));
            try {
                FileUtil.copy((File)shelvedFile, (File)newShelvedFile);
                file2.SHELVED_PATH = FileUtil.toSystemIndependentName((String)newShelvedFile.getPath());
                FileUtil.delete((File)shelvedFile);
            }
            catch (IOException e) {
                nonMigratedPaths.add(shelvedFile.getPath());
            }
        }
        ArrayList arrayList = nonMigratedPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "migrateIfNeededToSchemeDir"));
        }
        return arrayList;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_SHOW_RECYCLED, Boolean.toString(this.myShowRecycled));
        JDOMExternalizerUtil.writeField((Element)element, (String)REMOVE_FILES_FROM_SHELF_STRATEGY, (String)Boolean.toString(this.isRemoveFilesFromShelf()));
    }

    public List<ShelvedChangeList> getShelvedChangeLists() {
        return this.getRecycled(false);
    }

    @NotNull
    private List<ShelvedChangeList> getRecycled(final boolean recycled) {
        List list = ContainerUtil.newUnmodifiableList((List)ContainerUtil.filter((Collection)this.mySchemeManager.getAllSchemes(), (Condition)new Condition<ShelvedChangeList>(){

            public boolean value(ShelvedChangeList list) {
                return recycled ? list.isRecycled() : !list.isRecycled();
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getRecycled"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage, boolean rollback) throws IOException, VcsException {
        ShelvedChangeList changeList;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText(VcsBundle.message((String)"shelve.changes.progress.title", (Object[])new Object[0]));
        }
        File schemePatchDir = this.generateUniqueSchemePatchDir(commitMessage, true);
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(schemePatchDir, change));
                continue;
            }
            textChanges.add(change);
        }
        try {
            File patchPath = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            ProgressManager.checkCanceled();
            final List patches = IdeaTextPatchBuilder.buildPatch((Project)this.myProject, textChanges, (String)this.myProject.getBaseDir().getPresentableUrl(), (boolean)false);
            ProgressManager.checkCanceled();
            CommitContext commitContext = new CommitContext();
            this.baseRevisionsOfDvcsIntoContext(textChanges, commitContext);
            this.myFileProcessor.savePathFile(new CompoundShelfFileProcessor.ContentProvider(){

                @Override
                public void writeContentTo(@NotNull Writer writer, @NotNull CommitContext commitContext) throws IOException {
                    if (writer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$4", "writeContentTo"));
                    }
                    if (commitContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$4", "writeContentTo"));
                    }
                    UnifiedDiffWriter.write((Project)ShelveChangesManager.this.myProject, (Collection)patches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
                }
            }, patchPath, commitContext);
            changeList = new ShelvedChangeList(patchPath.toString(), commitMessage.replace('\n', ' '), binaryFiles);
            changeList.setName(schemePatchDir.getName());
            ProgressManager.checkCanceled();
            this.mySchemeManager.addNewScheme((Scheme)changeList, false);
            if (rollback) {
                boolean modalContext;
                String operationName = UIUtil.removeMnemonic((String)RollbackChangesDialog.operationNameByChanges(this.myProject, changes));
                boolean bl = modalContext = ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext();
                if (progressIndicator != null) {
                    progressIndicator.startNonCancelableSection();
                }
                new RollbackWorker(this.myProject, operationName, modalContext).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return changeList;
    }

    @NotNull
    private static File getPatchFileInConfigDir(@NotNull File schemePatchDir) {
        if (schemePatchDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemePatchDir", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getPatchFileInConfigDir"));
        }
        File file2 = new File(schemePatchDir, "shelved.patch");
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "getPatchFileInConfigDir"));
        }
        return file2;
    }

    private void baseRevisionsOfDvcsIntoContext(List<Change> textChanges, CommitContext commitContext) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (vcsManager.dvcsUsedInProject() && VcsConfiguration.getInstance((Project)this.myProject).INCLUDE_TEXT_INTO_SHELF) {
            Set<Change> big = SelectFilesToAddTextsToPatchPanel.getBig(textChanges);
            ArrayList<FilePath> toKeep = new ArrayList<FilePath>();
            for (Change change : textChanges) {
                FilePath filePath;
                AbstractVcs vcs;
                if (change.getBeforeRevision() == null || change.getAfterRevision() == null || big.contains(change) || (vcs = vcsManager.getVcsFor(filePath = ChangesUtil.getFilePath((Change)change))) == null || !VcsType.distributed.equals((Object)vcs.getType())) continue;
                toKeep.add(filePath);
            }
            commitContext.putUserData(BaseRevisionTextPatchEP.ourPutBaseRevisionTextKey, (Object)true);
            commitContext.putUserData(BaseRevisionTextPatchEP.ourBaseRevisionPaths, toKeep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList importFilePatches(String fileName, final List<FilePatch> patches, final PatchEP[] patchTransitExtensions) throws IOException {
        try {
            File schemePatchDir = this.generateUniqueSchemePatchDir(fileName, true);
            File patchPath = ShelveChangesManager.getPatchFileInConfigDir(schemePatchDir);
            this.myFileProcessor.savePathFile(new CompoundShelfFileProcessor.ContentProvider(){

                @Override
                public void writeContentTo(@NotNull Writer writer, @NotNull CommitContext commitContext) throws IOException {
                    if (writer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$5", "writeContentTo"));
                    }
                    if (commitContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$5", "writeContentTo"));
                    }
                    UnifiedDiffWriter.write((Project)ShelveChangesManager.this.myProject, (Collection)patches, (Writer)writer, (String)"\n", (PatchEP[])patchTransitExtensions, (CommitContext)commitContext);
                }
            }, patchPath, new CommitContext());
            ShelvedChangeList changeList = new ShelvedChangeList(patchPath.toString(), fileName.replace('\n', ' '), (List<ShelvedBinaryFile>)new SmartList());
            changeList.setName(schemePatchDir.getName());
            this.mySchemeManager.addNewScheme((Scheme)changeList, false);
            ShelvedChangeList shelvedChangeList = changeList;
            return shelvedChangeList;
        }
        finally {
            this.notifyStateChanged();
        }
    }

    public List<VirtualFile> gatherPatchFiles(Collection<VirtualFile> files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        LinkedList<VirtualFile> filesQueue = new LinkedList<VirtualFile>(files);
        while (!filesQueue.isEmpty()) {
            ProgressManager.checkCanceled();
            VirtualFile file2 = filesQueue.removeFirst();
            if (file2.isDirectory()) {
                filesQueue.addAll(Arrays.asList(file2.getChildren()));
                continue;
            }
            if (!"PATCH".equals(file2.getFileType().getName())) continue;
            result.add(file2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShelvedChangeList> importChangeLists(Collection<VirtualFile> files, Consumer<VcsException> exceptionConsumer) {
        ArrayList<ShelvedChangeList> result = new ArrayList<ShelvedChangeList>(files.size());
        try {
            FilesProgress filesProgress = new FilesProgress(files.size(), "Processing ");
            for (VirtualFile file2 : files) {
                filesProgress.updateIndicator(file2);
                String description = file2.getNameWithoutExtension().replace('_', ' ');
                File schemeNameDir = this.generateUniqueSchemePatchDir(description, true);
                File patchPath = ShelveChangesManager.getPatchFileInConfigDir(schemeNameDir);
                ShelvedChangeList list = new ShelvedChangeList(patchPath.getPath(), description, (List<ShelvedBinaryFile>)new SmartList(), file2.getTimeStamp());
                list.setName(schemeNameDir.getName());
                try {
                    List<TextFilePatch> patchesList = ShelveChangesManager.loadPatches(this.myProject, file2.getPath(), new CommitContext());
                    if (patchesList.isEmpty()) continue;
                    FileUtil.copy((File)new File(file2.getPath()), (File)patchPath);
                    this.mySchemeManager.addNewScheme((Scheme)list, false);
                    result.add(list);
                }
                catch (IOException e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
                catch (PatchSyntaxException e) {
                    exceptionConsumer.consume((Object)new VcsException((Throwable)e));
                }
            }
        }
        finally {
            this.notifyStateChanged();
        }
        return result;
    }

    private ShelvedBinaryFile shelveBinaryFile(@NotNull File schemePatchDir, Change change) throws IOException {
        if (schemePatchDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemePatchDir", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "shelveBinaryFile"));
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            File shelvedFile = new File(schemePatchDir, afterFile.getName());
            FileUtil.copy((File)afterRevision.getFile().getIOFile(), (File)shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        if (!this.myProject.isDisposed()) {
            ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent((Object)this));
        }
    }

    @NotNull
    private File generateUniqueSchemePatchDir(@NotNull String defaultName, boolean createResourceDirectory) {
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "generateUniqueSchemePatchDir"));
        }
        this.ignoreShelfDirectoryIfFirstShelf();
        String uniqueName = UniqueNameGenerator.generateUniqueName((String)ShelveChangesManager.shortenAndSanitize(defaultName), (Collection)this.mySchemeManager.getAllSchemeNames());
        File dir = new File(this.myFileProcessor.getBaseDir(), uniqueName);
        if (createResourceDirectory && !dir.exists()) {
            dir.mkdirs();
        }
        File file2 = dir;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "generateUniqueSchemePatchDir"));
        }
        return file2;
    }

    private void ignoreShelfDirectoryIfFirstShelf() {
        File shelfDir = this.getShelfResourcesDirectory();
        if (!shelfDir.exists()) {
            ChangeListManager.getInstance((Project)this.myProject).addDirectoryToIgnoreImplicitly(shelfDir.getAbsolutePath());
        }
    }

    @NotNull
    public static File suggestPatchName(Project project2, @NotNull String commitMessage, File file2, String extension) {
        File nonexistentFile;
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "suggestPatchName"));
        }
        String defaultPath = ShelveChangesManager.shortenAndSanitize(commitMessage);
        while ((nonexistentFile = FileUtil.findSequentNonexistentFile((File)file2, (String)defaultPath, (String)(extension == null ? VcsConfiguration.getInstance((Project)project2).getPatchFileExtension() : extension))).getName().length() >= 100) {
            defaultPath = defaultPath.substring(0, defaultPath.length() - 1);
        }
        File file3 = nonexistentFile;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "suggestPatchName"));
        }
        return file3;
    }

    @NotNull
    private static String shortenAndSanitize(@NotNull String commitMessage) {
        if (commitMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitMessage", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "shortenAndSanitize"));
        }
        String defaultPath = FileUtil.sanitizeFileName((String)commitMessage);
        if (defaultPath.isEmpty()) {
            defaultPath = "unnamed";
        }
        if (defaultPath.length() > 90) {
            defaultPath = defaultPath.substring(0, 90);
        }
        String string = defaultPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "shortenAndSanitize"));
        }
        return string;
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification) {
        this.unshelveChangeList(changeList, changes, binaryFiles, targetChangeList, showSuccessNotification, false, false, null, null);
    }

    public void unshelveChangeList(final ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, final @Nullable LocalChangeList targetChangeList, final boolean showSuccessNotification, final boolean systemOperation, final boolean reverse, final String leftConflictTitle, final String rightConflictTitle) {
        List<TextFilePatch> textFilePatches;
        final ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        final CommitContext commitContext = new CommitContext();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(this.myProject, changeList, changes, remainingPatches, commitContext);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
            return;
        }
        catch (PatchSyntaxException e) {
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
            LOG.info((Throwable)e);
            return;
        }
        final ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        final ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                BinaryPatchApplier binaryPatchApplier = new BinaryPatchApplier();
                PatchApplier<ShelvedBinaryFilePatch> patchApplier = new PatchApplier<ShelvedBinaryFilePatch>(ShelveChangesManager.this.myProject, ShelveChangesManager.this.myProject.getBaseDir(), (List<FilePatch>)patches, targetChangeList, binaryPatchApplier, commitContext, reverse, leftConflictTitle, rightConflictTitle);
                patchApplier.setIsSystemOperation(systemOperation);
                if (ShelveChangesManager.this.isRemoveFilesFromShelf() || systemOperation) {
                    remainingPatches.addAll(patchApplier.getRemainingPatches());
                    if (remainingPatches.isEmpty() && remainingBinaries.isEmpty()) {
                        ShelveChangesManager.this.recycleChangeList(changeList);
                    } else {
                        ShelveChangesManager.this.saveRemainingPatches(changeList, remainingPatches, remainingBinaries, commitContext);
                    }
                }
                patchApplier.execute(showSuccessNotification, systemOperation);
            }
        }, ModalityState.defaultModalityState());
    }

    private static List<TextFilePatch> loadTextPatches(Project project2, ShelvedChangeList changeList, List<ShelvedChange> changes, List<FilePatch> remainingPatches, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(project2, changeList.PATH, commitContext);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    public void setRemoveFilesFromShelf(boolean removeFilesFromShelf) {
        this.myRemoveFilesFromShelf = removeFilesFromShelf;
    }

    public boolean isRemoveFilesFromShelf() {
        return this.myRemoveFilesFromShelf;
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file2 : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file2)) {
                result.add(file2);
                continue;
            }
            remainingBinaries.add(file2);
        }
        return result;
    }

    private void unshelveBinaryFile(ShelvedBinaryFile file2, final @NotNull VirtualFile patchTarget) throws IOException {
        if (patchTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patchTarget", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "unshelveBinaryFile"));
        }
        final Ref ex = new Ref();
        final Ref patchedFileRef = new Ref();
        final File shelvedFile = file2.SHELVED_PATH == null ? null : new File(file2.SHELVED_PATH);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    if (shelvedFile == null) {
                        patchTarget.delete((Object)this);
                    } else {
                        patchTarget.setBinaryContent(FileUtil.loadFileBytes((File)shelvedFile));
                        patchedFileRef.set((Object)patchTarget);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            }
        });
        if (!ex.isNull()) {
            throw (IOException)ex.get();
        }
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes) {
        for (ShelvedChange change : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatchesToFile(Project project2, String path, List<FilePatch> remainingPatches, CommitContext commitContext) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), CharsetToolkit.UTF8_CHARSET);){
            UnifiedDiffWriter.write((Project)project2, remainingPatches, (Writer)writer, (String)"\n", (CommitContext)commitContext);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveRemainingPatches(ShelvedChangeList changeList, List<FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries, CommitContext commitContext) {
        File newPatchDir = this.generateUniqueSchemePatchDir(changeList.DESCRIPTION, true);
        File newPath = ShelveChangesManager.getPatchFileInConfigDir(newPatchDir);
        try {
            FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        }
        catch (IOException e) {
            return;
        }
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles()));
        listCopy.setName(newPatchDir.getName());
        listCopy.DATE = changeList.DATE == null ? null : new Date(changeList.DATE.getTime());
        ShelveChangesManager.writePatchesToFile(this.myProject, changeList.PATH, remainingPatches, commitContext);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.clearLoadedChanges();
        this.recycleChangeList(listCopy, changeList);
        this.mySchemeManager.addNewScheme((Scheme)listCopy, false);
        this.notifyStateChanged();
    }

    public void restoreList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "restoreList"));
        }
        ShelvedChangeList list = (ShelvedChangeList)this.mySchemeManager.findSchemeByName(changeList.getName());
        if (list != null) {
            list.setRecycled(false);
        }
        this.notifyStateChanged();
    }

    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.getRecycled(true);
    }

    public void clearRecycled() {
        for (ShelvedChangeList list : this.getRecycledShelvedChangeLists()) {
            this.deleteListImpl(list);
            this.mySchemeManager.removeScheme((Scheme)list);
        }
        this.notifyStateChanged();
    }

    private void recycleChangeList(@NotNull ShelvedChangeList listCopy, @Nullable ShelvedChangeList newList) {
        if (listCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listCopy", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "recycleChangeList"));
        }
        if (newList != null) {
            Iterator<ShelvedBinaryFile> shelvedChangeListIterator = listCopy.getBinaryFiles().iterator();
            while (shelvedChangeListIterator.hasNext()) {
                ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
                for (ShelvedBinaryFile newBinary : newList.getBinaryFiles()) {
                    if (!Comparing.equal((String)newBinary.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)newBinary.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                    shelvedChangeListIterator.remove();
                }
            }
            Iterator<ShelvedChange> iterator = listCopy.getChanges(this.myProject).iterator();
            while (iterator.hasNext()) {
                ShelvedChange change = iterator.next();
                for (ShelvedChange newChange : newList.getChanges(this.myProject)) {
                    if (!Comparing.equal((String)change.getBeforePath(), (String)newChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)newChange.getAfterPath())) continue;
                    iterator.remove();
                }
            }
            try {
                CommitContext commitContext = new CommitContext();
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
                for (ShelvedChange change : listCopy.getChanges(this.myProject)) {
                    patches.add((FilePatch)change.loadFilePatch(this.myProject, commitContext));
                }
                ShelveChangesManager.writePatchesToFile(this.myProject, listCopy.PATH, patches, commitContext);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (PatchSyntaxException e) {
                LOG.info((Throwable)e);
            }
        }
        if (!listCopy.getBinaryFiles().isEmpty() || !listCopy.getChanges(this.myProject).isEmpty()) {
            listCopy.setRecycled(true);
            this.notifyStateChanged();
        }
    }

    public void recycleChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "recycleChangeList"));
        }
        this.recycleChangeList(changeList, null);
        this.notifyStateChanged();
    }

    public void deleteChangeList(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "deleteChangeList"));
        }
        this.deleteListImpl(changeList);
        this.mySchemeManager.removeScheme((Scheme)changeList);
        this.notifyStateChanged();
    }

    private void deleteListImpl(@NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "deleteListImpl"));
        }
        FileUtil.delete((File)new File(this.myFileProcessor.getBaseDir(), changeList.getName()));
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    @NotNull
    public static List<TextFilePatch> loadPatches(Project project2, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project2, patchPath, commitContext, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "loadPatches"));
        }
        return list;
    }

    @NotNull
    static List<? extends FilePatch> loadPatchesWithoutContent(Project project2, String patchPath, CommitContext commitContext) throws IOException, PatchSyntaxException {
        List<TextFilePatch> list = ShelveChangesManager.loadPatches(project2, patchPath, commitContext, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager", "loadPatchesWithoutContent"));
        }
        return list;
    }

    private static List<TextFilePatch> loadPatches(Project project2, String patchPath, CommitContext commitContext, boolean loadContent) throws IOException, PatchSyntaxException {
        char[] text = FileUtil.loadFileText((File)new File(patchPath), (String)"UTF-8");
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text), loadContent);
        List textFilePatches = reader.readAllPatches();
        TransparentlyFailedValueI additionalInfo = reader.getAdditionalInfo(null);
        ApplyPatchDefaultExecutor.applyAdditionalInfoBefore(project2, (TransparentlyFailedValueI<Map<String, Map<String, CharSequence>>, PatchSyntaxException>)additionalInfo, commitContext);
        return textFilePatches;
    }

    public boolean isShowRecycled() {
        return this.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myShowRecycled = showRecycled;
        this.notifyStateChanged();
    }

    private class BinaryPatchApplier
    implements CustomBinaryPatchApplier<ShelvedBinaryFilePatch> {
        private final List<FilePatch> myAppliedPatches = new ArrayList<FilePatch>();

        private BinaryPatchApplier() {
        }

        @Override
        @NotNull
        public ApplyPatchStatus apply(List<Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>>> patches) throws IOException {
            for (Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>> patch : patches) {
                ShelvedBinaryFilePatch shelvedPatch = (ShelvedBinaryFilePatch)((Object)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                ShelveChangesManager.this.unshelveBinaryFile(shelvedPatch.getShelvedBinaryFile(), (VirtualFile)patch.getFirst());
                this.myAppliedPatches.add(shelvedPatch);
            }
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier", "apply"));
            }
            return applyPatchStatus;
        }

        @Override
        @NotNull
        public List<FilePatch> getAppliedPatches() {
            List<FilePatch> list = this.myAppliedPatches;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier", "getAppliedPatches"));
            }
            return list;
        }
    }
}

