/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeSmellInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.CodeSmellDetector;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerUtil;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CodeAnalysisBeforeCheckinHandler
extends CheckinHandler {
    private final Project myProject;
    private final CheckinProjectPanel myCheckinPanel;
    private static final Logger LOG = Logger.getInstance((String)("#" + CodeAnalysisBeforeCheckinHandler.class.getName()));

    public CodeAnalysisBeforeCheckinHandler(Project project2, CheckinProjectPanel panel) {
        this.myProject = project2;
        this.myCheckinPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        NonFocusableCheckBox checkBox = new NonFocusableCheckBox(VcsBundle.message((String)"before.checkin.standard.options.check.smells", (Object[])new Object[0]));
        return new RefreshableOnComponent((JCheckBox)checkBox){
            final /* synthetic */ JCheckBox val$checkBox;
            {
                this.val$checkBox = jCheckBox;
            }

            public JComponent getComponent() {
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(this.val$checkBox);
                CheckinHandlerUtil.disableWhenDumb(CodeAnalysisBeforeCheckinHandler.this.myProject, this.val$checkBox, "Code analysis is impossible until indices are up-to-date");
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                ((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT = this.val$checkBox.isSelected();
            }

            public void restoreState() {
                this.val$checkBox.setSelected(((CodeAnalysisBeforeCheckinHandler)CodeAnalysisBeforeCheckinHandler.this).getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    private VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    private CheckinHandler.ReturnResult processFoundCodeSmells(List<CodeSmellInfo> codeSmells, @Nullable CommitExecutor executor) {
        int errorCount = CodeAnalysisBeforeCheckinHandler.collectErrors(codeSmells);
        int warningCount = codeSmells.size() - errorCount;
        String commitButtonText = executor != null ? executor.getActionText() : this.myCheckinPanel.getCommitActionName();
        commitButtonText = StringUtil.trimEnd((String)commitButtonText, (String)"...");
        int answer = Messages.showYesNoCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"before.commit.files.contain.code.smells.edit.them.confirm.text", (Object[])new Object[]{errorCount, warningCount}), (String)VcsBundle.message((String)"code.smells.error.messages.tab.name", (Object[])new Object[0]), (String)VcsBundle.message((String)"code.smells.review.button", (Object[])new Object[0]), (String)commitButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)UIUtil.getWarningIcon());
        if (answer == 0) {
            CodeSmellDetector.getInstance(this.myProject).showCodeSmellErrors(codeSmells);
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }
        if (answer == 2) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }

    private static int collectErrors(List<CodeSmellInfo> codeSmells) {
        int result = 0;
        for (CodeSmellInfo codeSmellInfo : codeSmells) {
            if (codeSmellInfo.getSeverity() != HighlightSeverity.ERROR) continue;
            ++result;
        }
        return result;
    }

    public CheckinHandler.ReturnResult beforeCheckin(CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        if (this.getSettings().CHECK_CODE_SMELLS_BEFORE_PROJECT_COMMIT) {
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)VcsBundle.message((String)"code.smells.error.indexing.message", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), (String)VcsBundle.message((String)"code.smells.error.indexing", (Object[])new Object[0]), (String)"&Wait", (String)"&Commit", null) == 0) {
                    return CheckinHandler.ReturnResult.CANCEL;
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            try {
                List<CodeSmellInfo> codeSmells = CodeSmellDetector.getInstance(this.myProject).findCodeSmells(CheckinHandlerUtil.filterOutGeneratedAndExcludedFiles(this.myCheckinPanel.getVirtualFiles(), this.myProject));
                if (!codeSmells.isEmpty()) {
                    return this.processFoundCodeSmells(codeSmells, executor);
                }
                return CheckinHandler.ReturnResult.COMMIT;
            }
            catch (ProcessCanceledException e) {
                return CheckinHandler.ReturnResult.CANCEL;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)("Code analysis failed with exception: " + e.getClass().getName() + ": " + e.getMessage()), (String)"Code analysis failed", (String)"&Commit", (String)"&Cancel", null) == 0) {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
                return CheckinHandler.ReturnResult.CANCEL;
            }
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }
}

