/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkout;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;

public class CheckoutAction
extends AnAction
implements DumbAware {
    private final CheckoutProvider myProvider;

    public CheckoutAction(CheckoutProvider provider) {
        super(provider.getVcsName());
        this.myProvider = provider;
    }

    public void actionPerformed(final AnActionEvent e) {
        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

            @Override
            public void run() {
                Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
                project2 = project2 == null ? ProjectManager.getInstance().getDefaultProject() : project2;
                CheckoutAction.this.myProvider.doCheckout(project2, CheckoutAction.this.getListener(project2));
            }
        });
    }

    protected CheckoutProvider.Listener getListener(Project project2) {
        return ProjectLevelVcsManager.getInstance((Project)project2).getCompositeCheckoutListener();
    }
}

