/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileWatchRequestModifier
implements Runnable {
    private static final Logger LOG = Logger.getInstance(FileWatchRequestModifier.class);
    private final Project myProject;
    private final NewMappings myNewMappings;
    private final Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> myDirectoryMappingWatches;
    private final LocalFileSystem myLfs;

    public FileWatchRequestModifier(Project project2, NewMappings newMappings, LocalFileSystem localFileSystem) {
        this.myLfs = localFileSystem;
        this.myProject = project2;
        this.myNewMappings = newMappings;
        this.myDirectoryMappingWatches = ContainerUtil.newHashMap();
    }

    @Override
    public void run() {
        if (!this.myProject.isInitialized() || this.myProject.isDisposed()) {
            return;
        }
        List<VcsDirectoryMapping> copy = this.myNewMappings.getDirectoryMappings();
        LinkedList added = ContainerUtil.newLinkedList(copy);
        added.removeAll(this.myDirectoryMappingWatches.keySet());
        LinkedList deleted = ContainerUtil.newLinkedList(this.myDirectoryMappingWatches.keySet());
        deleted.removeAll(copy);
        THashMap toAdd = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        for (Object mapping : added) {
            if (mapping.isDefaultMapping()) continue;
            toAdd.put(FileUtil.toCanonicalPath((String)mapping.getDirectory()), mapping);
        }
        LinkedList toRemove = ContainerUtil.newLinkedList();
        for (VcsDirectoryMapping mapping : deleted) {
            LocalFileSystem.WatchRequest removed;
            if (mapping.isDefaultMapping() || (removed = this.myDirectoryMappingWatches.remove(mapping)) == null) continue;
            toRemove.add(removed);
        }
        Set requests = this.myLfs.replaceWatchedRoots((Collection)toRemove, toAdd.keySet(), null);
        for (LocalFileSystem.WatchRequest request : requests) {
            VcsDirectoryMapping mapping = (VcsDirectoryMapping)toAdd.get(request.getRootPath());
            if (mapping != null) {
                this.myDirectoryMappingWatches.put(mapping, request);
                continue;
            }
            LOG.error("root=" + request.getRootPath() + " toAdd=" + ContainerUtil.newHashSet(toAdd.keySet()));
        }
    }
}

