/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeFileWatcherImpl
extends PluggableFileWatcher {
    private static final Logger LOG = Logger.getInstance(NativeFileWatcherImpl.class);
    private static final String PROPERTY_WATCHER_DISABLED = "idea.filewatcher.disabled";
    private static final String PROPERTY_WATCHER_EXECUTABLE_PATH = "idea.filewatcher.executable.path";
    private static final String ROOTS_COMMAND = "ROOTS";
    private static final String EXIT_COMMAND = "EXIT";
    private static final int MAX_PROCESS_LAUNCH_ATTEMPT_COUNT = 10;
    private ManagingFS myManagingFS;
    private FileWatcherNotificationSink myNotificationSink;
    private File myExecutable;
    private volatile MyProcessHandler myProcessHandler;
    private volatile int myStartAttemptCount = 0;
    private volatile boolean myIsShuttingDown = false;
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    private volatile List<String> myRecursiveWatchRoots = Collections.emptyList();
    private volatile List<String> myFlatWatchRoots = Collections.emptyList();
    private final String[] myLastChangedPaths = new String[2];
    private int myLastChangedPathIndex;

    public void initialize(@NotNull ManagingFS managingFS, @NotNull FileWatcherNotificationSink notificationSink) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managingFS", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "initialize"));
        }
        if (notificationSink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSink", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "initialize"));
        }
        this.myManagingFS = managingFS;
        this.myNotificationSink = notificationSink;
        boolean disabled = this.isDisabled();
        this.myExecutable = this.getExecutable();
        if (disabled) {
            LOG.info("Native file watcher is disabled");
        } else if (this.myExecutable == null) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.found", (Object[])new Object[0]), null);
        } else if (!this.myExecutable.canExecute()) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.exe.not.exe", (Object[])new Object[]{this.myExecutable}), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$1", "hyperlinkUpdate"));
                    }
                    ShowFilePathAction.openFile(NativeFileWatcherImpl.this.myExecutable);
                }
            });
        } else {
            try {
                this.startupProcess(false);
                LOG.info("Native file watcher is operational.");
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            }
        }
    }

    public void dispose() {
        this.myIsShuttingDown = true;
        this.shutdownProcess();
    }

    public boolean isOperational() {
        return this.myProcessHandler != null;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recursive", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "setWatchRoots"));
        }
        if (flat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flat", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl", "setWatchRoots"));
        }
        this.setWatchRoots(recursive, flat, false);
    }

    protected boolean isDisabled() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_WATCHER_DISABLED));
    }

    @Nullable
    protected File getExecutable() {
        String[] dirs;
        String execPath = System.getProperty(PROPERTY_WATCHER_EXECUTABLE_PATH);
        if (execPath != null) {
            return new File(execPath);
        }
        String[] names = null;
        String prefix = null;
        if (SystemInfo.isWindows) {
            String[] stringArray;
            if (SystemInfo.is64Bit) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "fsnotifier64.exe";
                stringArray = stringArray2;
                stringArray2[1] = "fsnotifier.exe";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "fsnotifier.exe";
            }
            names = stringArray;
            prefix = "win";
        } else if (SystemInfo.isMac) {
            names = new String[]{"fsnotifier"};
            prefix = "mac";
        } else if (SystemInfo.isLinux) {
            String arch = "arm".equals(SystemInfo.OS_ARCH) ? "-arm" : ("ppc".equals(SystemInfo.OS_ARCH) ? "-ppc" : "");
            String bits = SystemInfo.is64Bit ? "64" : "";
            names = new String[]{"fsnotifier" + arch + bits};
            prefix = "linux";
        }
        if (names == null) {
            return null;
        }
        for (String dir : dirs = new String[]{PathManager.getBinPath(), PathManager.getHomePath() + "/community/bin/" + prefix, PathManager.getBinPath() + '/' + prefix}) {
            for (String name : names) {
                File candidate = new File(dir, name);
                if (!candidate.exists()) continue;
                return candidate;
            }
        }
        return null;
    }

    private void notifyOnFailure(String cause, @Nullable NotificationListener listener2) {
        this.myNotificationSink.notifyUserOnFailure(cause, listener2);
    }

    private void startupProcess(boolean restart) throws IOException {
        if (this.myIsShuttingDown) {
            return;
        }
        if (ShutDownTracker.isShutdownHookRunning()) {
            this.myIsShuttingDown = true;
            return;
        }
        if (this.myStartAttemptCount++ > 10) {
            this.notifyOnFailure(ApplicationBundle.message((String)"watcher.failed.to.start", (Object[])new Object[0]), null);
            return;
        }
        if (restart) {
            this.shutdownProcess();
        }
        LOG.info("Starting file watcher: " + this.myExecutable);
        ProcessBuilder processBuilder = new ProcessBuilder(this.myExecutable.getAbsolutePath());
        Process process = processBuilder.start();
        this.myProcessHandler = new MyProcessHandler(process, this.myExecutable.getName());
        this.myProcessHandler.addProcessListener((ProcessListener)new MyProcessAdapter());
        this.myProcessHandler.startNotify();
        if (restart) {
            List<String> recursive = this.myRecursiveWatchRoots;
            List<String> flat = this.myFlatWatchRoots;
            if (recursive.size() + flat.size() > 0) {
                this.setWatchRoots(recursive, flat, true);
            }
        }
    }

    private void shutdownProcess() {
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            if (!processHandler2.isProcessTerminated()) {
                boolean killProcess = true;
                try {
                    this.writeLine(EXIT_COMMAND);
                    boolean bl = killProcess = !processHandler2.waitFor(500L);
                    if (killProcess) {
                        LOG.warn("File watcher is still alive. Doing a force quit.");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (killProcess) {
                    processHandler2.destroyProcess();
                }
            }
            this.myProcessHandler = null;
        }
    }

    private void setWatchRoots(List<String> recursive, List<String> flat, boolean restart) {
        if (this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated()) {
            return;
        }
        if (ApplicationManager.getApplication().isDisposeInProgress()) {
            flat = Collections.emptyList();
            recursive = flat;
        }
        if (!restart && this.myRecursiveWatchRoots.equals(recursive) && this.myFlatWatchRoots.equals(flat)) {
            return;
        }
        this.mySettingRoots.incrementAndGet();
        this.myRecursiveWatchRoots = recursive;
        this.myFlatWatchRoots = flat;
        try {
            this.writeLine(ROOTS_COMMAND);
            for (String path : recursive) {
                this.writeLine(path);
            }
            for (String path : flat) {
                this.writeLine("|" + path);
            }
            this.writeLine("#");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private void writeLine(String line) throws IOException {
        MyProcessHandler processHandler2;
        if (LOG.isTraceEnabled()) {
            LOG.trace("<< " + line);
        }
        if ((processHandler2 = this.myProcessHandler) != null) {
            processHandler2.writeLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChangedPaths() {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            this.myLastChangedPathIndex = 0;
            for (int i = 0; i < this.myLastChangedPaths.length; ++i) {
                this.myLastChangedPaths[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRepetition(String path) {
        String[] stringArray = this.myLastChangedPaths;
        synchronized (this.myLastChangedPaths) {
            for (int i = 0; i < this.myLastChangedPaths.length; ++i) {
                String lastChangedPath;
                int last = this.myLastChangedPathIndex - i - 1;
                if (last < 0) {
                    last += this.myLastChangedPaths.length;
                }
                if ((lastChangedPath = this.myLastChangedPaths[last]) == null || !lastChangedPath.equals(path)) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            this.myLastChangedPaths[this.myLastChangedPathIndex++] = path;
            if (this.myLastChangedPathIndex == this.myLastChangedPaths.length) {
                this.myLastChangedPathIndex = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public void startup() throws IOException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        this.myIsShuttingDown = false;
        this.myStartAttemptCount = 0;
        this.startupProcess(false);
    }

    public void shutdown() throws InterruptedException {
        Application app = ApplicationManager.getApplication();
        assert (app != null && app.isUnitTestMode()) : app;
        MyProcessHandler processHandler2 = this.myProcessHandler;
        if (processHandler2 != null) {
            this.myIsShuttingDown = true;
            this.shutdownProcess();
            long t = System.currentTimeMillis();
            while (!processHandler2.isProcessTerminated()) {
                if (System.currentTimeMillis() - t > 5000L) {
                    throw new InterruptedException("Timed out waiting watcher process to terminate");
                }
                TimeoutUtil.sleep((long)100L);
            }
        }
    }

    private class MyProcessAdapter
    extends ProcessAdapter {
        private WatcherOp myLastOp = null;
        private final List<String> myLines = ContainerUtil.newArrayList();

        private MyProcessAdapter() {
        }

        public void processTerminated(ProcessEvent event) {
            String message = "Watcher terminated with exit code " + event.getExitCode();
            if (NativeFileWatcherImpl.this.myIsShuttingDown) {
                LOG.info(message);
            } else {
                LOG.warn(message);
            }
            NativeFileWatcherImpl.this.myProcessHandler = null;
            try {
                NativeFileWatcherImpl.this.startupProcess(true);
            }
            catch (IOException e) {
                NativeFileWatcherImpl.this.shutdownProcess();
                LOG.warn("Watcher terminated and attempt to restart has failed. Exiting watching thread.", (Throwable)e);
            }
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR) {
                LOG.warn(event.getText().trim());
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            String line = event.getText().trim();
            if (LOG.isTraceEnabled()) {
                LOG.trace(">> " + line);
            }
            if (this.myLastOp == null) {
                WatcherOp watcherOp;
                try {
                    watcherOp = WatcherOp.valueOf(line);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Illegal watcher command: " + line);
                    return;
                }
                if (watcherOp == WatcherOp.GIVEUP) {
                    NativeFileWatcherImpl.this.notifyOnFailure(ApplicationBundle.message((String)"watcher.gave.up", (Object[])new Object[0]), null);
                    NativeFileWatcherImpl.this.myIsShuttingDown = true;
                } else if (watcherOp == WatcherOp.RESET) {
                    this.reset();
                } else {
                    this.myLastOp = watcherOp;
                }
            } else if (this.myLastOp == WatcherOp.MESSAGE) {
                NativeFileWatcherImpl.this.notifyOnFailure(line, NotificationListener.URL_OPENING_LISTENER);
                this.myLastOp = null;
            } else if (this.myLastOp == WatcherOp.REMAP || this.myLastOp == WatcherOp.UNWATCHEABLE) {
                if ("#".equals(line)) {
                    if (this.myLastOp == WatcherOp.REMAP) {
                        this.processRemap();
                    } else {
                        NativeFileWatcherImpl.this.mySettingRoots.decrementAndGet();
                        this.processUnwatchable();
                    }
                    this.myLines.clear();
                    this.myLastOp = null;
                } else {
                    this.myLines.add(line);
                }
            } else {
                String path = StringUtil.trimEnd((String)line.replace('\u0000', '\n'), (String)File.separator);
                this.processChange(path, this.myLastOp);
                this.myLastOp = null;
            }
        }

        private void reset() {
            for (VirtualFile root : NativeFileWatcherImpl.this.myManagingFS.getLocalRoots()) {
                NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(root.getPresentableUrl());
            }
        }

        private void processRemap() {
            HashSet pairs = ContainerUtil.newHashSet();
            for (int i = 0; i < this.myLines.size() - 1; i += 2) {
                pairs.add(Pair.create((Object)this.myLines.get(i), (Object)this.myLines.get(i + 1)));
            }
            NativeFileWatcherImpl.this.myNotificationSink.notifyMapping((Collection)pairs);
        }

        private void processUnwatchable() {
            NativeFileWatcherImpl.this.myNotificationSink.notifyManualWatchRoots(this.myLines);
        }

        private void processChange(String path, WatcherOp op) {
            if (SystemInfo.isWindows && op == WatcherOp.RECDIRTY) {
                VirtualFile root = LocalFileSystem.getInstance().findFileByPath(path);
                if (root != null) {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(path);
                }
                return;
            }
            if ((op == WatcherOp.CHANGE || op == WatcherOp.STATS) && NativeFileWatcherImpl.this.isRepetition(path)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("repetition: " + path);
                }
                return;
            }
            if (SystemInfo.isMac) {
                path = Normalizer.normalize(path, Normalizer.Form.NFC);
            }
            switch (op) {
                case STATS: 
                case CHANGE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPath(path);
                    break;
                }
                case CREATE: 
                case DELETE: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyPathCreatedOrDeleted(path);
                    break;
                }
                case DIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyDirectory(path);
                    break;
                }
                case RECDIRTY: {
                    NativeFileWatcherImpl.this.myNotificationSink.notifyDirtyPathRecursive(path);
                    break;
                }
                default: {
                    LOG.error("Unexpected op: " + (Object)((Object)op));
                }
            }
        }
    }

    private static enum WatcherOp {
        GIVEUP,
        RESET,
        UNWATCHEABLE,
        REMAP,
        MESSAGE,
        CREATE,
        DELETE,
        STATS,
        CHANGE,
        DIRTY,
        RECDIRTY;

    }

    private static class MyProcessHandler
    extends OSProcessHandler {
        private static final Charset CHARSET = SystemInfo.isWindows | SystemInfo.isMac ? CharsetToolkit.UTF8_CHARSET : null;
        private final BufferedWriter myWriter;

        private MyProcessHandler(@NotNull Process process, @NotNull String commandLine) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler", "<init>"));
            }
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/openapi/vfs/impl/local/NativeFileWatcherImpl$MyProcessHandler", "<init>"));
            }
            super(process, commandLine, CHARSET);
            this.myWriter = new BufferedWriter(MyProcessHandler.writer(process.getOutputStream()));
        }

        private static OutputStreamWriter writer(OutputStream stream) {
            return CHARSET != null ? new OutputStreamWriter(stream, CHARSET) : new OutputStreamWriter(stream);
        }

        private void writeLine(String line) throws IOException {
            this.myWriter.write(line);
            this.myWriter.newLine();
            this.myWriter.flush();
        }

        protected boolean useNonBlockingRead() {
            return false;
        }
    }
}

