/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.openapi.wm.impl.status.ClockPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.java.ayatana.ApplicationMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeMenuBar
extends JMenuBar
implements IdeEventQueue.EventDispatcher {
    private static final int COLLAPSED_HEIGHT = 2;
    private final MyTimerListener myTimerListener;
    private List<AnAction> myVisibleActions;
    private List<AnAction> myNewVisibleActions;
    private final MenuItemPresentationFactory myPresentationFactory;
    private final DataManager myDataManager;
    private final ActionManagerEx myActionManager;
    private final Disposable myDisposable = Disposer.newDisposable();
    private boolean myDisabled = false;
    @Nullable
    private final ClockPanel myClockPanel;
    @Nullable
    private final MyExitFullScreenButton myButton;
    @Nullable
    private final Animator myAnimator;
    @Nullable
    private final Timer myActivationWatcher;
    @NotNull
    private State myState = State.EXPANDED;
    private double myProgress = 0.0;
    private boolean myActivated = false;

    public IdeMenuBar(ActionManagerEx actionManager, DataManager dataManager) {
        this.myActionManager = actionManager;
        this.myTimerListener = new MyTimerListener();
        this.myVisibleActions = new ArrayList<AnAction>();
        this.myNewVisibleActions = new ArrayList<AnAction>();
        this.myPresentationFactory = new MenuItemPresentationFactory();
        this.myDataManager = dataManager;
        if (WindowManagerImpl.isFloatingMenuBarSupported()) {
            this.myAnimator = new MyAnimator();
            this.myActivationWatcher = UIUtil.createNamedTimer((String)"IdeMenuBar", (int)100, (ActionListener)new MyActionListener());
            this.myClockPanel = new ClockPanel();
            this.myButton = new MyExitFullScreenButton();
            this.add(this.myClockPanel);
            this.add(this.myButton);
            this.addPropertyChangeListener("ide.frame.full.screen", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    IdeMenuBar.this.updateState();
                }
            });
            this.addMouseListener(new MyMouseListener());
        } else {
            this.myAnimator = null;
            this.myActivationWatcher = null;
            this.myClockPanel = null;
            this.myButton = null;
        }
    }

    public State getState() {
        return this.myState;
    }

    @Override
    public Border getBorder() {
        State state = this.getState();
        if (state == State.EXPANDING || state == State.COLLAPSING) {
            return JBUI.Borders.empty();
        }
        if (state == State.TEMPORARY_EXPANDED && UIUtil.isUnderDarcula()) {
            return JBUI.Borders.customLine((Color)Gray._75, (int)0, (int)0, (int)1, (int)0);
        }
        if (state == State.COLLAPSED) {
            return JBUI.Borders.emptyBottom((int)1);
        }
        if (SystemInfo.isWindows && Registry.is((String)"ide.win.frame.decoration") && (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
            return null;
        }
        return UISettings.getInstance().SHOW_MAIN_TOOLBAR || UISettings.getInstance().SHOW_NAVIGATION_BAR ? super.getBorder() : null;
    }

    @Override
    public void paint(Graphics g) {
        if (this.getState() == State.COLLAPSED) {
            return;
        }
        super.paint(g);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.myClockPanel != null && this.myButton != null) {
            if (this.getState() != State.EXPANDED) {
                this.myClockPanel.setVisible(true);
                this.myButton.setVisible(true);
                Dimension preferredSize = this.myButton.getPreferredSize();
                this.myButton.setBounds(this.getBounds().width - preferredSize.width, 0, preferredSize.width, preferredSize.height);
                preferredSize = this.myClockPanel.getPreferredSize();
                this.myClockPanel.setBounds(this.getBounds().width - preferredSize.width - this.myButton.getWidth(), 0, preferredSize.width, preferredSize.height);
            } else {
                this.myClockPanel.setVisible(false);
                this.myButton.setVisible(false);
            }
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (!isIncluded && this.getState() == State.TEMPORARY_EXPANDED) {
            this.myActivated = false;
            this.setState(State.COLLAPSING);
            this.restartAnimator();
            return;
        }
        if (isIncluded && this.getState() == State.COLLAPSED) {
            this.myActivated = true;
            this.setState(State.TEMPORARY_EXPANDED);
            this.revalidate();
            this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JMenu menu = IdeMenuBar.this.getMenu(IdeMenuBar.this.getSelectionModel().getSelectedIndex());
                    if (menu.isPopupMenuVisible()) {
                        menu.setPopupMenuVisible(false);
                        menu.setPopupMenuVisible(true);
                    }
                }
            });
        }
        super.menuSelectionChanged(isIncluded);
    }

    private boolean isActivated() {
        int index = this.getSelectionModel().getSelectedIndex();
        if (index == -1) {
            return false;
        }
        return this.getMenu(index).isPopupMenuVisible();
    }

    private void updateState() {
        Window window;
        if (this.myAnimator != null && (window = SwingUtilities.getWindowAncestor(this)) instanceof IdeFrameEx) {
            boolean fullScreen = ((IdeFrameEx)((Object)window)).isInFullScreen();
            if (fullScreen) {
                this.setState(State.COLLAPSING);
                this.restartAnimator();
            } else {
                this.myAnimator.suspend();
                this.setState(State.EXPANDED);
                if (this.myClockPanel != null) {
                    this.myClockPanel.setVisible(false);
                    this.myButton.setVisible(false);
                }
            }
        }
    }

    private void setState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/wm/impl/IdeMenuBar", "setState"));
        }
        this.myState = state;
        if (this.myState == State.EXPANDING && this.myActivationWatcher != null && !this.myActivationWatcher.isRunning()) {
            this.myActivationWatcher.start();
        } else if (this.myActivationWatcher != null && this.myActivationWatcher.isRunning() && (state == State.EXPANDED || state == State.COLLAPSED)) {
            this.myActivationWatcher.stop();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.getState().isInProgress()) {
            dimension.height = 2 + (int)((this.getState() == State.COLLAPSING ? 1.0 - this.myProgress : this.myProgress) * (double)(dimension.height - 2));
        } else if (this.getState() == State.COLLAPSED) {
            dimension.height = 2;
        }
        return dimension;
    }

    private void restartAnimator() {
        if (this.myAnimator != null) {
            this.myAnimator.reset();
            this.myAnimator.resume();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateMenuActions();
        this.myActionManager.addTimerListener(1000, (TimerListener)new WeakTimerListener(this.myActionManager, this.myTimerListener));
        UISettingsListener UISettingsListener2 = new UISettingsListener(){

            public void uiSettingsChanged(UISettings source) {
                IdeMenuBar.this.updateMnemonicsVisibility();
                IdeMenuBar.this.myPresentationFactory.reset();
            }
        };
        UISettings.getInstance().addUISettingsListener(UISettingsListener2, this.myDisposable);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
        IdeEventQueue.getInstance().addDispatcher(this, this.myDisposable);
    }

    @Override
    public void removeNotify() {
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            if (this.myAnimator != null) {
                this.myAnimator.suspend();
            }
            Disposer.dispose((Disposable)this.myDisposable);
        }
        super.removeNotify();
    }

    @Override
    public boolean dispatch(AWTEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)e;
            Component component = this.findActualComponent(mouseEvent);
            if (this.getState() != State.EXPANDED) {
                boolean mouseInside;
                boolean bl = mouseInside = this.myActivated || UIUtil.isDescendingFrom((Component)component, (Component)this);
                if (e.getID() == 505 && e.getSource() == SwingUtilities.windowForComponent(this) && !this.myActivated) {
                    mouseInside = false;
                }
                if (mouseInside && this.getState() == State.COLLAPSED) {
                    this.setState(State.EXPANDING);
                    this.restartAnimator();
                } else if (!mouseInside && this.getState() != State.COLLAPSING && this.getState() != State.COLLAPSED) {
                    this.setState(State.COLLAPSING);
                    this.restartAnimator();
                }
            }
        }
        return false;
    }

    private Component findActualComponent(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        Component deepestComponent = this.getState() != State.EXPANDED && !this.getState().isInProgress() && this.contains(SwingUtilities.convertPoint(component, mouseEvent.getPoint(), this)) ? this : SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        if (deepestComponent != null) {
            component = deepestComponent;
        }
        return component;
    }

    void updateMenuActions() {
        this.myNewVisibleActions.clear();
        if (!this.myDisabled) {
            DataContext dataContext = ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
            this.expandActionGroup(dataContext, this.myNewVisibleActions, (ActionManager)this.myActionManager);
        }
        if (!this.myNewVisibleActions.equals(this.myVisibleActions)) {
            boolean changeBarVisibility = this.myNewVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
            List<AnAction> temp = this.myVisibleActions;
            this.myVisibleActions = this.myNewVisibleActions;
            this.myNewVisibleActions = temp;
            this.removeAll();
            boolean enableMnemonics = !UISettings.getInstance().DISABLE_MNEMONICS;
            for (AnAction action : this.myVisibleActions) {
                this.add(new ActionMenu(null, "MainMenu", (ActionGroup)action, this.myPresentationFactory, enableMnemonics, true));
            }
            this.fixMenuBackground();
            this.updateMnemonicsVisibility();
            if (this.myClockPanel != null) {
                this.add(this.myClockPanel);
                this.add(this.myButton);
            }
            this.validate();
            if (changeBarVisibility) {
                this.invalidate();
                JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
                if (frame != null) {
                    frame.validate();
                }
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.fixMenuBackground();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            g.setColor(UIManager.getColor("MenuItem.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.getState().isInProgress()) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldTransform = g2.getTransform();
            AffineTransform newTransform = oldTransform != null ? new AffineTransform(oldTransform) : new AffineTransform();
            newTransform.concatenate(AffineTransform.getTranslateInstance(0.0, this.getHeight() - super.getPreferredSize().height));
            g2.setTransform(newTransform);
            super.paintChildren(g2);
            g2.setTransform(oldTransform);
        } else if (this.getState() != State.COLLAPSED) {
            super.paintChildren(g);
        }
    }

    private void fixMenuBackground() {
        JMenu menu;
        if (UIUtil.isUnderAlloyLookAndFeel() && this.getMenuCount() > 0 && (menu = this.getMenu(0)) != null) {
            menu.updateUI();
            this.setBackground(menu.getBackground());
        }
    }

    private void expandActionGroup(DataContext context, List<AnAction> newVisibleActions, ActionManager actionManager) {
        AnAction[] children2;
        ActionGroup mainActionGroup = (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction("MainMenu");
        if (mainActionGroup == null) {
            return;
        }
        for (AnAction action : children2 = mainActionGroup.getChildren(null)) {
            if (!(action instanceof ActionGroup)) continue;
            Presentation presentation = this.myPresentationFactory.getPresentation(action);
            AnActionEvent e = new AnActionEvent(null, context, "MainMenu", presentation, actionManager, 0);
            e.setInjectedContext(action.isInInjectedContext());
            action.update(e);
            if (!presentation.isVisible()) continue;
            newVisibleActions.add(action);
        }
    }

    @Override
    public int getMenuCount() {
        int menuCount = super.getMenuCount();
        return this.myClockPanel != null ? menuCount - 2 : menuCount;
    }

    private void updateMnemonicsVisibility() {
        boolean enabled = !UISettings.getInstance().DISABLE_MNEMONICS;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            ((ActionMenu)this.getMenu(i)).setMnemonicEnabled(enabled);
        }
    }

    public void disableUpdates() {
        this.myDisabled = true;
        this.updateMenuActions();
    }

    public void enableUpdates() {
        this.myDisabled = false;
        this.updateMenuActions();
    }

    public static void installAppMenuIfNeeded(final @NotNull JFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/openapi/wm/impl/IdeMenuBar", "installAppMenuIfNeeded"));
        }
        if (SystemInfo.isLinux && Registry.is((String)"linux.native.menu") && "Unity".equals(System.getenv("XDG_CURRENT_DESKTOP"))) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.tryInstall((Window)frame);
                }
            });
        }
    }

    private static class MyExitFullScreenButton
    extends JButton {
        private MyExitFullScreenButton() {
            this.setFocusable(false);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Window window = SwingUtilities.getWindowAncestor(this);
                    if (window instanceof IdeFrameEx) {
                        ((IdeFrameEx)((Object)window)).toggleFullScreen(false);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    model.setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    model.setRollover(false);
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.getParent();
            int height = this.isVisible() && parent != null ? parent.getSize().height - parent.getInsets().top - parent.getInsets().bottom : super.getPreferredSize().height;
            return new Dimension(height, height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.setColor(UIManager.getColor("Label.background"));
                g2d.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
                g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                double s = (double)this.getHeight() / 13.0;
                g2d.translate(s, s);
                RoundRectangle2D.Double plate = new RoundRectangle2D.Double(0.0, 0.0, s * 11.0, s * 11.0, s, s);
                Color color = UIManager.getColor("Label.foreground");
                boolean hover = this.model.isRollover() || this.model.isPressed();
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.25 : 0.18)));
                g2d.fill(plate);
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.4 : 0.33)));
                g2d.draw(plate);
                g2d.setColor(ColorUtil.withAlpha((Color)color, (double)(hover ? 0.7 : 0.66)));
                GeneralPath path = new GeneralPath();
                path.moveTo(s * 2.0, s * 6.0);
                path.lineTo(s * 5.0, s * 6.0);
                path.lineTo(s * 5.0, s * 9.0);
                path.lineTo(s * 4.0, s * 8.0);
                path.lineTo(s * 2.0, s * 10.0);
                path.quadTo(s * 2.0 - s / Math.sqrt(2.0), s * 9.0 + s / Math.sqrt(2.0), s, s * 9.0);
                path.lineTo(s * 3.0, s * 7.0);
                path.lineTo(s * 2.0, s * 6.0);
                path.closePath();
                g2d.fill(path);
                g2d.draw(path);
                path = new GeneralPath();
                path.moveTo(s * 6.0, s * 2.0);
                path.lineTo(s * 6.0, s * 5.0);
                path.lineTo(s * 9.0, s * 5.0);
                path.lineTo(s * 8.0, s * 4.0);
                path.lineTo(s * 10.0, s * 2.0);
                path.quadTo(s * 9.0 + s / Math.sqrt(2.0), s * 2.0 - s / Math.sqrt(2.0), s * 9.0, s);
                path.lineTo(s * 7.0, s * 3.0);
                path.lineTo(s * 6.0, s * 2.0);
                path.closePath();
                g2d.fill(path);
                g2d.draw(path);
            }
            finally {
                g2d.dispose();
            }
        }
    }

    private static class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Component c = e.getComponent();
            if (c instanceof IdeMenuBar) {
                Component item;
                Dimension size = c.getSize();
                Insets insets = ((IdeMenuBar)c).getInsets();
                Point p = e.getPoint();
                if ((p.y < insets.top || p.y >= size.height - insets.bottom) && (item = ((IdeMenuBar)c).findComponentAt(p.x, size.height / 2)) instanceof JMenuItem) {
                    item.dispatchEvent(MouseEventAdapter.convert((MouseEvent)e, (Component)item, (int)1, (int)1));
                    e.consume();
                    return;
                }
            }
            super.mouseClicked(e);
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IdeMenuBar.this.getState() == State.EXPANDED || IdeMenuBar.this.getState() == State.EXPANDING) {
                return;
            }
            boolean activated = IdeMenuBar.this.isActivated();
            if (IdeMenuBar.this.myActivated && !activated && IdeMenuBar.this.getState() == State.TEMPORARY_EXPANDED) {
                IdeMenuBar.this.myActivated = false;
                IdeMenuBar.this.setState(State.COLLAPSING);
                IdeMenuBar.this.restartAnimator();
            }
            if (activated) {
                IdeMenuBar.this.myActivated = true;
            }
        }
    }

    private class MyAnimator
    extends Animator {
        public MyAnimator() {
            super("MenuBarAnimator", 16, 300, false);
        }

        public void paintNow(int frame, int totalFrames, int cycle) {
            IdeMenuBar.this.myProgress = (1.0 - Math.cos(Math.PI * (double)((float)frame / (float)totalFrames))) / 2.0;
            IdeMenuBar.this.revalidate();
            IdeMenuBar.this.repaint();
        }

        protected void paintCycleEnd() {
            IdeMenuBar.this.myProgress = 1.0;
            switch (IdeMenuBar.this.getState()) {
                case COLLAPSING: {
                    IdeMenuBar.this.setState(State.COLLAPSED);
                    break;
                }
                case EXPANDING: {
                    IdeMenuBar.this.setState(State.TEMPORARY_EXPANDED);
                    break;
                }
            }
            IdeMenuBar.this.revalidate();
            if (IdeMenuBar.this.getState() == State.COLLAPSED) {
                IdeMenuBar.this.getParent().repaint();
            } else {
                IdeMenuBar.this.repaint();
            }
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)IdeMenuBar.this);
        }

        public void run() {
            if (!IdeMenuBar.this.isShowing()) {
                return;
            }
            Window myWindow = SwingUtilities.windowForComponent(IdeMenuBar.this);
            if (myWindow != null && !myWindow.isActive()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                return;
            }
            IdeMenuBar.this.updateMenuActions();
            if (UIUtil.isWinLafOnVista()) {
                IdeMenuBar.this.repaint();
            }
        }
    }

    private static enum State {
        EXPANDED,
        COLLAPSING,
        COLLAPSED,
        EXPANDING,
        TEMPORARY_EXPANDED;


        boolean isInProgress() {
            return this == COLLAPSING || this == EXPANDING;
        }
    }
}

