/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleReadOnlyAttributePanel
extends FileEditorManagerAdapter
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private Project myProject;
    private StatusBar myStatusBar;

    public ToggleReadOnlyAttributePanel(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "<init>"));
        }
        this.myProject = project2;
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)this);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
    }

    @NotNull
    public Icon getIcon() {
        VirtualFile virtualFile = this.getCurrentFile();
        Icon icon = virtualFile == null || virtualFile.isWritable() ? AllIcons.Ide.Readwrite : AllIcons.Ide.Readonly;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String ID() {
        if ("ReadOnlyAttribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "ID"));
        }
        return "ReadOnlyAttribute";
    }

    public StatusBarWidget copy() {
        return new ToggleReadOnlyAttributePanel(this.myProject);
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "getPresentation"));
        }
        return this;
    }

    public void dispose() {
        this.myStatusBar = null;
        this.myProject = null;
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "install"));
        }
        this.myStatusBar = statusBar;
    }

    public String getTooltipText() {
        return this.isReadonlyApplicable() ? UIBundle.message((String)"read.only.attr.panel.double.click.to.toggle.attr.tooltip.text", (Object[])new Object[0]) : null;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                final VirtualFile file2 = ToggleReadOnlyAttributePanel.this.getCurrentFile();
                if (!ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFile(file2)) {
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file2, (boolean)file2.isWritable());
                            ToggleReadOnlyAttributePanel.this.myStatusBar.updateWidget(ToggleReadOnlyAttributePanel.this.ID());
                        }
                        catch (IOException e) {
                            Messages.showMessageDialog((Project)ToggleReadOnlyAttributePanel.this.getProject(), (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                        }
                    }
                });
            }
        };
    }

    private boolean isReadonlyApplicable() {
        VirtualFile file2 = this.getCurrentFile();
        return ToggleReadOnlyAttributePanel.isReadOnlyApplicableForFile(file2);
    }

    private static boolean isReadOnlyApplicableForFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.getFileSystem().isReadOnly();
    }

    @Nullable
    private Project getProject() {
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((JComponent)this.myStatusBar)));
    }

    @Nullable
    private VirtualFile getCurrentFile() {
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        EditorsSplitters splitters = FileEditorManagerEx.getInstanceEx(project2).getSplittersFor(this.myStatusBar.getComponent());
        return splitters.getCurrentFile();
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel", "selectionChanged"));
        }
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }
}

