/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ChangeListsScopesProvider
extends CustomScopesProviderEx {
    @NotNull
    private final Project myProject;

    public static ChangeListsScopesProvider getInstance(Project project2) {
        return (ChangeListsScopesProvider)((Object)Extensions.findExtension((ExtensionPointName)CUSTOM_SCOPES_PROVIDER, (AreaInstance)project2, ChangeListsScopesProvider.class));
    }

    public ChangeListsScopesProvider(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packageDependencies/ChangeListsScopesProvider", "<init>"));
        }
        this.myProject = project2;
    }

    @NotNull
    public List<NamedScope> getCustomScopes() {
        if (this.myProject.isDefault() || ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss().length == 0) {
            List<NamedScope> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ChangeListsScopesProvider", "getCustomScopes"));
            }
            return list;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<NamedScope> result = new ArrayList<NamedScope>();
        result.add(ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0])));
        for (ChangeList list : changeListManager.getChangeListsCopy()) {
            result.add(ChangeListsScopesProvider.createChangeListScope(list));
        }
        ArrayList<NamedScope> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ChangeListsScopesProvider", "getCustomScopes"));
        }
        return arrayList;
    }

    private static NamedScope createChangeListScope(@NotNull ChangeList list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/packageDependencies/ChangeListsScopesProvider", "createChangeListScope"));
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        Collection changes = list.getChanges();
        for (Change change : changes) {
            VirtualFile vFile;
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || (vFile = afterRevision.getFile().getVirtualFile()) == null) continue;
            files.add(vFile);
        }
        return ChangeListsScopesProvider.createScope(files, list.getName());
    }

    public NamedScope getCustomScope(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/packageDependencies/ChangeListsScopesProvider", "getCustomScope"));
        }
        if (this.myProject.isDefault()) {
            return null;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]).equals(name)) {
            return ChangeListsScopesProvider.createScope(changeListManager.getAffectedFiles(), IdeBundle.message((String)"scope.modified.files", (Object[])new Object[0]));
        }
        LocalChangeList changeList = changeListManager.findChangeList(name);
        if (changeList != null) {
            return ChangeListsScopesProvider.createChangeListScope((ChangeList)changeList);
        }
        return null;
    }

    public boolean isVetoed(NamedScope scope, CustomScopesProviderEx.ScopePlace place) {
        if (place == CustomScopesProviderEx.ScopePlace.SETTING) {
            if (this.myProject.isDefault()) {
                return false;
            }
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            return changeListManager.findChangeList(scope.getName()) != null;
        }
        return false;
    }

    @NotNull
    private static NamedScope createScope(final @NotNull List<VirtualFile> files, @NotNull String changeListName) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/packageDependencies/ChangeListsScopesProvider", "createScope"));
        }
        if (changeListName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListName", "com/intellij/packageDependencies/ChangeListsScopesProvider", "createScope"));
        }
        NamedScope namedScope = new NamedScope(changeListName, (PackageSet)new PackageSetBase(){

            public boolean contains(VirtualFile file2, NamedScopesHolder holder) {
                return files.contains(file2);
            }

            @NotNull
            public PackageSet createCopy() {
                1 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ChangeListsScopesProvider$1", "createCopy"));
                }
                return v0;
            }

            @NotNull
            public String getText() {
                if ("file:*//*" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ChangeListsScopesProvider$1", "getText"));
                }
                return "file:*//*";
            }

            public int getNodePriority() {
                return 0;
            }
        }){

            public boolean equals(Object obj) {
                if (!(obj instanceof NamedScope)) {
                    return false;
                }
                return this.getName().equals(((NamedScope)obj).getName());
            }

            public int hashCode() {
                return this.getName().hashCode();
            }
        };
        if (namedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ChangeListsScopesProvider", "createScope"));
        }
        return namedScope;
    }
}

