/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OpenOrAttachDialog
extends DialogWrapper {
    private JRadioButton myCurrentWindowButton;
    private JRadioButton myOpenInNewWindowButton;
    private JPanel myMainPanel;
    private JBCheckBox myAddCheckbox;
    private static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    private static final String MODE_ATTACH = "attach";
    private static final String MODE_REPLACE = "replace";
    private static final String MODE_NEW = "new";
    private final boolean myHideReplace;

    protected OpenOrAttachDialog(Project project2, boolean hideReplace, String title) {
        super(project2);
        this.myHideReplace = hideReplace;
        this.$$$setupUI$$$();
        this.setTitle(title);
        this.init();
        DoubleClickListener listener2 = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                OpenOrAttachDialog.this.doOKAction();
                return true;
            }
        };
        listener2.installOn((Component)this.myCurrentWindowButton);
        listener2.installOn((Component)this.myOpenInNewWindowButton);
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        if (MODE_NEW.equals(mode)) {
            this.myOpenInNewWindowButton.setSelected(true);
        } else if (mode == null || MODE_REPLACE.equals(mode) || hideReplace) {
            this.myCurrentWindowButton.setSelected(true);
            this.myAddCheckbox.setSelected(false);
        } else {
            this.myCurrentWindowButton.setSelected(true);
            this.myAddCheckbox.setSelected(true);
        }
        if (hideReplace) {
            this.myAddCheckbox.setVisible(false);
        }
        this.myAddCheckbox.setEnabled(this.myCurrentWindowButton.isSelected());
        ActionListener listener1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenOrAttachDialog.this.myAddCheckbox.setEnabled(OpenOrAttachDialog.this.myCurrentWindowButton.isSelected());
            }
        };
        this.myCurrentWindowButton.addActionListener(listener1);
        this.myOpenInNewWindowButton.addActionListener(listener1);
    }

    public boolean isReplace() {
        return this.myCurrentWindowButton.isSelected() && (!this.myAddCheckbox.isSelected() || this.myHideReplace);
    }

    public boolean isAttach() {
        return this.myCurrentWindowButton.isSelected() && this.myAddCheckbox.isSelected() && !this.myHideReplace;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        String mode = this.isAttach() ? MODE_ATTACH : (this.isReplace() ? MODE_REPLACE : MODE_NEW);
        PropertiesComponent.getInstance().setValue(MODE_PROPERTY, mode);
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("How would you like to open the project?");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOpenInNewWindowButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Open in new window");
        jRadioButton2.setMnemonic('N');
        jRadioButton2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCurrentWindowButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open in current window");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setEnabled(false);
        jBCheckBox.setText("Add to currently opened projects");
        jBCheckBox.setMnemonic('A');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

