/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public abstract class AdvancedSettingsAction
extends DumbAwareAction {
    private final int myCheckBoxIndent;
    private Project myProject;
    private InspectionConfigTreeNode myRoot;

    public AdvancedSettingsAction(Project project2, InspectionConfigTreeNode root) {
        super("Advanced Settings");
        this.getTemplatePresentation().setIcon(AllIcons.General.Gear);
        this.myProject = project2;
        this.myRoot = root;
        this.myCheckBoxIndent = AdvancedSettingsAction.calculateCheckBoxIndent();
    }

    public void update(AnActionEvent e) {
        super.update(e);
        InspectionProfileImpl inspectionProfile = this.getInspectionProfile();
        Icon icon = AllIcons.General.Gear;
        e.getPresentation().setIcon(inspectionProfile != null && inspectionProfile.isProfileLocked() ? LayeredIcon.create((Icon)icon, (Icon)PlatformIcons.LOCKED_ICON) : icon);
    }

    public void actionPerformed(AnActionEvent e) {
        ListPopupImpl actionGroupPopup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<MyAction>(null, ContainerUtil.list((Object[])new MyAction[]{new MyDisableNewInspectionsAction(), new MyResetAction()})){

            public PopupStep onChosen(MyAction selectedValue, boolean finalChoice) {
                if (selectedValue.enabled()) {
                    selectedValue.actionPerformed();
                }
                return FINAL_CHOICE;
            }
        });
        actionGroupPopup.getList().setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return ((MyAction)value).createCustomComponent(isSelected);
            }
        });
        Component component = e.getInputEvent().getComponent();
        actionGroupPopup.show(new RelativePoint(component, new Point(component.getWidth() - 1, 0)));
    }

    private JLabel installLeftIndentToLabel(JLabel label) {
        label.setBorder(BorderFactory.createEmptyBorder(0, this.myCheckBoxIndent, 0, 0));
        return label;
    }

    protected abstract InspectionProfileImpl getInspectionProfile();

    protected abstract void postProcessModification();

    private static int calculateCheckBoxIndent() {
        JCheckBox checkBox = new JCheckBox();
        Icon icon = checkBox.getIcon();
        int indent = 0;
        if (icon == null) {
            icon = UIManager.getIcon("CheckBox.icon");
        }
        if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            icon = EmptyIcon.create((int)20, (int)18);
        }
        if (icon != null) {
            Rectangle r1 = new Rectangle(checkBox.getWidth(), checkBox.getHeight());
            JBInsets.removeFrom((Rectangle)r1, (Insets)checkBox.getInsets());
            Rectangle iconRect = new Rectangle();
            SwingUtilities.layoutCompoundLabel(checkBox, checkBox.getFontMetrics(checkBox.getFont()), checkBox.getText(), icon, checkBox.getVerticalAlignment(), checkBox.getHorizontalAlignment(), checkBox.getVerticalTextPosition(), checkBox.getHorizontalTextPosition(), r1, new Rectangle(), iconRect, checkBox.getText() == null ? 0 : checkBox.getIconTextGap());
            indent = iconRect.x;
        }
        return indent + checkBox.getIconTextGap();
    }

    private abstract class MyAction {
        private final String myDescription;

        protected MyAction(String description) {
            this.myDescription = description;
        }

        protected abstract JComponent createBaseComponent();

        protected abstract void actionPerformed();

        protected abstract boolean enabled();

        public JComponent createCustomComponent(boolean selected) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            JComponent baseComponent = this.createBaseComponent();
            panel.add(baseComponent);
            JLabel descriptionLabel = new JLabel(this.myDescription);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)descriptionLabel);
            panel.add(AdvancedSettingsAction.this.installLeftIndentToLabel(descriptionLabel));
            UIUtil.setEnabled((Component)panel, (boolean)this.enabled(), (boolean)true);
            panel.setBackground(selected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground());
            descriptionLabel.setForeground(selected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground());
            baseComponent.setForeground(selected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground());
            return panel;
        }
    }

    private class MyDisableNewInspectionsAction
    extends MyAction {
        public MyDisableNewInspectionsAction() {
            super("New inspections may appear when " + ApplicationNamesInfo.getInstance().getFullProductName() + " is updated");
        }

        @Override
        protected JComponent createBaseComponent() {
            JCheckBox checkBox = new JCheckBox("Disable new inspections by default");
            InspectionProfileImpl profile = AdvancedSettingsAction.this.getInspectionProfile();
            checkBox.setEnabled(profile != null);
            if (profile != null) {
                checkBox.setSelected(profile.isProfileLocked());
            }
            checkBox.setOpaque(false);
            return checkBox;
        }

        @Override
        public void actionPerformed() {
            InspectionProfileImpl profile = AdvancedSettingsAction.this.getInspectionProfile();
            if (profile != null) {
                profile.lockProfile(!profile.isProfileLocked());
            }
        }

        @Override
        protected boolean enabled() {
            return true;
        }
    }

    private class MyResetAction
    extends MyAction {
        protected MyResetAction() {
            super("All your changes will be lost");
        }

        @Override
        protected JComponent createBaseComponent() {
            return AdvancedSettingsAction.this.installLeftIndentToLabel(new JLabel("Reset to Default Settings"));
        }

        @Override
        public void actionPerformed() {
            InspectionProfileImpl inspectionProfile = AdvancedSettingsAction.this.getInspectionProfile();
            if (inspectionProfile == null) {
                return;
            }
            inspectionProfile.resetToBase(AdvancedSettingsAction.this.myProject);
            AdvancedSettingsAction.this.postProcessModification();
        }

        @Override
        protected boolean enabled() {
            return AdvancedSettingsAction.this.myRoot.isProperSetting();
        }
    }
}

