/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBasedFormattingModel
implements FormattingModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.PsiBasedFormattingModel");
    private final Project myProject;
    private final ASTNode myASTNode;
    private final FormattingDocumentModelImpl myDocumentModel;
    @NotNull
    private final Block myRootBlock;
    protected boolean myCanModifyAllWhiteSpaces;

    public PsiBasedFormattingModel(PsiFile file2, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootBlock", "com/intellij/psi/formatter/PsiBasedFormattingModel", "<init>"));
        }
        this.myCanModifyAllWhiteSpaces = false;
        this.myASTNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        this.myDocumentModel = documentModel;
        this.myRootBlock = rootBlock;
        this.myProject = file2.getProject();
    }

    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        return this.replaceWhiteSpace(textRange, null, whiteSpace);
    }

    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        String whiteSpaceToUse = this.myDocumentModel.adjustWhiteSpaceIfNecessary(whiteSpace, textRange.getStartOffset(), textRange.getEndOffset(), nodeAfter, true).toString();
        String wsReplaced = this.replaceWithPSI(textRange, whiteSpaceToUse);
        if (wsReplaced != null) {
            return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + wsReplaced.length());
        }
        return textRange;
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        return textRange;
    }

    public void commitChanges() {
    }

    @Nullable
    private String replaceWithPSI(final TextRange textRange, final String whiteSpace) {
        int offset = textRange.getEndOffset();
        ASTNode leafElement = this.findElementAt(offset);
        if (leafElement != null) {
            if (leafElement.getPsi() instanceof PsiFile) {
                return null;
            }
            if (!leafElement.getPsi().isValid()) {
                String message = "Invalid element found in '\n" + this.myASTNode.getText() + "\n' at " + offset + "(" + this.myASTNode.getText().substring(offset, Math.min(offset + 10, this.myASTNode.getTextLength()));
                LOG.error(message);
            }
            return this.replaceWithPsiInLeaf(textRange, whiteSpace, leafElement);
        }
        if (textRange.getEndOffset() == this.myASTNode.getTextLength()) {
            CodeStyleManager.getInstance((Project)this.myProject).performActionWithFormatterDisabled(new Runnable(){

                @Override
                public void run() {
                    FormatterUtil.replaceLastWhiteSpace(PsiBasedFormattingModel.this.myASTNode, whiteSpace, textRange);
                }
            });
            return whiteSpace;
        }
        return null;
    }

    @Nullable
    protected String replaceWithPsiInLeaf(final TextRange textRange, final String whiteSpace, final ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces && leafElement.getElementType() == TokenType.WHITE_SPACE) {
            return null;
        }
        CodeStyleManager.getInstance((Project)this.myProject).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                FormatterUtil.replaceWhiteSpace(whiteSpace, leafElement, TokenType.WHITE_SPACE, textRange);
            }
        });
        return whiteSpace;
    }

    @Nullable
    protected ASTNode findElementAt(int offset) {
        PsiElement psiElement;
        PsiFile containingFile = this.myASTNode.getPsi().getContainingFile();
        Project project2 = containingFile.getProject();
        assert (!PsiDocumentManager.getInstance((Project)project2).isUncommited(this.myDocumentModel.getDocument()));
        PsiElement psiElement2 = psiElement = project2.isDefault() ? null : InjectedLanguageUtil.findInjectedElementNoCommit(containingFile, offset);
        if (psiElement == null) {
            psiElement = containingFile.findElementAt(offset);
        }
        if (psiElement == null) {
            return null;
        }
        return psiElement.getNode();
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        FormattingDocumentModelImpl formattingDocumentModelImpl = this.myDocumentModel;
        if (formattingDocumentModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/PsiBasedFormattingModel", "getDocumentModel"));
        }
        return formattingDocumentModelImpl;
    }

    @NotNull
    public Block getRootBlock() {
        Block block = this.myRootBlock;
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/PsiBasedFormattingModel", "getRootBlock"));
        }
        return block;
    }

    public void canModifyAllWhiteSpaces() {
        this.myCanModifyAllWhiteSpaces = true;
    }
}

