/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PackagePrefixIndex;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NotNull;

public class PackagePrefixElementFinder
extends PsiElementFinder
implements DumbAware {
    private final Project myProject;
    private final PackagePrefixIndex myPackagePrefixIndex;

    public PackagePrefixElementFinder(Project project2) {
        this.myProject = project2;
        this.myPackagePrefixIndex = new PackagePrefixIndex(project2);
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PackagePrefixElementFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PackagePrefixElementFinder", "findClass"));
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PackagePrefixElementFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PackagePrefixElementFinder", "findClasses"));
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PackagePrefixElementFinder", "findClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/PackagePrefixElementFinder", "findPackage"));
        }
        if (this.packagePrefixExists(qualifiedName)) {
            return new PsiPackageImpl(PsiManager.getInstance((Project)this.myProject), qualifiedName);
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/impl/PackagePrefixElementFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PackagePrefixElementFinder", "getSubPackages"));
        }
        HashMap packagesMap = new HashMap();
        String qualifiedName = psiPackage.getQualifiedName();
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(scope)) {
            int i;
            String childName;
            if (!StringUtil.isEmpty((String)qualifiedName) && !StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{qualifiedName, "."}) || packagesMap.containsKey(childName = (i = prefix.indexOf(46, qualifiedName.length() + 1)) >= 0 ? prefix.substring(0, i) : prefix)) continue;
            packagesMap.put(childName, new PsiPackageImpl(psiPackage.getManager(), childName));
        }
        packagesMap.remove(qualifiedName);
        PsiPackage[] psiPackageArray = packagesMap.values().toArray(new PsiPackage[packagesMap.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PackagePrefixElementFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    public boolean packagePrefixExists(String packageQName) {
        for (String prefix : this.myPackagePrefixIndex.getAllPackagePrefixes(null)) {
            if (!StringUtil.startsWithConcatenation((String)prefix, (String[])new String[]{packageQName, "."}) && !prefix.equals(packageQName)) continue;
            return true;
        }
        return false;
    }

    public static PackagePrefixElementFinder getInstance(Project project2) {
        for (PsiElementFinder o : (PsiElementFinder[])Extensions.getExtensions((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)project2)) {
            if (!(o instanceof PackagePrefixElementFinder)) continue;
            return (PackagePrefixElementFinder)o;
        }
        throw new UnsupportedOperationException("couldn't find self");
    }
}

