/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private static final char VARIANCE_NONE = '\u0000';
    private static final char VARIANCE_EXTENDS = '+';
    private static final char VARIANCE_SUPER = '-';
    private static final char VARIANCE_INVARIANT = '*';
    private static final String VARIANCE_EXTENDS_PREFIX = "? extends ";
    private static final String VARIANCE_SUPER_PREFIX = "? super ";

    private SignatureParsing() {
    }

    @NotNull
    public static List<Pair<String, String[]>> parseTypeParametersDeclaration(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        if (signature.current() != '<') {
            List<Pair<String, String[]>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeParametersDeclaration"));
            }
            return list;
        }
        ArrayList typeParameters = ContainerUtil.newArrayList();
        signature.next();
        while (signature.current() != '>') {
            typeParameters.add(SignatureParsing.parseTypeParameter(signature, mapping));
        }
        signature.next();
        ArrayList arrayList = typeParameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeParametersDeclaration"));
        }
        return arrayList;
    }

    private static Pair<String, String[]> parseTypeParameter(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (signature.current() != ':' && signature.current() != '\uffff') {
            name.append(signature.current());
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        String parameterName = (String)mapping.fun((Object)name.toString());
        List bounds = null;
        boolean jlo = false;
        while (signature.current() == ':') {
            signature.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(signature, mapping);
            if (bound == null) continue;
            if (bounds == null) {
                if ("java.lang.Object".equals(bound)) {
                    jlo = true;
                    continue;
                }
                bounds = ContainerUtil.newSmartList();
                if (jlo) {
                    bounds.add("java.lang.Object");
                }
            }
            bounds.add(bound);
        }
        return Pair.pair((Object)parameterName, (Object)ArrayUtil.toStringArray(bounds));
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        switch (signature.current()) {
            case 'L': {
                return SignatureParsing.parseParameterizedClassRefSignature(signature, mapping);
            }
            case 'T': {
                return SignatureParsing.parseTypeVariableRefSignature(signature);
            }
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature) {
        StringBuilder id = new StringBuilder();
        signature.next();
        while (signature.current() != ';' && signature.current() != '>') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        StringBuilder canonicalText = new StringBuilder();
        boolean mapped = false;
        signature.next();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            char c = signature.current();
            if (c == '<') {
                canonicalText = new StringBuilder((String)mapping.fun((Object)canonicalText.toString()));
                mapped = true;
                boolean firstArg = true;
                signature.next();
                do {
                    canonicalText.append(firstArg ? (char)'<' : ',').append(SignatureParsing.parseClassOrTypeVariableElement(signature, mapping));
                    firstArg = false;
                } while (signature.current() != '>');
                canonicalText.append('>');
            } else if (c != ' ') {
                canonicalText.append(c);
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        signature.next();
        String text = canonicalText.toString();
        if (!mapped) {
            text = (String)mapping.fun((Object)text);
        }
        return text;
    }

    private static String parseClassOrTypeVariableElement(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText(null, variance);
        }
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature, mapping);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat((String)"[]", (int)dimensions);
        }
        return SignatureParsing.decorateTypeText(text, variance);
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return VARIANCE_EXTENDS_PREFIX + canonical;
            }
            case '-': {
                return VARIANCE_SUPER_PREFIX + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature) {
        char variance;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    private static int parseDimensions(CharacterIterator signature) {
        int dimensions = 0;
        while (signature.current() == '[') {
            ++dimensions;
            signature.next();
        }
        return dimensions;
    }

    @NotNull
    public static String parseTypeString(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        int dimensions = SignatureParsing.parseDimensions(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature, mapping);
        if (text == null) {
            throw new ClsFormatException();
        }
        if (dimensions > 0) {
            text = text + StringUtil.repeat((String)"[]", (int)dimensions);
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/SignatureParsing", "parseTypeString"));
        }
        return string;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature, Function<String, String> mapping) throws ClsFormatException {
        String text = null;
        switch (signature.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature, mapping);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature);
                break;
            }
            case 'B': {
                text = "byte";
                signature.next();
                break;
            }
            case 'C': {
                text = "char";
                signature.next();
                break;
            }
            case 'D': {
                text = "double";
                signature.next();
                break;
            }
            case 'F': {
                text = "float";
                signature.next();
                break;
            }
            case 'I': {
                text = "int";
                signature.next();
                break;
            }
            case 'J': {
                text = "long";
                signature.next();
                break;
            }
            case 'S': {
                text = "short";
                signature.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature.next();
                break;
            }
            case 'V': {
                text = "void";
                signature.next();
            }
        }
        return text;
    }
}

