/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    private static final Class[] INTERMEDIATES = new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiAnnotation.class, PsiTypeParameterList.class};

    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    protected PsiTypeElementImpl(IElementType type) {
        super(type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType getType() {
        PsiType psiType = (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiType>(){

            @Nullable
            public CachedValueProvider.Result<PsiType> compute() {
                return CachedValueProvider.Result.create((Object)PsiTypeElementImpl.this.calculateType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        });
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getType"));
        }
        return psiType;
    }

    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType((PsiTypeElement)this);
        if (inferredType != null) {
            return inferredType;
        }
        Object type = null;
        SmartList annotations = new SmartList();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((Object)((PsiAnnotation)child));
            } else if (child instanceof PsiTypeElement) {
                assert (type == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken((PsiElement)child, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type == null) : this;
                this.addTypeUseCandidateAnnotations((List<PsiAnnotation>)annotations);
                String text = child.getText();
                type = annotations.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text) : new PsiPrimitiveType(text, PsiTypeElementImpl.filterTypeUse((List<PsiAnnotation>)annotations));
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type == null) : this;
                this.addTypeUseCandidateAnnotations((List<PsiAnnotation>)annotations);
                type = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child, null, PsiTypeElementImpl.filterTypeUse((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                assert (type != null) : this;
                type = new PsiArrayType(type, PsiTypeElementImpl.filterTypeUse((List<PsiAnnotation>)annotations));
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) {
                assert (type != null) : this;
                type = new PsiEllipsisType(type, PsiTypeElementImpl.filterTypeUse((List<PsiAnnotation>)annotations));
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)child).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
                PsiElement boundType = PsiTreeUtil.skipSiblingsForward((PsiElement)boundKind, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
                type = PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                type = ((PsiWildcardType)type).annotate(PsiTypeElementImpl.filterTypeUse((List<PsiAnnotation>)annotations));
                break;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type = PsiIntersectionType.createIntersection((boolean)false, (PsiType[])types.toArray(PsiType.createArray((int)types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        return type == null ? PsiType.NULL : type;
    }

    @NotNull
    private static TypeAnnotationProvider filterTypeUse(List<PsiAnnotation> annotations) {
        if (annotations.isEmpty()) {
            TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.EMPTY;
            if (typeAnnotationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "filterTypeUse"));
            }
            return typeAnnotationProvider;
        }
        final ArrayList copy = ContainerUtil.newArrayList(annotations);
        annotations.clear();
        TypeAnnotationProvider typeAnnotationProvider = new TypeAnnotationProvider(){
            private volatile PsiAnnotation[] myCached;

            @NotNull
            public PsiAnnotation[] getAnnotations() {
                PsiAnnotation[] result = this.myCached;
                if (result == null) {
                    List filtered = ContainerUtil.filter((Collection)copy, (Condition)new Condition<PsiAnnotation>(){

                        public boolean value(PsiAnnotation annotation) {
                            return PsiImplUtil.isTypeAnnotation((PsiElement)annotation);
                        }
                    });
                    result = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(new PsiAnnotation[filtered.size()]);
                    this.myCached = result;
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$2", "getAnnotations"));
                }
                return result;
            }
        };
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "filterTypeUse"));
        }
        return typeAnnotationProvider;
    }

    private void addTypeUseCandidateAnnotations(List<PsiAnnotation> annotations) {
        PsiTypeElementImpl parent = this;
        while (parent instanceof PsiTypeElement) {
            PsiElement left = PsiTreeUtil.skipSiblingsBackward((PsiElement)parent, (Class[])INTERMEDIATES);
            if (left instanceof PsiModifierList) {
                Collections.addAll(annotations, ((PsiModifierList)left).getAnnotations());
                break;
            }
            if (left != null) break;
            parent = parent.getParent();
        }
    }

    private List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        return ContainerUtil.map((Collection)typeElements, (Function)new Function<PsiTypeElement, PsiType>(){

            public PsiType fun(PsiTypeElement typeElement) {
                return typeElement.getType();
            }
        });
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        List annotations = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiAnnotation.class);
        this.addTypeUseCandidateAnnotations(annotations);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])annotations.toArray(PsiAnnotation.ARRAY_FACTORY.create(annotations.size()));
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiTypeElementImpl", "replace"));
        }
        PsiImplUtil.markTypeAnnotations(this);
        PsiElement result = super.replace(newElement);
        PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        return result;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

