/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class XmlFileImpl
extends PsiFileImpl
implements XmlFile {
    private FileType myType = null;

    public XmlFileImpl(FileViewProvider viewProvider, IElementType elementType) {
        super(elementType, elementType, viewProvider);
    }

    public XmlDocument getDocument() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof XmlDocument)) continue;
            return (XmlDocument)child;
        }
        return null;
    }

    public XmlTag getRootTag() {
        XmlDocument document = this.getDocument();
        return document == null ? null : document.getRootTag();
    }

    public boolean processElements(PsiElementProcessor processor2, PsiElement place) {
        XmlDocument document = this.getDocument();
        return document == null || document.processElements(processor2, place);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/xml/XmlFileImpl", "accept"));
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlFile((XmlFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @Override
    public String toString() {
        return "XmlFile:" + this.getName();
    }

    @NotNull
    public FileType getFileType() {
        if (this.myType == null) {
            this.myType = this.getLanguage().getAssociatedFileType();
            if (this.myType == null) {
                VirtualFile virtualFile = this.getOriginalFile().getVirtualFile();
                this.myType = virtualFile == null ? FileTypeRegistry.getInstance().getFileTypeByFileName(this.getName()) : virtualFile.getFileType();
            }
        }
        FileType fileType = this.myType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlFileImpl", "getFileType"));
        }
        return fileType;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        if (this.isWebFileType()) {
            ScriptSupportUtil.clearCaches(this);
        }
    }

    private boolean isWebFileType() {
        return this.getLanguage() == XHTMLLanguage.INSTANCE || this.getLanguage() == HTMLLanguage.INSTANCE;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/xml/XmlFileImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/xml/XmlFileImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/xml/XmlFileImpl", "processDeclarations"));
        }
        return super.processDeclarations(processor2, state, lastParent, place) && (!this.isWebFileType() || ScriptSupportUtil.processDeclarations(this, processor2, state, lastParent, place));
    }

    @NotNull
    public GlobalSearchScope getFileResolveScope() {
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope((Project)this.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/XmlFileImpl", "getFileResolveScope"));
        }
        return globalSearchScope;
    }

    public boolean ignoreReferencedElementAccessibility() {
        return true;
    }
}

