/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.RenameProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenameChangeInfo
implements ChangeInfo {
    private final PsiFile myFile;
    private final int myOffset;
    private final String myOldName;

    public RenameChangeInfo(PsiNameIdentifierOwner namedElement, ChangeInfo oldInfo) {
        this.myOldName = oldInfo instanceof RenameChangeInfo ? ((RenameChangeInfo)oldInfo).getOldName() : namedElement.getName();
        this.myFile = namedElement.getContainingFile();
        this.myOffset = namedElement.getTextOffset();
    }

    @NotNull
    public ParameterInfo[] getNewParameters() {
        ParameterInfo[] parameterInfoArray = new ParameterInfo[]{};
        if (parameterInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/RenameChangeInfo", "getNewParameters"));
        }
        return parameterInfoArray;
    }

    public boolean isParameterSetOrOrderChanged() {
        return false;
    }

    public boolean isParameterTypesChanged() {
        return false;
    }

    public boolean isParameterNamesChanged() {
        return false;
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    public boolean isNameChanged() {
        return true;
    }

    public PsiElement getMethod() {
        return this.getNamedElement();
    }

    public boolean isReturnTypeChanged() {
        return false;
    }

    public String getNewName() {
        PsiNameIdentifierOwner nameOwner = this.getNamedElement();
        return nameOwner != null ? nameOwner.getName() : null;
    }

    public String getOldName() {
        return this.myOldName;
    }

    @Nullable
    public PsiNameIdentifierOwner getNamedElement() {
        return (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), PsiNameIdentifierOwner.class);
    }

    public void perform() {
        final PsiNameIdentifierOwner element = this.getNamedElement();
        if (element != null) {
            String name = element.getName();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    element.setName(RenameChangeInfo.this.myOldName);
                }
            });
            new RenameProcessor(element.getProject(), (PsiElement)element, name, false, false).run();
        }
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        PsiNameIdentifierOwner namedElement = this.getNamedElement();
        return namedElement != null ? namedElement.getNameIdentifier() : null;
    }
}

