/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationHandler;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationProcessor;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationUtil;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.classMembers.InterfaceMemberDependencyGraph;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceToDelegationDialog
extends RefactoringDialog {
    private final PsiClass[] mySuperClasses;
    private final PsiClass myClass;
    private final HashMap<PsiClass, Collection<MemberInfo>> myBasesToMemberInfos;
    private NameSuggestionsField myFieldNameField;
    private NameSuggestionsField myInnerClassNameField;
    private JCheckBox myCbGenerateGetter;
    private MemberSelectionPanel myMemberSelectionPanel;
    private JComboBox myClassCombo;
    private final Project myProject;
    private MyClassComboItemListener myClassComboItemListener;
    private NameSuggestionsField.DataChanged myDataChangedListener;

    public InheritanceToDelegationDialog(Project project2, PsiClass aClass, PsiClass[] superClasses, HashMap<PsiClass, Collection<MemberInfo>> basesToMemberInfos) {
        super(project2, true);
        this.myProject = project2;
        this.myClass = aClass;
        this.mySuperClasses = superClasses;
        this.myBasesToMemberInfos = basesToMemberInfos;
        this.setTitle(InheritanceToDelegationHandler.REFACTORING_NAME);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFieldNameField;
    }

    protected void dispose() {
        this.myInnerClassNameField.removeDataChangedListener(this.myDataChangedListener);
        this.myFieldNameField.removeDataChangedListener(this.myDataChangedListener);
        this.myClassCombo.removeItemListener(this.myClassComboItemListener);
        super.dispose();
    }

    @NotNull
    public String getFieldName() {
        String string = this.myFieldNameField.getEnteredName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationDialog", "getFieldName"));
        }
        return string;
    }

    @Nullable
    public String getInnerClassName() {
        if (this.myInnerClassNameField != null) {
            return this.myInnerClassNameField.getEnteredName();
        }
        return null;
    }

    public boolean isGenerateGetter() {
        return this.myCbGenerateGetter.isSelected();
    }

    @Override
    protected void canRun() throws ConfigurationException {
        String className;
        String fieldName = this.getFieldName();
        PsiNameHelper helper = PsiNameHelper.getInstance((Project)this.myProject);
        if (!helper.isIdentifier(fieldName)) {
            throw new ConfigurationException("'" + fieldName + "' is invalid field name for delegation");
        }
        if (this.myInnerClassNameField != null && !helper.isIdentifier(className = this.myInnerClassNameField.getEnteredName())) {
            throw new ConfigurationException("'" + className + "' is invalid inner class name");
        }
    }

    public Collection<MemberInfo> getSelectedMemberInfos() {
        return this.myMemberSelectionPanel.getTable().getSelectedMemberInfos();
    }

    public PsiClass getSelectedTargetClass() {
        return (PsiClass)this.myClassCombo.getSelectedItem();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.replaceInheritWithDelegat");
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings.getInstance().INHERITANCE_TO_DELEGATION_DELEGATE_OTHER = this.myCbGenerateGetter.isSelected();
        Collection<MemberInfo> selectedMemberInfos = this.getSelectedMemberInfos();
        ArrayList<PsiClass> implementedInterfaces = new ArrayList<PsiClass>();
        ArrayList<PsiMethod> delegatedMethods = new ArrayList<PsiMethod>();
        for (MemberInfo memberInfo : selectedMemberInfos) {
            PsiElement member = memberInfo.getMember();
            if (member instanceof PsiClass && Boolean.FALSE.equals(memberInfo.getOverrides())) {
                implementedInterfaces.add((PsiClass)member);
                continue;
            }
            if (!(member instanceof PsiMethod)) continue;
            delegatedMethods.add((PsiMethod)member);
        }
        this.invokeRefactoring(new InheritanceToDelegationProcessor(this.myProject, this.myClass, this.getSelectedTargetClass(), this.getFieldName(), this.getInnerClassName(), implementedInterfaces.toArray(new PsiClass[implementedInterfaces.size()]), delegatedMethods.toArray(new PsiMethod[delegatedMethods.size()]), this.isGenerateGetter(), this.isGenerateGetter()));
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(4, 0, 0, 8);
        this.myClassCombo = new JComboBox<PsiClass>(this.mySuperClasses);
        this.myClassCombo.setRenderer(new ClassCellRenderer(this.myClassCombo.getRenderer()));
        gbc.gridwidth = 2;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbc);
        ++gbc.gridy;
        panel.add((Component)this.myClassCombo, gbc);
        classComboLabel.setText(RefactoringBundle.message((String)"replace.inheritance.from"));
        this.myClassComboItemListener = new MyClassComboItemListener();
        this.myClassCombo.addItemListener(this.myClassComboItemListener);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 0, 4, 0);
        JLabel fieldNameLabel = new JLabel();
        panel.add((Component)fieldNameLabel, gbc);
        this.myFieldNameField = new NameSuggestionsField(this.myProject);
        ++gbc.gridx;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(4, 0, 4, 8);
        gbc.weightx = 1.0;
        panel.add((Component)this.myFieldNameField.getComponent(), gbc);
        fieldNameLabel.setText(RefactoringBundle.message((String)"field.name"));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 0, 4, 0);
        gbc.weightx = 0.0;
        JLabel innerClassNameLabel = new JLabel();
        panel.add((Component)innerClassNameLabel, gbc);
        this.myInnerClassNameField = new NameSuggestionsField(this.myProject);
        ++gbc.gridx;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(4, 4, 4, 8);
        gbc.weightx = 1.0;
        panel.add((Component)this.myInnerClassNameField.getComponent(), gbc);
        innerClassNameLabel.setText(RefactoringBundle.message((String)"inner.class.name"));
        boolean innerClassNeeded = false;
        for (PsiClass superClass : this.mySuperClasses) {
            innerClassNeeded |= InheritanceToDelegationUtil.isInnerClassNeeded(this.myClass, superClass);
        }
        this.myInnerClassNameField.setVisible(innerClassNeeded);
        innerClassNameLabel.setVisible(innerClassNeeded);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 0, 4, 4);
        this.myMemberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"delegate.members"), Collections.emptyList(), null);
        panel.add((Component)this.myMemberSelectionPanel, gbc);
        MyMemberInfoModel memberInfoModel = new MyMemberInfoModel();
        this.myMemberSelectionPanel.getTable().setMemberInfoModel(memberInfoModel);
        this.myMemberSelectionPanel.getTable().addMemberInfoChangeListener(memberInfoModel);
        ++gbc.gridy;
        gbc.insets = new Insets(4, 8, 0, 8);
        gbc.weighty = 0.0;
        this.myCbGenerateGetter = new JCheckBox(RefactoringBundle.message((String)"generate.getter.for.delegated.component"));
        this.myCbGenerateGetter.setFocusable(false);
        panel.add((Component)this.myCbGenerateGetter, gbc);
        this.myCbGenerateGetter.setSelected(JavaRefactoringSettings.getInstance().INHERITANCE_TO_DELEGATION_DELEGATE_OTHER);
        this.updateTargetClass();
        return panel;
    }

    private void updateTargetClass() {
        PsiClass targetClass = this.getSelectedTargetClass();
        PsiManager psiManager = this.myClass.getManager();
        PsiClassType superType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(targetClass);
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName(VariableKind.FIELD, null, null, (PsiType)superType);
        this.myFieldNameField.setSuggestions(suggestedNameInfo.names);
        this.myInnerClassNameField.getComponent().setEnabled(InheritanceToDelegationUtil.isInnerClassNeeded(this.myClass, targetClass));
        String suggestion = "My" + targetClass.getName();
        this.myInnerClassNameField.setSuggestions(new String[]{suggestion});
        this.myDataChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                InheritanceToDelegationDialog.this.validateButtons();
            }
        };
        this.myInnerClassNameField.addDataChangedListener(this.myDataChangedListener);
        this.myFieldNameField.addDataChangedListener(this.myDataChangedListener);
        this.myMemberSelectionPanel.getTable().setMemberInfos(this.myBasesToMemberInfos.get(targetClass));
        this.myMemberSelectionPanel.getTable().fireExternalDataChange();
    }

    private class MyClassComboItemListener
    implements ItemListener {
        private MyClassComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                InheritanceToDelegationDialog.this.updateTargetClass();
            }
        }
    }

    private class MyMemberInfoModel
    implements MemberInfoModel<PsiMember, MemberInfo> {
        final HashMap<PsiClass, InterfaceMemberDependencyGraph<PsiMember, MemberInfo>> myGraphs = new HashMap();

        public MyMemberInfoModel() {
            for (PsiClass superClass : InheritanceToDelegationDialog.this.mySuperClasses) {
                this.myGraphs.put(superClass, new InterfaceMemberDependencyGraph(superClass));
            }
        }

        public boolean isMemberEnabled(MemberInfo memberInfo) {
            return !this.getGraph().getDependent().contains(memberInfo.getMember());
        }

        public boolean isCheckedWhenDisabled(MemberInfo member) {
            return true;
        }

        public boolean isAbstractEnabled(MemberInfo member) {
            return false;
        }

        public boolean isAbstractWhenDisabled(MemberInfo member) {
            return false;
        }

        public Boolean isFixedAbstract(MemberInfo member) {
            return null;
        }

        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationDialog$MyMemberInfoModel", "checkForProblems"));
            }
            return 0;
        }

        public String getTooltipText(MemberInfo member) {
            return null;
        }

        public void memberInfoChanged(MemberInfoChange<PsiMember, MemberInfo> event) {
            Collection changedMembers = event.getChangedMembers();
            for (MemberInfo changedMember : changedMembers) {
                this.getGraph().memberChanged(changedMember);
            }
        }

        private InterfaceMemberDependencyGraph<PsiMember, MemberInfo> getGraph() {
            return this.myGraphs.get(InheritanceToDelegationDialog.this.getSelectedTargetClass());
        }
    }
}

