/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceParameter.EnclosingMethodSelectionDialog;
import com.intellij.refactoring.introduceParameter.InplaceIntroduceParameterPopup;
import com.intellij.refactoring.introduceParameter.IntroduceParameterDialog;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.MethodCellRenderer;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairConsumer;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceParameterHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceParameter.IntroduceParameterHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private JBPopup myEnclosingMethodsPopup;
    private InplaceIntroduceParameterPopup myInplaceIntroduceParameterPopup;

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        ElementToWorkOn.processElementToWorkOn(editor, file2, REFACTORING_NAME, "refactoring.introduceParameter", project2, new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            @Override
            public boolean accept(ElementToWorkOn el) {
                return true;
            }

            @Override
            public void pass(ElementToWorkOn elementToWorkOn) {
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getLocalVariable() == null && elementToWorkOn.getExpression() == null) {
                    if (!IntroduceParameterHandler.this.introduceStrategy(project2, editor, file2)) {
                        ElementToWorkOn.showNothingSelectedErrorMessage(editor, REFACTORING_NAME, "refactoring.introduceParameter", project2);
                    }
                    return;
                }
                PsiExpression expr = elementToWorkOn.getExpression();
                PsiLocalVariable localVar = elementToWorkOn.getLocalVariable();
                boolean isInvokedOnDeclaration = elementToWorkOn.isInvokedOnDeclaration();
                IntroduceParameterHandler.this.invoke(editor, project2, expr, localVar, isInvokedOnDeclaration);
            }
        });
    }

    @Override
    protected boolean invokeImpl(Project project2, PsiExpression tempExpr, Editor editor) {
        return this.invoke(editor, project2, tempExpr, null, false);
    }

    @Override
    protected boolean invokeImpl(Project project2, PsiLocalVariable localVariable, Editor editor) {
        return this.invoke(editor, project2, null, localVariable, true);
    }

    private boolean invoke(Editor editor, Project project2, PsiExpression expr, PsiLocalVariable localVar, boolean invokedOnDeclaration) {
        PsiType typeByExpression;
        PsiElement parent;
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project2).hasUncommitedDocuments());
        PsiMethod method = expr != null ? Util.getContainingMethod((PsiElement)expr) : Util.getContainingMethod((PsiElement)localVar);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null && localVar == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (localVar != null && !((parent = localVar.getParent()) instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (method == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME}));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        PsiType psiType = typeByExpression = invokedOnDeclaration ? null : RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
        if (!invokedOnDeclaration && (typeByExpression == null || LambdaUtil.notInferredType((PsiType)typeByExpression))) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"type.of.the.selected.expression.cannot.be.determined"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        if (!invokedOnDeclaration && PsiType.VOID.equals((Object)typeByExpression)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            IntroduceParameterHandler.showErrorMessage(project2, message, editor);
            return false;
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.isEmpty()) {
            return false;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)method)) {
            return false;
        }
        final Introducer introducer = new Introducer(project2, expr, localVar, editor);
        AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
        if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
            InplaceIntroduceParameterPopup introduceParameterPopup = (InplaceIntroduceParameterPopup)inplaceIntroducer;
            introducer.introduceParameter(introduceParameterPopup.getMethodToIntroduceParameter(), introduceParameterPopup.getMethodToSearchFor());
            return true;
        }
        this.chooseMethodToIntroduceParameter(editor, validEnclosingMethods, new PairConsumer<PsiMethod, PsiMethod>(){

            public void consume(PsiMethod methodToSearchIn, PsiMethod methodToSearchFor) {
                introducer.introduceParameter(methodToSearchIn, methodToSearchFor);
            }
        });
        return true;
    }

    private void chooseMethodToIntroduceParameter(final Editor editor, List<PsiMethod> validEnclosingMethods, final PairConsumer<PsiMethod, PsiMethod> consumer) {
        PsiMethod methodToIntroduceParameterTo;
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if ((validEnclosingMethods.size() == 1 || unitTestMode) && ((methodToIntroduceParameterTo = validEnclosingMethods.get(0)).findDeepestSuperMethod() == null || unitTestMode)) {
            consumer.consume((Object)methodToIntroduceParameterTo, (Object)methodToIntroduceParameterTo);
            return;
        }
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox superMethod = new JCheckBox("Refactor super method", true);
        superMethod.setMnemonic('U');
        panel.add((Component)superMethod, "South");
        final JBList list = new JBList(validEnclosingMethods.toArray());
        list.setVisibleRowCount(5);
        list.setCellRenderer((ListCellRenderer)new MethodCellRenderer());
        list.getSelectionModel().setSelectionMode(0);
        list.setSelectedIndex(0);
        final ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        final TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PsiMethod selectedMethod = (PsiMethod)list.getSelectedValue();
                if (selectedMethod == null) {
                    return;
                }
                IntroduceParameterHandler.dropHighlighters(highlighters);
                IntroduceParameterHandler.updateView(selectedMethod, editor, attributes, highlighters, superMethod);
            }
        });
        IntroduceParameterHandler.updateView(validEnclosingMethods.get(0), editor, attributes, highlighters, superMethod);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)list);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        List<Pair> keyboardActions = Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final PsiMethod methodToSearchIn = (PsiMethod)list.getSelectedValue();
                if (IntroduceParameterHandler.this.myEnclosingMethodsPopup != null && IntroduceParameterHandler.this.myEnclosingMethodsPopup.isVisible()) {
                    IntroduceParameterHandler.this.myEnclosingMethodsPopup.cancel();
                }
                final PsiMethod methodToSearchFor = superMethod.isEnabled() && superMethod.isSelected() ? methodToSearchIn.findDeepestSuperMethod() : methodToSearchIn;
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        consumer.consume((Object)methodToSearchIn, (Object)methodToSearchFor);
                    }
                };
                IdeFocusManager.findInstance().doWhenFocusSettlesDown(runnable2);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)));
        this.myEnclosingMethodsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)list).setTitle("Introduce parameter to method").setMovable(false).setResizable(false).setRequestFocus(true).setKeyboardActions(keyboardActions).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                IntroduceParameterHandler.dropHighlighters(highlighters);
            }
        }).createPopup();
        this.myEnclosingMethodsPopup.showInBestPositionFor(editor);
    }

    private static void updateView(PsiMethod selectedMethod, Editor editor, TextAttributes attributes, List<RangeHighlighter> highlighters, JCheckBox superMethod) {
        MarkupModel markupModel = editor.getMarkupModel();
        PsiIdentifier nameIdentifier = selectedMethod.getNameIdentifier();
        if (nameIdentifier != null) {
            TextRange textRange = nameIdentifier.getTextRange();
            RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(rangeHighlighter);
        }
        superMethod.setEnabled(selectedMethod.findDeepestSuperMethod() != null);
    }

    private static void dropHighlighters(List<RangeHighlighter> highlighters) {
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
    }

    protected static NameSuggestionsGenerator createNameSuggestionGenerator(final PsiExpression expr, final String propName, final Project project2, final String enteredName) {
        return new NameSuggestionsGenerator(){

            @Override
            public SuggestedNameInfo getSuggestedNameInfo(PsiType type) {
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, propName, expr != null && expr.isValid() ? expr : null, type);
                if (expr != null && expr.isValid()) {
                    info = codeStyleManager.suggestUniqueVariableName(info, (PsiElement)expr, true);
                }
                String[] strings = AbstractJavaInplaceIntroducer.appendUnresolvedExprName(JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, info), expr);
                return new SuggestedNameInfo.Delegate(enteredName != null ? ArrayUtil.mergeArrays((String[])new String[]{enteredName}, (String[])strings) : strings, info);
            }
        };
    }

    private static void showErrorMessage(Project project2, String message, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.introduceParameter");
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "invoke"));
        }
    }

    public static List<PsiMethod> getEnclosingMethods(PsiMethod nearest) {
        ArrayList<PsiMethod> enclosingMethods = new ArrayList<PsiMethod>();
        enclosingMethods.add(nearest);
        PsiMethod method = nearest;
        while ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class, (boolean)true)) != null) {
            enclosingMethods.add(method);
        }
        if (enclosingMethods.size() > 1) {
            ArrayList<PsiMethod> methodsNotImplementingLibraryInterfaces = new ArrayList<PsiMethod>();
            for (PsiMethod enclosing : enclosingMethods) {
                PsiMethod[] superMethods = enclosing.findDeepestSuperMethods();
                boolean libraryInterfaceMethod = false;
                for (PsiMethod superMethod : superMethods) {
                    libraryInterfaceMethod |= IntroduceParameterHandler.isLibraryInterfaceMethod(superMethod);
                }
                if (libraryInterfaceMethod) continue;
                methodsNotImplementingLibraryInterfaces.add(enclosing);
            }
            if (methodsNotImplementingLibraryInterfaces.size() > 0) {
                return methodsNotImplementingLibraryInterfaces;
            }
        }
        return enclosingMethods;
    }

    @Nullable
    public static PsiMethod chooseEnclosingMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler", "chooseEnclosingMethod"));
        }
        List<PsiMethod> validEnclosingMethods = IntroduceParameterHandler.getEnclosingMethods(method);
        if (validEnclosingMethods.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
            EnclosingMethodSelectionDialog dialog = new EnclosingMethodSelectionDialog(method.getProject(), validEnclosingMethods);
            if (!dialog.showAndGet()) {
                return null;
            }
            method = dialog.getSelectedMethod();
        } else if (validEnclosingMethods.size() == 1) {
            method = validEnclosingMethods.get(0);
        }
        return method;
    }

    private static boolean isLibraryInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !method.getManager().isInProject((PsiElement)method);
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceParameterPopup;
    }

    @VisibleForTesting
    public boolean introduceStrategy(Project project2, Editor editor, PsiFile file2) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            PsiElement[] elements = CodeInsightUtil.findStatementsInRange(file2, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            return this.introduceStrategy(project2, editor, file2, elements);
        }
        return false;
    }

    @VisibleForTesting
    public boolean introduceStrategy(final Project project2, final Editor editor, PsiFile file2, final PsiElement[] elements) {
        if (elements.length > 0) {
            PsiElement[] psiElementArray;
            AbstractInplaceIntroducer inplaceIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(editor);
            if (inplaceIntroducer instanceof InplaceIntroduceParameterPopup) {
                return false;
            }
            final List<PsiMethod> enclosingMethods = IntroduceParameterHandler.getEnclosingMethods(Util.getContainingMethod(elements[0]));
            if (enclosingMethods.isEmpty()) {
                return false;
            }
            PsiFile copy = PsiFileFactory.getInstance((Project)project2).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)file2.getText(), file2.getModificationStamp(), false);
            PsiExpression exprInRange = CodeInsightUtil.findExpressionInRange(copy, elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset());
            if (exprInRange != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = exprInRange;
            } else {
                psiElementArray = CodeInsightUtil.findStatementsInRange(copy, elements[0].getTextRange().getStartOffset(), elements[elements.length - 1].getTextRange().getEndOffset());
            }
            PsiElement[] elementsCopy = psiElementArray;
            List<PsiMethod> enclosingMethodsInCopy = IntroduceParameterHandler.getEnclosingMethods(Util.getContainingMethod(elementsCopy[0]));
            final MyExtractMethodProcessor processor2 = new MyExtractMethodProcessor(project2, editor, elementsCopy, enclosingMethodsInCopy.get(enclosingMethodsInCopy.size() - 1));
            try {
                if (!processor2.prepare()) {
                    return false;
                }
                processor2.showDialog();
                PsiMethod emptyMethod = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText(processor2.generateEmptyMethod("name").getText(), elements[0]);
                Collection<? extends PsiType> types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces(emptyMethod);
                if (types.isEmpty()) {
                    return false;
                }
                if (types.size() != 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    final LinkedHashMap<PsiClass, PsiType> classes = new LinkedHashMap<PsiClass, PsiType>();
                    for (PsiType psiType : types) {
                        classes.put(PsiUtil.resolveClassInType((PsiType)psiType), psiType);
                    }
                    PsiClass[] psiClasses = classes.keySet().toArray(new PsiClass[classes.size()]);
                    String string = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
                    PsiType returnType = emptyMethod.getReturnType();
                    LOG.assertTrue(returnType != null);
                    String title = "Choose Applicable Functional Interface: " + string + " -> " + returnType.getPresentableText();
                    NavigationUtil.getPsiElementPopup((PsiElement[])psiClasses, (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                        public boolean execute(@NotNull PsiClass psiClass) {
                            if (psiClass == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/refactoring/introduceParameter/IntroduceParameterHandler$7", "execute"));
                            }
                            IntroduceParameterHandler.this.functionalInterfaceSelected((PsiType)classes.get(psiClass), enclosingMethods, project2, editor, processor2, elements);
                            return true;
                        }
                    }).showInBestPositionFor(editor);
                    return true;
                }
                PsiType next = types.iterator().next();
                this.functionalInterfaceSelected(next, enclosingMethods, project2, editor, processor2, elements);
                return true;
            }
            catch (IncorrectOperationException incorrectOperationException) {
            }
            catch (PrepareFailedException prepareFailedException) {
                // empty catch block
            }
        }
        return false;
    }

    private void functionalInterfaceSelected(final PsiType selectedType, List<PsiMethod> enclosingMethods, final Project project2, final Editor editor, final MyExtractMethodProcessor processor2, final PsiElement[] elements) {
        PairConsumer<PsiMethod, PsiMethod> consumer = new PairConsumer<PsiMethod, PsiMethod>(){

            public void consume(PsiMethod methodToIntroduceParameter, PsiMethod methodToSearchFor) {
                IntroduceParameterHandler.this.introduceWrappedCodeBlockParameter(methodToIntroduceParameter, methodToSearchFor, editor, project2, selectedType, processor2, elements);
            }
        };
        this.chooseMethodToIntroduceParameter(editor, enclosingMethods, consumer);
    }

    private void introduceWrappedCodeBlockParameter(PsiMethod methodToIntroduceParameter, PsiMethod methodToSearchFor, Editor editor, Project project2, PsiType selectedType, final MyExtractMethodProcessor processor2, PsiElement[] elements) {
        PsiElement containerCopy;
        PsiElement commonParent;
        PsiElement psiElement = commonParent = elements.length > 1 ? PsiTreeUtil.findCommonParent((PsiElement[])elements) : PsiTreeUtil.getParentOfType((PsiElement)elements[0].getParent(), PsiCodeBlock.class, (boolean)false);
        if (commonParent == null) {
            LOG.error("Should have common parent:" + Arrays.toString(elements));
            return;
        }
        RangeMarker marker = editor.getDocument().createRangeMarker(commonParent.getTextRange());
        Object[] copyElements = processor2.getElements();
        PsiElement psiElement2 = containerCopy = copyElements.length > 1 ? PsiTreeUtil.findCommonParent((PsiElement[])copyElements) : PsiTreeUtil.getParentOfType((PsiElement)copyElements[0].getParent(), PsiCodeBlock.class, (boolean)false);
        if (containerCopy == null) {
            LOG.error("Should have common parent:" + Arrays.toString(copyElements));
            return;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        final PsiClass wrapperClass = resolveResult.getElement();
        LOG.assertTrue(wrapperClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        Ref suffixText = new Ref();
        Ref prefixText = new Ref();
        Ref methodText = new Ref();
        WriteCommandAction.runWriteCommandAction((Project)project2, (Runnable)new Runnable((PsiElement[])copyElements, resolveResult, factory, methodText, prefixText, containerCopy, suffixText){
            final /* synthetic */ PsiElement[] val$copyElements;
            final /* synthetic */ PsiClassType.ClassResolveResult val$resolveResult;
            final /* synthetic */ PsiElementFactory val$factory;
            final /* synthetic */ Ref val$methodText;
            final /* synthetic */ Ref val$prefixText;
            final /* synthetic */ PsiElement val$containerCopy;
            final /* synthetic */ Ref val$suffixText;
            {
                this.val$copyElements = psiElementArray;
                this.val$resolveResult = classResolveResult;
                this.val$factory = psiElementFactory;
                this.val$methodText = ref;
                this.val$prefixText = ref2;
                this.val$containerCopy = psiElement;
                this.val$suffixText = ref3;
            }

            @Override
            public void run() {
                PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
                LOG.assertTrue(method != null);
                String interfaceMethodName = method.getName();
                processor2.setMethodName(interfaceMethodName);
                if (this.val$copyElements.length == 1) {
                    this.val$copyElements[0].putUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL, (Object)true);
                }
                processor2.doExtract();
                PsiMethod extractedMethod = processor2.getExtractedMethod();
                PsiParameter[] parameters = extractedMethod.getParameterList().getParameters();
                PsiParameter[] interfaceParameters = method.getParameterList().getParameters();
                PsiSubstitutor substitutor = this.val$resolveResult.getSubstitutor();
                for (int i = 0; i < interfaceParameters.length; ++i) {
                    PsiTypeElement typeAfterInterface = this.val$factory.createTypeElement(substitutor.substitute(interfaceParameters[i].getType()));
                    PsiTypeElement typeElement = parameters[i].getTypeElement();
                    if (typeElement == null) continue;
                    typeElement.replace((PsiElement)typeAfterInterface);
                }
                this.val$methodText.set((Object)extractedMethod.getText());
                PsiMethodCallExpression methodCall = processor2.getMethodCall();
                this.val$prefixText.set((Object)this.val$containerCopy.getText().substring(0, methodCall.getTextRange().getStartOffset() - this.val$containerCopy.getTextRange().getStartOffset()));
                this.val$suffixText.set((Object)("." + methodCall.getText() + this.val$containerCopy.getText().substring(methodCall.getTextRange().getEndOffset() - this.val$containerCopy.getTextRange().getStartOffset())));
            }
        });
        PsiExpression expression = factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {" + (String)methodText.get() + "}", elements[0]);
        expression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)expression);
        expression.putUserData(ElementToWorkOn.PARENT, (Object)commonParent);
        expression.putUserData(ElementToWorkOn.PREFIX, prefixText.get());
        expression.putUserData(ElementToWorkOn.SUFFIX, suffixText.get());
        expression.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)marker);
        new Introducer(project2, expression, null, editor).introduceParameter(methodToIntroduceParameter, methodToSearchFor);
    }

    private static class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        private final PsiMethod myTopEnclosingMethod;

        public MyExtractMethodProcessor(Project project2, Editor editor, PsiElement[] elements, PsiMethod topEnclosing) {
            super(project2, editor, elements, null, REFACTORING_NAME, null, null);
            this.myTopEnclosingMethod = topEnclosing;
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            return new MyAbstractExtractDialog();
        }

        @Override
        protected boolean isNeedToChangeCallContext() {
            return false;
        }

        public void setMethodName(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        public Boolean hasDuplicates() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        public boolean prepare(@Nullable Pass<ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare = super.prepare(pass);
            if (prepare && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare;
        }

        private class MyAbstractExtractDialog
        implements AbstractExtractDialog {
            private MyAbstractExtractDialog() {
            }

            @Override
            public String getChosenMethodName() {
                return "name";
            }

            @Override
            public VariableData[] getChosenParameters() {
                InputVariables inputVariables = MyExtractMethodProcessor.this.getInputVariables();
                ArrayList<VariableData> datas = new ArrayList<VariableData>();
                for (VariableData data : inputVariables.getInputVariables()) {
                    PsiVariable variable = data.variable;
                    if (variable instanceof PsiParameter && MyExtractMethodProcessor.this.myTopEnclosingMethod.equals(((PsiParameter)variable).getDeclarationScope())) continue;
                    datas.add(data);
                }
                return datas.toArray(new VariableData[datas.size()]);
            }

            @Override
            public String getVisibility() {
                return "public";
            }

            @Override
            public boolean isMakeStatic() {
                return false;
            }

            @Override
            public boolean isChainedConstructor() {
                return false;
            }

            @Override
            public PsiType getReturnType() {
                return null;
            }

            @Override
            public void show() {
            }

            @Override
            public boolean isOK() {
                return true;
            }
        }
    }

    private class Introducer {
        private final Project myProject;
        private PsiExpression myExpr;
        private PsiLocalVariable myLocalVar;
        private final Editor myEditor;

        public Introducer(Project project2, PsiExpression expr, PsiLocalVariable localVar, Editor editor) {
            this.myProject = project2;
            this.myExpr = expr;
            this.myLocalVar = localVar;
            this.myEditor = editor;
        }

        public void introduceParameter(PsiMethod method, PsiMethod methodToSearchFor) {
            boolean isInplaceAvailableOnDataContext;
            PsiExpression[] occurences = this.myExpr != null ? new ExpressionOccurrenceManager(this.myExpr, (PsiElement)method, null).findExpressionOccurrences() : CodeInsightUtil.findReferenceExpressions((PsiElement)method, (PsiElement)this.myLocalVar);
            String enteredName = null;
            boolean replaceAllOccurrences = false;
            boolean delegate = false;
            PsiType initializerType = IntroduceParameterProcessor.getInitializerType(null, this.myExpr, this.myLocalVar);
            AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer(this.myEditor);
            if (activeIntroducer != null) {
                activeIntroducer.stopIntroduce(this.myEditor);
                this.myExpr = (PsiExpression)activeIntroducer.getExpr();
                this.myLocalVar = (PsiLocalVariable)activeIntroducer.getLocalVariable();
                occurences = (PsiExpression[])activeIntroducer.getOccurrences();
                enteredName = activeIntroducer.getInputName();
                replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
                delegate = ((InplaceIntroduceParameterPopup)activeIntroducer).isGenerateDelegate();
                initializerType = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            }
            boolean mustBeFinal = false;
            if (this.myExpr != null) {
                PsiExpression[] parent = (PsiExpression[])this.myExpr.getUserData(ElementToWorkOn.PARENT);
                mustBeFinal = parent != null && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) != method;
            }
            for (PsiElement psiElement : occurences) {
                if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiClass.class, PsiMethod.class}) == method) continue;
                mustBeFinal = true;
                break;
            }
            String propName = this.myLocalVar != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myLocalVar.getName(), VariableKind.LOCAL_VARIABLE) : null;
            boolean bl = isInplaceAvailableOnDataContext = this.myEditor != null && this.myEditor.getSettings().isVariableInplaceRenameEnabled();
            if (this.myExpr != null) {
                isInplaceAvailableOnDataContext &= this.myExpr.isPhysical();
            }
            if (isInplaceAvailableOnDataContext && activeIntroducer == null) {
                IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup = new InplaceIntroduceParameterPopup(this.myProject, this.myEditor, this.createTypeSelectorManager(occurences, initializerType), this.myExpr, this.myLocalVar, method, methodToSearchFor, occurences, this.getParamsToRemove(method, occurences), mustBeFinal);
                if (IntroduceParameterHandler.this.myInplaceIntroduceParameterPopup.startInplaceIntroduceTemplate()) {
                    return;
                }
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String parameterName = "anObject";
                boolean bl2 = true;
                boolean isDeleteLocalVariable = true;
                PsiExpression initializer = this.myLocalVar != null && this.myExpr == null ? this.myLocalVar.getInitializer() : this.myExpr;
                new IntroduceParameterProcessor(this.myProject, method, methodToSearchFor, initializer, this.myExpr, this.myLocalVar, isDeleteLocalVariable, parameterName, bl2, 0, mustBeFinal, false, null, this.getParamsToRemove(method, occurences)).run();
            } else {
                if (this.myEditor != null) {
                    RefactoringUtil.highlightAllOccurrences(this.myProject, (PsiElement[])occurences, this.myEditor);
                }
                ArrayList<UsageInfo> classMemberRefs = new ArrayList<UsageInfo>();
                if (this.myExpr != null) {
                    Util.analyzeExpression(this.myExpr, new ArrayList<UsageInfo>(), classMemberRefs, new ArrayList<UsageInfo>());
                }
                IntroduceParameterDialog introduceParameterDialog = new IntroduceParameterDialog(this.myProject, classMemberRefs, occurences, this.myLocalVar, this.myExpr, IntroduceParameterHandler.createNameSuggestionGenerator(this.myExpr, propName, this.myProject, enteredName), this.createTypeSelectorManager(occurences, initializerType), methodToSearchFor, method, this.getParamsToRemove(method, occurences), mustBeFinal);
                introduceParameterDialog.setReplaceAllOccurrences(replaceAllOccurrences);
                introduceParameterDialog.setGenerateDelegate(delegate);
                if (introduceParameterDialog.showAndGet()) {
                    Runnable cleanSelectionRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (Introducer.this.myEditor != null && !Introducer.this.myEditor.isDisposed()) {
                                Introducer.this.myEditor.getSelectionModel().removeSelection();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(cleanSelectionRunnable);
                }
            }
        }

        private TypeSelectorManagerImpl createTypeSelectorManager(PsiExpression[] occurences, PsiType initializerType) {
            return this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, initializerType, this.myExpr, occurences) : new TypeSelectorManagerImpl(this.myProject, initializerType, occurences);
        }

        private TIntArrayList getParamsToRemove(PsiMethod method, PsiExpression[] occurences) {
            PsiExpression expressionToRemoveParamFrom = this.myExpr;
            if (this.myExpr == null) {
                expressionToRemoveParamFrom = this.myLocalVar.getInitializer();
            }
            return expressionToRemoveParamFrom == null ? new TIntArrayList() : Util.findParametersToRemove(method, expressionToRemoveParamFrom, occurences);
        }
    }
}

