/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.InputValidator;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInSuperCallOccurrenceFilter;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntroduceVariableBase
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceVariable.IntroduceVariableBase");
    @NonNls
    private static final String PREFER_STATEMENTS_OPTION = "introduce.variable.prefer.statements";
    @NonNls
    private static final String REFACTORING_ID = "refactoring.extractVariable";
    protected static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.variable.title");
    public static final Key<Boolean> NEED_PARENTHESIS = Key.create((String)"NEED_PARENTHESIS");
    private JavaVariableInplaceIntroducer myInplaceIntroducer;

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type, @NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase", "getSuggestedName"));
        }
        return IntroduceVariableBase.getSuggestedName(type, expression, (PsiElement)expression);
    }

    public static SuggestedNameInfo getSuggestedName(@Nullable PsiType type, @NotNull PsiExpression expression, PsiElement anchor) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase", "getSuggestedName"));
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression.getProject());
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, expression, type);
        String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type, VariableKind.LOCAL_VARIABLE, nameInfo);
        SuggestedNameInfo.Delegate delegate = new SuggestedNameInfo.Delegate(strings, nameInfo);
        return codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)delegate, anchor, true);
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceVariable/IntroduceVariableBase", "invoke"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] statementsInRange = IntroduceVariableBase.findStatementsAtOffset(editor, file2, offset);
            if (statementsInRange.length == 1 && IntroduceVariableBase.selectLineAtCaret(offset, statementsInRange)) {
                selectionModel.selectLineAtCaret();
                PsiExpression expressionInRange = IntroduceVariableBase.findExpressionInRange(project2, file2, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
                if (expressionInRange == null || IntroduceVariableBase.getErrorMessage(expressionInRange) != null) {
                    selectionModel.removeSelection();
                }
            }
            if (!selectionModel.hasSelection()) {
                List<PsiExpression> expressions = IntroduceVariableBase.collectExpressions(file2, editor, offset);
                if (expressions.isEmpty()) {
                    selectionModel.selectLineAtCaret();
                } else if (!IntroduceVariableBase.isChooserNeeded(expressions)) {
                    TextRange textRange = expressions.get(0).getTextRange();
                    selectionModel.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                } else {
                    IntroduceTargetChooser.showChooser(editor, expressions, new Pass<PsiExpression>(){

                        public void pass(PsiExpression selectedValue) {
                            IntroduceVariableBase.this.invoke(project2, editor, file2, selectedValue.getTextRange().getStartOffset(), selectedValue.getTextRange().getEndOffset());
                        }
                    }, new PsiExpressionTrimRenderer.RenderFunction(), "Expressions", IntroduceVariableBase.preferredSelection(statementsInRange, expressions), ScopeHighlighter.NATURAL_RANGER);
                    return;
                }
            }
        }
        if (this.invoke(project2, editor, file2, selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()) && LookupManager.getActiveLookup(editor) == null) {
            selectionModel.removeSelection();
        }
    }

    public static boolean isChooserNeeded(List<PsiExpression> exprs) {
        if (exprs.size() == 1) {
            PsiExpression expression = exprs.get(0);
            return expression instanceof PsiNewExpression && ((PsiNewExpression)expression).getAnonymousClass() != null;
        }
        return true;
    }

    public static boolean selectLineAtCaret(int offset, PsiElement[] statementsInRange) {
        return !PsiUtil.isStatement((PsiElement)statementsInRange[0]) || statementsInRange[0].getTextRange().getStartOffset() > offset || statementsInRange[0].getTextRange().getEndOffset() < offset || IntroduceVariableBase.isPreferStatements();
    }

    public static int preferredSelection(PsiElement[] statementsInRange, List<PsiExpression> expressions) {
        PsiExpression expression;
        int selection = statementsInRange.length == 1 && statementsInRange[0] instanceof PsiExpressionStatement && PsiUtilCore.hasErrorElementChild((PsiElement)statementsInRange[0]) ? expressions.indexOf(((PsiExpressionStatement)statementsInRange[0]).getExpression()) : ((expression = expressions.get(0)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() instanceof PsiLocalVariable ? 1 : -1);
        return selection;
    }

    public static boolean isPreferStatements() {
        return Boolean.valueOf(PropertiesComponent.getInstance().getBoolean(PREFER_STATEMENTS_OPTION)) != false || Registry.is((String)PREFER_STATEMENTS_OPTION, (boolean)false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file2, Editor editor, int offset) {
        return IntroduceVariableBase.collectExpressions(file2, editor, offset, false);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file2, Editor editor, int offset, boolean acceptVoid) {
        return IntroduceVariableBase.collectExpressions(file2, editor.getDocument(), offset, acceptVoid);
    }

    public static List<PsiExpression> collectExpressions(PsiFile file2, Document document, int offset, boolean acceptVoid) {
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!Character.isJavaIdentifierPart(text.charAt(offset))) {
            --correctedOffset;
        }
        if (correctedOffset < 0) {
            correctedOffset = offset;
        } else if (!Character.isJavaIdentifierPart(text.charAt(correctedOffset))) {
            if (text.charAt(correctedOffset) == ';') {
                --correctedOffset;
            }
            if (correctedOffset < 0 || text.charAt(correctedOffset) != ')') {
                correctedOffset = offset;
            }
        }
        PsiElement elementAtCaret = file2.findElementAt(correctedOffset);
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtCaret, PsiExpression.class);
        while (expression != null) {
            if (!(expressions.contains(expression) || expression instanceof PsiParenthesizedExpression || expression instanceof PsiSuperExpression || !acceptVoid && PsiType.VOID.equals((Object)expression.getType()))) {
                if (expression instanceof PsiMethodReferenceExpression) {
                    expressions.add(expression);
                } else if (!(expression instanceof PsiAssignmentExpression)) {
                    PsiElement resolve;
                    if (!(expression instanceof PsiReferenceExpression)) {
                        expressions.add(expression);
                    } else if (!(expression.getParent() instanceof PsiMethodCallExpression || (resolve = ((PsiReferenceExpression)expression).resolve()) instanceof PsiClass || resolve instanceof PsiPackage)) {
                        expressions.add(expression);
                    }
                }
            }
            expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpression.class);
        }
        return expressions;
    }

    public static PsiElement[] findStatementsAtOffset(Editor editor, PsiFile file2, int offset) {
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        return CodeInsightUtil.findStatementsInRange(file2, lineStart, lineEnd);
    }

    private boolean invoke(Project project2, Editor editor, PsiFile file2, int startOffset, int endOffset) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable");
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return this.invokeImpl(project2, IntroduceVariableBase.findExpressionInRange(project2, file2, startOffset, endOffset), editor);
    }

    private static PsiExpression findExpressionInRange(Project project2, PsiFile file2, int startOffset, int endOffset) {
        PsiElement[] statements;
        PsiExpression tempExpr = CodeInsightUtil.findExpressionInRange(file2, startOffset, endOffset);
        if (tempExpr == null && (statements = CodeInsightUtil.findStatementsInRange(file2, startOffset, endOffset)).length == 1) {
            if (statements[0] instanceof PsiExpressionStatement) {
                tempExpr = ((PsiExpressionStatement)statements[0]).getExpression();
            } else if (statements[0] instanceof PsiReturnStatement) {
                tempExpr = ((PsiReturnStatement)statements[0]).getReturnValue();
            }
        }
        if (tempExpr == null) {
            tempExpr = IntroduceVariableBase.getSelectedExpression(project2, file2, startOffset, endOffset);
        }
        return tempExpr;
    }

    public static PsiExpression getSelectedExpression(Project project2, PsiFile file2, int startOffset, int endOffset) {
        PsiExpression tempExpr;
        PsiElement elementAtEnd;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
        PsiElement elementAtStart = file2.findElementAt(startOffset);
        if (elementAtStart == null || elementAtStart instanceof PsiWhiteSpace || elementAtStart instanceof PsiComment) {
            PsiElement element = PsiTreeUtil.skipSiblingsForward((PsiElement)elementAtStart, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            if (element != null) {
                startOffset = element.getTextOffset();
                elementAtStart = file2.findElementAt(startOffset);
            }
            if (elementAtStart == null) {
                if (injectedLanguageManager.isInjectedFragment(file2)) {
                    return IntroduceVariableBase.getSelectionFromInjectedHost(project2, file2, injectedLanguageManager, startOffset, endOffset);
                }
                return null;
            }
            startOffset = elementAtStart.getTextOffset();
        }
        if ((elementAtEnd = file2.findElementAt(endOffset - 1)) == null || elementAtEnd instanceof PsiWhiteSpace || elementAtEnd instanceof PsiComment) {
            if ((elementAtEnd = PsiTreeUtil.skipSiblingsBackward((PsiElement)elementAtEnd, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) == null) {
                return null;
            }
            endOffset = elementAtEnd.getTextRange().getEndOffset();
        }
        if (endOffset <= startOffset) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        PsiExpression containingExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiExpression.class, (boolean)false);
        if (containingExpression != null && containingExpression == elementAtEnd && startOffset == containingExpression.getTextOffset()) {
            return containingExpression;
        }
        if (containingExpression == null || containingExpression instanceof PsiLambdaExpression) {
            if (injectedLanguageManager.isInjectedFragment(file2)) {
                return IntroduceVariableBase.getSelectionFromInjectedHost(project2, file2, injectedLanguageManager, startOffset, endOffset);
            }
            elementAt = null;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PsiLiteralExpression.class);
        PsiLiteralExpression startLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiLiteralExpression.class);
        PsiLiteralExpression endLiteralExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(endOffset), PsiLiteralExpression.class);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String text = null;
        try {
            PsiType type;
            text = file2.getText().subSequence(startOffset, endOffset).toString();
            String prefix = null;
            String stripped = text;
            if (startLiteralExpression != null) {
                int startExpressionOffset = startLiteralExpression.getTextOffset();
                if (startOffset == startExpressionOffset) {
                    if (StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'')) {
                        stripped = text.substring(1);
                    }
                } else if (startOffset == startExpressionOffset + 1) {
                    text = "\"" + text;
                } else if (startOffset > startExpressionOffset + 1) {
                    prefix = "\" + ";
                    text = "\"" + text;
                }
            }
            String suffix = null;
            if (endLiteralExpression != null) {
                int endExpressionOffset = endLiteralExpression.getTextOffset() + endLiteralExpression.getTextLength();
                if (endOffset == endExpressionOffset) {
                    if (StringUtil.endsWithChar((CharSequence)stripped, (char)'\"') || StringUtil.endsWithChar((CharSequence)stripped, (char)'\'')) {
                        stripped = stripped.substring(0, stripped.length() - 1);
                    }
                } else if (endOffset == endExpressionOffset - 1) {
                    text = text + "\"";
                } else if (endOffset < endExpressionOffset - 1) {
                    suffix = " + \"";
                    text = text + "\"";
                }
            }
            boolean primitive = false;
            if (stripped.equals("true") || stripped.equals("false")) {
                primitive = true;
            } else {
                try {
                    Integer.parseInt(stripped);
                    primitive = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (primitive) {
                text = stripped;
            }
            if (literalExpression != null && text.equals(literalExpression.getText())) {
                return literalExpression;
            }
            PsiLiteralExpression parent = literalExpression != null ? literalExpression : elementAt;
            tempExpr = elementFactory.createExpressionFromText(text, (PsiElement)parent);
            final boolean[] hasErrors = new boolean[1];
            JavaRecursiveElementWalkingVisitor errorsVisitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    if (hasErrors[0]) {
                        return;
                    }
                    super.visitElement(element);
                }

                public void visitErrorElement(PsiErrorElement element) {
                    hasErrors[0] = true;
                }
            };
            tempExpr.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            tempExpr.putUserData(ElementToWorkOn.PREFIX, (Object)prefix);
            tempExpr.putUserData(ElementToWorkOn.SUFFIX, (Object)suffix);
            RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(file2.getVirtualFile()).createRangeMarker(startOffset, endOffset);
            tempExpr.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
            if (parent != null) {
                tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)parent);
            } else {
                PsiErrorElement errorElement;
                PsiErrorElement psiErrorElement = errorElement = elementAtStart instanceof PsiErrorElement ? (PsiErrorElement)elementAtStart : (PsiErrorElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                if (errorElement == null) {
                    errorElement = (PsiErrorElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtStart, PsiErrorElement.class);
                }
                if (errorElement == null) {
                    return null;
                }
                if (!(errorElement.getParent() instanceof PsiClass)) {
                    return null;
                }
                tempExpr.putUserData(ElementToWorkOn.PARENT, (Object)errorElement);
                tempExpr.putUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK, (Object)Boolean.TRUE);
            }
            String fakeInitializer = "intellijidearulezzz";
            int[] refIdx = new int[1];
            PsiElement toBeExpression = IntroduceVariableBase.createReplacement("intellijidearulezzz", project2, prefix, suffix, (PsiElement)parent, rangeMarker, refIdx);
            toBeExpression.accept((PsiElementVisitor)errorsVisitor);
            if (hasErrors[0]) {
                return null;
            }
            if (literalExpression != null && toBeExpression instanceof PsiExpression && (type = ((PsiExpression)toBeExpression).getType()) != null && !type.equals(literalExpression.getType())) {
                return null;
            }
            PsiReferenceExpression refExpr = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)toBeExpression.findElementAt(refIdx[0]), PsiReferenceExpression.class);
            if (refExpr == null) {
                return null;
            }
            if (toBeExpression == refExpr && refIdx[0] > 0) {
                return null;
            }
            if (ReplaceExpressionUtil.isNeedParenthesis(refExpr.getNode(), tempExpr.getNode())) {
                tempExpr.putCopyableUserData(NEED_PARENTHESIS, (Object)Boolean.TRUE);
                return tempExpr;
            }
        }
        catch (IncorrectOperationException e) {
            if (elementAt instanceof PsiExpressionList) {
                PsiElement parent = elementAt.getParent();
                return parent instanceof PsiCallExpression ? IntroduceVariableBase.createArrayCreationExpression(text, startOffset, endOffset, (PsiCallExpression)parent) : null;
            }
            return null;
        }
        return tempExpr;
    }

    private static PsiExpression getSelectionFromInjectedHost(Project project2, PsiFile file2, InjectedLanguageManager injectedLanguageManager, int startOffset, int endOffset) {
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost((PsiElement)file2);
        return IntroduceVariableBase.getSelectedExpression(project2, injectionHost.getContainingFile(), injectedLanguageManager.injectedToHost((PsiElement)file2, startOffset), injectedLanguageManager.injectedToHost((PsiElement)file2, endOffset));
    }

    @Nullable
    public static String getErrorMessage(PsiExpression expr) {
        Boolean needParenthesis = (Boolean)expr.getCopyableUserData(NEED_PARENTHESIS);
        if (needParenthesis != null && needParenthesis.booleanValue()) {
            return "Extracting selected expression would change the semantic of the whole expression.";
        }
        return null;
    }

    private static PsiExpression createArrayCreationExpression(String text, int startOffset, int endOffset, PsiCallExpression parent) {
        if (text == null || parent == null) {
            return null;
        }
        String[] varargsExpressions = text.split("s*,s*");
        if (varargsExpressions.length > 1) {
            PsiElement endElement;
            PsiElement startElement;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parent.getProject());
            JavaResolveResult resolveResult = parent.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)resolveResult.getElement();
            if (psiMethod == null || !psiMethod.isVarArgs()) {
                return null;
            }
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            PsiParameter varargParameter = parameters[parameters.length - 1];
            PsiType type = varargParameter.getType();
            LOG.assertTrue(type instanceof PsiEllipsisType);
            PsiArrayType psiType = (PsiArrayType)((PsiEllipsisType)type).toArrayType();
            PsiExpression[] args = parent.getArgumentList().getExpressions();
            PsiSubstitutor psiSubstitutor = resolveResult.getSubstitutor();
            if (args.length < parameters.length || startOffset < args[parameters.length - 1].getTextRange().getStartOffset()) {
                return null;
            }
            PsiFile containingFile = parent.getContainingFile();
            for (startElement = containingFile.findElementAt(startOffset); startElement != null && startElement.getParent() != parent.getArgumentList(); startElement = startElement.getParent()) {
            }
            if (startElement == null || startOffset > startElement.getTextOffset()) {
                return null;
            }
            for (endElement = containingFile.findElementAt(endOffset - 1); endElement != null && endElement.getParent() != parent.getArgumentList(); endElement = endElement.getParent()) {
            }
            if (endElement == null || endOffset < endElement.getTextRange().getEndOffset()) {
                return null;
            }
            PsiType componentType = TypeConversionUtil.erasure((PsiType)psiSubstitutor.substitute(psiType.getComponentType()));
            try {
                PsiExpression expressionFromText = elementFactory.createExpressionFromText("new " + componentType.getCanonicalText() + "[]{" + text + "}", (PsiElement)parent);
                RangeMarker rangeMarker = FileDocumentManager.getInstance().getDocument(containingFile.getVirtualFile()).createRangeMarker(startOffset, endOffset);
                expressionFromText.putUserData(ElementToWorkOn.TEXT_RANGE, (Object)rangeMarker);
                expressionFromText.putUserData(ElementToWorkOn.PARENT, (Object)parent);
                return expressionFromText;
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected boolean invokeImpl(final Project project2, final PsiExpression expr, final Editor editor) {
        boolean hasWriteAccess;
        boolean isInplaceAvailableOnDataContext;
        PsiType originalType;
        String errorMessage;
        if (expr != null && (errorMessage = IntroduceVariableBase.getErrorMessage(expr)) != null) {
            this.showErrorMessage(project2, editor, RefactoringBundle.getCannotRefactorMessage((String)errorMessage));
            return false;
        }
        if (expr != null && expr.getParent() instanceof PsiExpressionStatement) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.introduceVariable.incompleteStatement");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + expr);
        }
        if (expr == null || !expr.isPhysical()) {
            if (ReassignVariableUtil.reassign(editor)) {
                return false;
            }
            if (expr == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.an.expression"));
                this.showErrorMessage(project2, editor, message);
                return false;
            }
        }
        if ((originalType = RefactoringUtil.getTypeByExpressionWithExpectedType(expr)) == null || LambdaUtil.notInferredType((PsiType)originalType)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"unknown.expression.type"));
            this.showErrorMessage(project2, editor, message);
            return false;
        }
        if (PsiType.VOID.equals((Object)originalType)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            this.showErrorMessage(project2, editor, message);
            return false;
        }
        PsiElement physicalElement = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT);
        final PsiElement anchorStatement = RefactoringUtil.getParentStatement((PsiElement)(physicalElement != null ? physicalElement : expr), false);
        if (anchorStatement == null) {
            return this.parentStatementNotFound(project2, editor);
        }
        if (IntroduceVariableBase.checkAnchorBeforeThisOrSuper(project2, editor, anchorStatement, REFACTORING_NAME, "refactoring.introduceVariable")) {
            return false;
        }
        PsiElement tempContainer = anchorStatement.getParent();
        if (!(tempContainer instanceof PsiCodeBlock) && !RefactoringUtil.isLoopOrIf(tempContainer) && tempContainer.getParent() instanceof PsiLambdaExpression) {
            String message = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
            this.showErrorMessage(project2, editor, message);
            return false;
        }
        if (!NotInSuperCallOccurrenceFilter.INSTANCE.isOK(expr)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.introduce.variable.in.super.constructor.call"));
            this.showErrorMessage(project2, editor, message);
            return false;
        }
        PsiFile file2 = anchorStatement.getContainingFile();
        LOG.assertTrue(file2 != null, (Object)"expr.getContainingFile() == null");
        PsiElement nameSuggestionContext = editor == null ? null : file2.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(expr.getLanguage());
        boolean bl = isInplaceAvailableOnDataContext = supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.isInplaceIntroduceAvailable((PsiElement)expr, nameSuggestionContext) && (!ApplicationManager.getApplication().isUnitTestMode() || this.isInplaceAvailableInTestMode()) && !IntroduceVariableBase.isInJspHolderMethod(expr);
        if (isInplaceAvailableOnDataContext) {
            MultiMap conflicts = new MultiMap();
            IntroduceVariableBase.checkInLoopCondition(expr, (MultiMap<PsiElement, String>)conflicts);
            if (!conflicts.isEmpty()) {
                this.showErrorMessage(project2, editor, StringUtil.join((Iterable)conflicts.values(), (String)"<br>"));
                return false;
            }
        }
        ExpressionOccurrenceManager occurrenceManager = IntroduceVariableBase.createOccurrenceManager(expr, tempContainer);
        final PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        final PsiElement anchorStatementIfAll = occurrenceManager.getAnchorStatementForAll();
        final ArrayList<PsiExpression> nonWrite = new ArrayList<PsiExpression>();
        boolean cantReplaceAll = false;
        boolean cantReplaceAllButWrite = false;
        for (PsiExpression occurrence : occurrences) {
            if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) {
                nonWrite.add(occurrence);
                continue;
            }
            if (IntroduceVariableBase.isFinalVariableOnLHS(occurrence)) {
                cantReplaceAll = true;
                continue;
            }
            if (nonWrite.isEmpty()) continue;
            cantReplaceAllButWrite = true;
            cantReplaceAll = true;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)file2)) {
            return false;
        }
        LinkedHashMap occurrencesMap = ContainerUtil.newLinkedHashMap();
        occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO, Collections.singletonList(expr));
        boolean bl2 = hasWriteAccess = occurrences.length > nonWrite.size() && occurrences.length > 1;
        if (hasWriteAccess && !cantReplaceAllButWrite) {
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.NO_WRITE, nonWrite);
        }
        if (occurrences.length > 1 && !cantReplaceAll) {
            occurrencesMap.put(OccurrencesChooser.ReplaceChoice.ALL, Arrays.asList(occurrences));
        }
        final boolean inFinalContext = occurrenceManager.isInFinalContext();
        final InputValidator validator = new InputValidator(this, project2, anchorStatementIfAll, anchorStatement, occurrenceManager);
        final TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project2, originalType, expr, occurrences);
        final boolean[] wasSucceed = new boolean[]{true};
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(final OccurrencesChooser.ReplaceChoice choice) {
                if (choice != null) {
                    boolean replaceAll = choice == OccurrencesChooser.ReplaceChoice.ALL || choice == OccurrencesChooser.ReplaceChoice.NO_WRITE;
                    typeSelectorManager.setAllOccurrences(replaceAll);
                    PsiElement chosenAnchor = IntroduceVariableBase.chooseAnchor(replaceAll, choice == OccurrencesChooser.ReplaceChoice.NO_WRITE, nonWrite, anchorStatementIfAll, anchorStatement);
                    IntroduceVariableSettings settings = IntroduceVariableBase.this.getSettings(project2, editor, expr, occurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator, chosenAnchor, choice);
                    boolean cantChangeFinalModifier = (hasWriteAccess || inFinalContext) && choice == OccurrencesChooser.ReplaceChoice.ALL;
                    boolean noWrite = choice == OccurrencesChooser.ReplaceChoice.NO_WRITE;
                    ArrayList<PsiExpression> allOccurrences = new ArrayList<PsiExpression>();
                    for (PsiExpression occurrence : occurrences) {
                        if (expr.equals(occurrence) && expr.getParent() instanceof PsiExpressionStatement || choice != OccurrencesChooser.ReplaceChoice.ALL && (!noWrite || PsiUtil.isAccessedForWriting((PsiExpression)occurrence)) && !expr.equals(occurrence)) continue;
                        allOccurrences.add(occurrence);
                    }
                    IntroduceVariableBase.this.myInplaceIntroducer = new JavaVariableInplaceIntroducer(project2, settings, chosenAnchor, editor, expr, cantChangeFinalModifier, allOccurrences.toArray(new PsiExpression[allOccurrences.size()]), typeSelectorManager, REFACTORING_NAME);
                    if (IntroduceVariableBase.this.myInplaceIntroducer.startInplaceIntroduceTemplate()) {
                        return;
                    }
                }
                CommandProcessor.getInstance().executeCommand(project2, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IntroduceVariableSettings settings;
                        PsiVariable variable;
                        Editor topLevelEditor;
                        block3: {
                            topLevelEditor = !InjectedLanguageManager.getInstance((Project)project2).isInjectedFragment(anchorStatement.getContainingFile()) ? InjectedLanguageUtil.getTopLevelEditor(editor) : editor;
                            variable = null;
                            try {
                                settings = IntroduceVariableBase.this.getSettings(project2, topLevelEditor, expr, occurrences, typeSelectorManager, inFinalContext, hasWriteAccess, validator, anchorStatement, choice);
                                if (settings.isOK()) break block3;
                                wasSucceed[0] = false;
                            }
                            catch (Throwable throwable) {
                                RefactoringEventData afterData = new RefactoringEventData();
                                afterData.addElement(variable);
                                ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                                throw throwable;
                            }
                            RefactoringEventData afterData = new RefactoringEventData();
                            afterData.addElement(variable);
                            ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                            return;
                        }
                        RefactoringEventData beforeData = new RefactoringEventData();
                        beforeData.addElement((PsiElement)expr);
                        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(IntroduceVariableBase.REFACTORING_ID, beforeData);
                        PsiElement chosenAnchor = IntroduceVariableBase.chooseAnchor(settings.isReplaceAllOccurrences(), hasWriteAccess, nonWrite, anchorStatementIfAll, anchorStatement);
                        variable = (PsiVariable)ApplicationManager.getApplication().runWriteAction(IntroduceVariableBase.introduce(project2, expr, topLevelEditor, chosenAnchor, occurrences, settings));
                        RefactoringEventData afterData = new RefactoringEventData();
                        afterData.addElement((PsiElement)variable);
                        ((RefactoringEventListener)project2.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(IntroduceVariableBase.REFACTORING_ID, afterData);
                    }
                }, REFACTORING_NAME, null);
            }
        };
        if (!isInplaceAvailableOnDataContext) {
            callback.pass(null);
        } else {
            OccurrencesChooser.ReplaceChoice choice = this.getOccurrencesChoice();
            if (choice != null) {
                callback.pass((Object)choice);
            } else {
                OccurrencesChooser.simpleChooser(editor).showChooser(callback, occurrencesMap);
            }
        }
        return wasSucceed[0];
    }

    protected OccurrencesChooser.ReplaceChoice getOccurrencesChoice() {
        return null;
    }

    protected static PsiElement chooseAnchor(boolean allOccurences, boolean hasWriteAccess, List<PsiExpression> nonWrite, PsiElement anchorStatementIfAll, PsiElement anchorStatement) {
        if (allOccurences) {
            if (hasWriteAccess) {
                return RefactoringUtil.getAnchorElementForMultipleExpressions(nonWrite.toArray(new PsiExpression[nonWrite.size()]), null);
            }
            return anchorStatementIfAll;
        }
        return anchorStatement;
    }

    protected boolean isInplaceAvailableInTestMode() {
        return false;
    }

    private static ExpressionOccurrenceManager createOccurrenceManager(PsiExpression expr, PsiElement tempContainer) {
        boolean skipForStatement = true;
        final PsiForStatement forStatement = (PsiForStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiForStatement.class);
        if (forStatement != null) {
            VariablesProcessor variablesProcessor = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return PsiTreeUtil.isAncestor((PsiElement)forStatement.getInitialization(), (PsiElement)var, (boolean)true);
                }
            };
            PsiScopesUtil.treeWalkUp(variablesProcessor, (PsiElement)expr, null);
            skipForStatement = variablesProcessor.size() == 0;
        }
        PsiElement containerParent = tempContainer;
        PsiElement lastScope = tempContainer;
        while (!(containerParent instanceof PsiFile || containerParent instanceof PsiMethod || containerParent instanceof PsiLambdaExpression || !skipForStatement && containerParent instanceof PsiForStatement)) {
            if (!((containerParent = containerParent.getParent()) instanceof PsiCodeBlock)) continue;
            lastScope = containerParent;
        }
        return new ExpressionOccurrenceManager(expr, lastScope, NotInSuperCallOccurrenceFilter.INSTANCE);
    }

    private static boolean isInJspHolderMethod(PsiExpression expr) {
        PsiElement parent1 = expr.getParent();
        if (parent1 == null) {
            return false;
        }
        PsiElement parent2 = parent1.getParent();
        if (!(parent2 instanceof JspCodeBlock)) {
            return false;
        }
        PsiElement parent3 = parent2.getParent();
        return parent3 instanceof JspHolderMethod;
    }

    public static Computable<PsiVariable> introduce(final Project project2, final PsiExpression expr, final Editor editor, final PsiElement anchorStatement, final PsiExpression[] occurrences, final IntroduceVariableSettings settings) {
        int line;
        final PsiElement container = anchorStatement.getParent();
        PsiElement child = anchorStatement;
        final boolean isInsideLoop = RefactoringUtil.isLoopOrIf(container);
        if (!isInsideLoop) {
            child = IntroduceVariableBase.locateAnchor(child);
            if (IntroduceVariableBase.isFinalVariableOnLHS(expr)) {
                child = child.getNextSibling();
            }
        }
        final PsiElement anchor = child == null ? anchorStatement : child;
        boolean tempDeleteSelf = false;
        final boolean replaceSelf = settings.isReplaceLValues() || !RefactoringUtil.isAssignmentLHS((PsiElement)expr);
        final PsiElement exprParent = expr.getParent();
        if (!isInsideLoop) {
            PsiElement parent;
            if (exprParent instanceof PsiExpressionStatement && anchor.equals(anchorStatement) && ((parent = exprParent.getParent()) instanceof PsiCodeBlock || parent instanceof PsiCodeFragment)) {
                tempDeleteSelf = true;
            }
            tempDeleteSelf &= replaceSelf;
        }
        final boolean deleteSelf = tempDeleteSelf;
        final boolean replaceLoop = isInsideLoop ? exprParent instanceof PsiExpressionStatement : container instanceof PsiLambdaExpression && exprParent == container;
        final int col = editor != null ? editor.getCaretModel().getLogicalPosition().column : 0;
        int n = line = editor != null ? editor.getCaretModel().getLogicalPosition().line : 0;
        if (deleteSelf && editor != null) {
            LogicalPosition pos = new LogicalPosition(line, col);
            editor.getCaretModel().moveToLogicalPosition(pos);
        }
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)container, PsiCodeBlock.class, (boolean)false);
        final FieldConflictsResolver fieldConflictsResolver = new FieldConflictsResolver(settings.getEnteredName(), newDeclarationScope);
        return new Computable<PsiVariable>(){

            public PsiVariable compute() {
                try {
                    PsiStatement statement2 = null;
                    if (!isInsideLoop && deleteSelf) {
                        statement2 = (PsiStatement)exprParent;
                    }
                    PsiExpression expr1 = fieldConflictsResolver.fixInitializer(expr);
                    PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(expr1);
                    SmartTypePointer selectedType = SmartTypePointerManager.getInstance((Project)project2).createSmartTypePointer(settings.getSelectedType());
                    if (expr1 instanceof PsiNewExpression) {
                        PsiNewExpression newExpression = (PsiNewExpression)expr1;
                        if (newExpression.getArrayInitializer() != null) {
                            initializer = newExpression.getArrayInitializer();
                        }
                        initializer = IntroduceVariableBase.replaceExplicitWithDiamondWhenApplicable(initializer, selectedType.getType());
                    }
                    PsiDeclarationStatement declaration = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createVariableDeclarationStatement(settings.getEnteredName(), selectedType.getType(), initializer, container);
                    if (!isInsideLoop) {
                        declaration = this.addDeclaration(declaration, initializer);
                        LOG.assertTrue(expr1.isValid());
                        if (deleteSelf) {
                            PsiElement lastChild = statement2.getLastChild();
                            if (lastChild instanceof PsiComment) {
                                declaration.addBefore(lastChild, null);
                            }
                            statement2.delete();
                            if (editor != null) {
                                LogicalPosition pos = new LogicalPosition(line, col);
                                editor.getCaretModel().moveToLogicalPosition(pos);
                                editor.getCaretModel().moveToOffset(declaration.getTextRange().getEndOffset());
                                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                                editor.getSelectionModel().removeSelection();
                            }
                        }
                    }
                    PsiExpression ref = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(settings.getEnteredName(), null);
                    if (settings.isReplaceAllOccurrences()) {
                        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                        for (PsiExpression occurrence : occurrences) {
                            if (deleteSelf && occurrence.equals(expr)) continue;
                            if (occurrence.equals(expr)) {
                                occurrence = expr1;
                            }
                            if (occurrence != null) {
                                occurrence = RefactoringUtil.outermostParenthesizedExpression(occurrence);
                            }
                            if (!settings.isReplaceLValues() && RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
                            array.add(IntroduceVariableBase.replace(occurrence, ref, project2));
                        }
                        if (!deleteSelf && replaceSelf && expr1 instanceof PsiPolyadicExpression && expr1.isValid() && !expr1.isPhysical()) {
                            array.add(IntroduceVariableBase.replace(expr1, ref, project2));
                        }
                        if (editor != null) {
                            PsiElement[] replacedOccurences = PsiUtilCore.toPsiElementArray(array);
                            IntroduceVariableBase.highlightReplacedOccurences(project2, editor, replacedOccurences);
                        }
                    } else if (!deleteSelf && replaceSelf) {
                        IntroduceVariableBase.replace(expr1, ref, project2);
                    }
                    declaration = (PsiDeclarationStatement)RefactoringUtil.putStatementInLoopBody((PsiStatement)declaration, container, anchorStatement, replaceSelf && replaceLoop);
                    declaration = (PsiDeclarationStatement)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)declaration);
                    PsiVariable var = (PsiVariable)declaration.getDeclaredElements()[0];
                    PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)settings.isDeclareFinal());
                    fieldConflictsResolver.fix();
                    return var;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }

            private PsiDeclarationStatement addDeclaration(PsiDeclarationStatement declaration, PsiExpression initializer) {
                PsiElement[] declaredElements;
                if (anchor instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()).length > 1) {
                    final int[] usedFirstVar = new int[]{-1};
                    initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression) {
                            int i = ArrayUtilRt.find((Object[])declaredElements, (Object)expression.resolve());
                            if (i > -1) {
                                usedFirstVar[0] = Math.max(i, usedFirstVar[0]);
                            }
                            super.visitReferenceExpression(expression);
                        }
                    });
                    if (usedFirstVar[0] > -1) {
                        PsiVariable psiVariable = (PsiVariable)declaredElements[usedFirstVar[0]];
                        psiVariable.normalizeDeclaration();
                        PsiDeclarationStatement parDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                        return (PsiDeclarationStatement)container.addAfter((PsiElement)declaration, (PsiElement)parDeclarationStatement);
                    }
                }
                return (PsiDeclarationStatement)container.addBefore((PsiElement)declaration, anchor);
            }
        };
    }

    private static boolean isFinalVariableOnLHS(PsiExpression expr) {
        PsiElement resolve;
        return expr instanceof PsiReferenceExpression && RefactoringUtil.isAssignmentLHS((PsiElement)expr) && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiVariable && ((PsiVariable)resolve).hasModifierProperty("final");
    }

    public static PsiExpression replaceExplicitWithDiamondWhenApplicable(PsiExpression initializer, PsiType expectedType) {
        if (initializer instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            PsiExpression tryToDetectDiamondNewExpr = ((PsiVariable)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createVariableDeclarationStatement("x", expectedType, initializer, (PsiElement)initializer).getDeclaredElements()[0]).getInitializer();
            if (tryToDetectDiamondNewExpr instanceof PsiNewExpression && PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)tryToDetectDiamondNewExpr, (PsiNewExpression)tryToDetectDiamondNewExpr, expectedType)) {
                PsiElement paramList = PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)newExpression.getClassOrAnonymousClassReference().getParameterList());
                return (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)paramList, PsiNewExpression.class);
            }
        }
        return initializer;
    }

    public static PsiElement replace(PsiExpression expr1, PsiExpression ref, Project project2) throws IncorrectOperationException {
        Object expr2 = expr1 instanceof PsiArrayInitializerExpression && expr1.getParent() instanceof PsiNewExpression ? (PsiNewExpression)expr1.getParent() : RefactoringUtil.outermostParenthesizedExpression(expr1);
        if (expr2.isPhysical() || expr1.getUserData(ElementToWorkOn.REPLACE_NON_PHYSICAL) != null) {
            return expr2.replace((PsiElement)ref);
        }
        String prefix = (String)expr1.getUserData(ElementToWorkOn.PREFIX);
        String suffix = (String)expr1.getUserData(ElementToWorkOn.SUFFIX);
        PsiElement parent = (PsiElement)expr1.getUserData(ElementToWorkOn.PARENT);
        RangeMarker rangeMarker = (RangeMarker)expr1.getUserData(ElementToWorkOn.TEXT_RANGE);
        LOG.assertTrue(parent != null, (Object)expr1);
        return parent.replace(IntroduceVariableBase.createReplacement(ref.getText(), project2, prefix, suffix, parent, rangeMarker, new int[1]));
    }

    private static PsiElement createReplacement(String refText, Project project2, String prefix, String suffix, PsiElement parent, RangeMarker rangeMarker, int[] refIdx) {
        String text = refText;
        if (parent != null) {
            String allText = parent.getContainingFile().getText();
            TextRange parentRange = parent.getTextRange();
            LOG.assertTrue(parentRange.getStartOffset() <= rangeMarker.getStartOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String beg = allText.substring(parentRange.getStartOffset(), rangeMarker.getStartOffset());
            if (StringUtil.stripQuotesAroundValue((String)beg).trim().length() == 0 && prefix == null) {
                beg = "";
            }
            LOG.assertTrue(rangeMarker.getEndOffset() <= parentRange.getEndOffset(), (Object)(parent + "; prefix:" + prefix + "; suffix:" + suffix));
            String end = allText.substring(rangeMarker.getEndOffset(), parentRange.getEndOffset());
            if (StringUtil.stripQuotesAroundValue((String)end).trim().length() == 0 && suffix == null) {
                end = "";
            }
            String start = beg + (prefix != null ? prefix : "");
            refIdx[0] = start.length();
            text = start + refText + (suffix != null ? suffix : "") + end;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        return parent instanceof PsiStatement ? factory.createStatementFromText(text, parent) : (parent instanceof PsiCodeBlock ? factory.createCodeBlockFromText(text, parent) : factory.createExpressionFromText(text, parent));
    }

    private boolean parentStatementNotFound(Project project2, Editor editor) {
        String message = RefactoringBundle.message((String)"refactoring.is.not.supported.in.the.current.context", (Object[])new Object[]{REFACTORING_NAME});
        this.showErrorMessage(project2, editor, message);
        return false;
    }

    @Override
    protected boolean invokeImpl(Project project2, PsiLocalVariable localVariable, Editor editor) {
        throw new UnsupportedOperationException();
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (!(child == null || (prev = child.getPrevSibling()) instanceof PsiStatement || prev instanceof PsiJavaToken && ((PsiJavaToken)prev).getTokenType() == JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    protected static void highlightReplacedOccurences(Project project2, Editor editor, PsiElement[] replacedOccurences) {
        if (editor == null) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, replacedOccurences, attributes, true, null);
        WindowManager.getInstance().getStatusBar(project2).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    protected abstract void showErrorMessage(Project var1, Editor var2, String var3);

    protected boolean reportConflicts(MultiMap<PsiElement, String> conflicts, Project project2, IntroduceVariableSettings settings) {
        return false;
    }

    public IntroduceVariableSettings getSettings(Project project2, Editor editor, PsiExpression expr, PsiExpression[] occurrences, final TypeSelectorManagerImpl typeSelectorManager, boolean declareFinalIfAll, boolean anyAssignmentLHS, InputValidator validator, PsiElement anchor, OccurrencesChooser.ReplaceChoice replaceChoice) {
        final boolean replaceAll = replaceChoice == OccurrencesChooser.ReplaceChoice.ALL || replaceChoice == OccurrencesChooser.ReplaceChoice.NO_WRITE;
        SuggestedNameInfo suggestedName = IntroduceVariableBase.getSuggestedName(typeSelectorManager.getDefaultType(), expr, anchor);
        final String variableName = suggestedName.names.length > 0 ? suggestedName.names[0] : "";
        final boolean declareFinal = replaceAll && declareFinalIfAll || !anyAssignmentLHS && IntroduceVariableBase.createFinals(project2);
        final boolean replaceWrite = anyAssignmentLHS && replaceChoice == OccurrencesChooser.ReplaceChoice.ALL;
        return new IntroduceVariableSettings(){

            @Override
            public String getEnteredName() {
                return variableName;
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return replaceAll;
            }

            @Override
            public boolean isDeclareFinal() {
                return declareFinal;
            }

            @Override
            public boolean isReplaceLValues() {
                return replaceWrite;
            }

            @Override
            public PsiType getSelectedType() {
                PsiType selectedType = typeSelectorManager.getTypeSelector().getSelectedType();
                return selectedType != null ? selectedType : typeSelectorManager.getDefaultType();
            }

            @Override
            public boolean isOK() {
                return true;
            }
        };
    }

    public static boolean createFinals(Project project2) {
        Boolean createFinals = JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS;
        return createFinals == null ? CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_LOCALS : createFinals;
    }

    public static boolean checkAnchorBeforeThisOrSuper(Project project2, Editor editor, PsiElement tempAnchorElement, String refactoringName, String helpID) {
        PsiMethod method;
        PsiExpression enclosingExpr;
        if (tempAnchorElement instanceof PsiExpressionStatement && (enclosingExpr = ((PsiExpressionStatement)tempAnchorElement).getExpression()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)enclosingExpr).resolveMethod()) != null && method.isConstructor()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invalid.expression.context"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)refactoringName, (String)helpID);
            return true;
        }
        return false;
    }

    public static void checkInLoopCondition(PsiExpression occurence, MultiMap<PsiElement, String> conflicts) {
        PsiElement loopForLoopCondition = RefactoringUtil.getLoopForLoopCondition(occurence);
        if (loopForLoopCondition == null) {
            return;
        }
        List<PsiVariable> referencedVariables = RefactoringUtil.collectReferencedVariables((PsiElement)occurence);
        ArrayList<PsiVariable> modifiedInBody = new ArrayList<PsiVariable>();
        for (PsiVariable psiVariable : referencedVariables) {
            if (!RefactoringUtil.isModifiedInScope(psiVariable, loopForLoopCondition)) continue;
            modifiedInBody.add(psiVariable);
        }
        if (!modifiedInBody.isEmpty()) {
            for (PsiVariable variable : modifiedInBody) {
                String message = RefactoringBundle.message((String)"is.modified.in.loop.body", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)variable, false)});
                conflicts.putValue((Object)variable, (Object)CommonRefactoringUtil.capitalize((String)message));
            }
            conflicts.putValue((Object)occurence, (Object)RefactoringBundle.message((String)"introducing.variable.may.break.code.logic"));
        }
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroducer;
    }

    public static interface Validator {
        public boolean isOK(IntroduceVariableSettings var1);
    }
}

