/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceParameterAssignmentWithCall
extends FixableUsageInfo {
    private final PsiReferenceExpression expression;
    private final String newParameterName;
    private final String setterName;
    private final String getterName;

    public ReplaceParameterAssignmentWithCall(PsiReferenceExpression element, String newParameterName, String setterName, String getterName) {
        super((PsiElement)element);
        this.setterName = setterName;
        this.getterName = getterName;
        this.newParameterName = newParameterName;
        this.expression = element;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        String newExpression;
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiAssignmentExpression.class);
        assert (assignment != null);
        PsiExpression rhs = assignment.getRExpression();
        if (rhs == null) {
            return;
        }
        String rhsText = rhs.getText();
        String operator = assignment.getOperationSign().getText();
        if ("=".equals(operator)) {
            newExpression = this.newParameterName + '.' + this.setterName + '(' + rhsText + ')';
        } else {
            String strippedOperator = operator.substring(0, operator.length() - 1);
            newExpression = this.newParameterName + '.' + this.setterName + '(' + this.newParameterName + '.' + this.getterName + "()" + strippedOperator + rhsText + ')';
        }
        MutationUtils.replaceExpression(newExpression, (PsiExpression)assignment);
    }
}

