/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.refactoring.migration.MigrationMapEntry;
import java.util.ArrayList;

public class MigrationMap {
    private String myName;
    private String myDescription;
    private final ArrayList<MigrationMapEntry> myEntries = new ArrayList();

    public MigrationMap() {
    }

    public MigrationMap(MigrationMapEntry[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            MigrationMapEntry entry = entries[i];
            this.addEntry(entry);
        }
    }

    public MigrationMap cloneMap() {
        MigrationMap newMap = new MigrationMap();
        newMap.myName = this.myName;
        newMap.myDescription = this.myDescription;
        for (int i = 0; i < this.myEntries.size(); ++i) {
            MigrationMapEntry entry = this.getEntryAt(i);
            newMap.addEntry(entry.cloneEntry());
        }
        return newMap;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public void addEntry(MigrationMapEntry entry) {
        this.myEntries.add(entry);
    }

    public void removeEntryAt(int index) {
        this.myEntries.remove(index);
    }

    public void removeAllEntries() {
        this.myEntries.clear();
    }

    public int getEntryCount() {
        return this.myEntries.size();
    }

    public MigrationMapEntry getEntryAt(int index) {
        return this.myEntries.get(index);
    }

    public void setEntryAt(MigrationMapEntry entry, int index) {
        this.myEntries.set(index, entry);
    }

    public String toString() {
        return this.getName();
    }
}

