/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.openapi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.ConvertToInstanceMethodRefactoring;
import com.intellij.refactoring.IntroduceParameterRefactoring;
import com.intellij.refactoring.JavaRefactoringFactory;
import com.intellij.refactoring.JavaRenameRefactoring;
import com.intellij.refactoring.MakeStaticRefactoring;
import com.intellij.refactoring.MoveClassesOrPackagesRefactoring;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.MoveInnerRefactoring;
import com.intellij.refactoring.MoveMembersRefactoring;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RenameRefactoring;
import com.intellij.refactoring.ReplaceConstructorWithFactoryRefactoring;
import com.intellij.refactoring.SafeDeleteRefactoring;
import com.intellij.refactoring.TurnRefsToSuperRefactoring;
import com.intellij.refactoring.TypeCookRefactoring;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingSingleSourceRootMoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.move.moveInner.MoveInnerImpl;
import com.intellij.refactoring.openapi.impl.ConvertToInstanceMethodRefactoringImpl;
import com.intellij.refactoring.openapi.impl.IntroduceParameterRefactoringImpl;
import com.intellij.refactoring.openapi.impl.JavaRenameRefactoringImpl;
import com.intellij.refactoring.openapi.impl.MakeClassStaticRefactoringImpl;
import com.intellij.refactoring.openapi.impl.MakeMethodStaticRefactoringImpl;
import com.intellij.refactoring.openapi.impl.MoveClassesOrPackagesRefactoringImpl;
import com.intellij.refactoring.openapi.impl.MoveInnerRefactoringImpl;
import com.intellij.refactoring.openapi.impl.MoveMembersRefactoringImpl;
import com.intellij.refactoring.openapi.impl.ReplaceConstructorWithFactoryRefactoringImpl;
import com.intellij.refactoring.openapi.impl.SafeDeleteRefactoringImpl;
import com.intellij.refactoring.openapi.impl.TurnRefsToSuperRefactoringImpl;
import com.intellij.refactoring.openapi.impl.TypeCookRefactoringImpl;
import org.jetbrains.annotations.NotNull;

public class JavaRefactoringFactoryImpl
extends JavaRefactoringFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.openapi.impl.JavaRefactoringFactoryImpl");
    private final Project myProject;

    public JavaRefactoringFactoryImpl(Project project2) {
        this.myProject = project2;
    }

    public JavaRenameRefactoring createRename(PsiElement element, String newName) {
        return new JavaRenameRefactoringImpl(this.myProject, element, newName, true, true);
    }

    public RenameRefactoring createRename(PsiElement element, String newName, boolean searchInComments, boolean searchInNonJavaFiles) {
        return new JavaRenameRefactoringImpl(this.myProject, element, newName, searchInComments, searchInNonJavaFiles);
    }

    public MoveInnerRefactoring createMoveInner(PsiClass innerClass, String newName, boolean passOuterClass, String parameterName) {
        PsiElement targetContainer = MoveInnerImpl.getTargetContainer(innerClass, false);
        if (targetContainer == null) {
            return null;
        }
        return new MoveInnerRefactoringImpl(this.myProject, innerClass, newName, passOuterClass, parameterName, targetContainer);
    }

    public MoveDestination createSourceFolderPreservingMoveDestination(@NotNull String targetPackage) {
        if (targetPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPackage", "com/intellij/refactoring/openapi/impl/JavaRefactoringFactoryImpl", "createSourceFolderPreservingMoveDestination"));
        }
        return new MultipleRootsMoveDestination(this.createPackageWrapper(targetPackage));
    }

    private PackageWrapper createPackageWrapper(@NotNull String targetPackage) {
        if (targetPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPackage", "com/intellij/refactoring/openapi/impl/JavaRefactoringFactoryImpl", "createPackageWrapper"));
        }
        return new PackageWrapper(PsiManager.getInstance((Project)this.myProject), targetPackage);
    }

    public MoveDestination createSourceRootMoveDestination(@NotNull String targetPackageQualifiedName, @NotNull VirtualFile sourceRoot) {
        if (targetPackageQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPackageQualifiedName", "com/intellij/refactoring/openapi/impl/JavaRefactoringFactoryImpl", "createSourceRootMoveDestination"));
        }
        if (sourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/intellij/refactoring/openapi/impl/JavaRefactoringFactoryImpl", "createSourceRootMoveDestination"));
        }
        PsiDirectory directory = PsiManager.getInstance((Project)this.myProject).findDirectory(sourceRoot);
        LOG.assertTrue(directory != null && JavaDirectoryService.getInstance().isSourceRoot(directory), (Object)"Should pass source root");
        return new AutocreatingSingleSourceRootMoveDestination(this.createPackageWrapper(targetPackageQualifiedName), sourceRoot);
    }

    public MoveClassesOrPackagesRefactoring createMoveClassesOrPackages(PsiElement[] elements, MoveDestination moveDestination) {
        return new MoveClassesOrPackagesRefactoringImpl(this.myProject, elements, moveDestination);
    }

    public MoveMembersRefactoring createMoveMembers(PsiMember[] elements, String targetClassQualifiedName, String newVisibility) {
        return this.createMoveMembers(elements, targetClassQualifiedName, newVisibility, false);
    }

    public MoveMembersRefactoring createMoveMembers(PsiMember[] elements, String targetClassQualifiedName, String newVisibility, boolean makeEnumConstants) {
        return new MoveMembersRefactoringImpl(this.myProject, elements, targetClassQualifiedName, newVisibility, makeEnumConstants);
    }

    public MakeStaticRefactoring<PsiMethod> createMakeMethodStatic(PsiMethod method, boolean replaceUsages, String classParameterName, PsiField[] fields, String[] names) {
        return new MakeMethodStaticRefactoringImpl(this.myProject, method, replaceUsages, classParameterName, fields, names);
    }

    public MakeStaticRefactoring<PsiClass> createMakeClassStatic(PsiClass aClass, boolean replaceUsages, String classParameterName, PsiField[] fields, String[] names) {
        return new MakeClassStaticRefactoringImpl(this.myProject, aClass, replaceUsages, classParameterName, fields, names);
    }

    public ConvertToInstanceMethodRefactoring createConvertToInstanceMethod(PsiMethod method, PsiParameter targetParameter) {
        return new ConvertToInstanceMethodRefactoringImpl(this.myProject, method, targetParameter);
    }

    public SafeDeleteRefactoring createSafeDelete(PsiElement[] elements) {
        return new SafeDeleteRefactoringImpl(this.myProject, elements);
    }

    public TurnRefsToSuperRefactoring createTurnRefsToSuper(PsiClass aClass, PsiClass aSuper, boolean replaceInstanceOf) {
        return new TurnRefsToSuperRefactoringImpl(this.myProject, aClass, aSuper, replaceInstanceOf);
    }

    public ReplaceConstructorWithFactoryRefactoring createReplaceConstructorWithFactory(PsiMethod method, PsiClass targetClass, String factoryName) {
        return new ReplaceConstructorWithFactoryRefactoringImpl(this.myProject, method, targetClass, factoryName);
    }

    public ReplaceConstructorWithFactoryRefactoring createReplaceConstructorWithFactory(PsiClass originalClass, PsiClass targetClass, String factoryName) {
        return new ReplaceConstructorWithFactoryRefactoringImpl(this.myProject, originalClass, targetClass, factoryName);
    }

    public TypeCookRefactoring createTypeCook(PsiElement[] elements, boolean dropObsoleteCasts, boolean leaveObjectsRaw, boolean preserveRawArrays, boolean exhaustive, boolean cookObjects, boolean cookToWildcards) {
        return new TypeCookRefactoringImpl(this.myProject, elements, dropObsoleteCasts, leaveObjectsRaw, preserveRawArrays, exhaustive, cookObjects, cookToWildcards);
    }

    public IntroduceParameterRefactoring createIntroduceParameterRefactoring(PsiMethod methodToReplaceIn, PsiMethod methodToSearchFor, String parameterName, PsiExpression parameterInitializer, PsiLocalVariable localVariable, boolean removeLocalVariable, boolean declareFinal) {
        return new IntroduceParameterRefactoringImpl(this.myProject, methodToReplaceIn, methodToSearchFor, parameterName, parameterInitializer, localVariable, removeLocalVariable, declareFinal);
    }

    public IntroduceParameterRefactoring createIntroduceParameterRefactoring(PsiMethod methodToReplaceIn, PsiMethod methodToSearchFor, String parameterName, PsiExpression parameterInitializer, PsiExpression expressionToSearchFor, boolean declareFinal, boolean replaceAllOccurences) {
        return new IntroduceParameterRefactoringImpl(this.myProject, methodToReplaceIn, methodToSearchFor, parameterName, parameterInitializer, expressionToSearchFor, declareFinal, replaceAllOccurences);
    }
}

