/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import java.util.HashSet;

public abstract class ClassThisReferencesVisitor
extends ClassMemberReferencesVisitor {
    HashSet<PsiClass> myClassSuperClasses = new HashSet();

    public ClassThisReferencesVisitor(PsiClass aClass) {
        super(aClass);
        this.myClassSuperClasses.add(aClass);
    }

    public void visitThisExpression(PsiThisExpression expression) {
        PsiJavaCodeReferenceElement ref = expression.getQualifier();
        if (ref != null) {
            PsiElement element = ref.resolve();
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (this.myClassSuperClasses.contains(aClass)) {
                    this.visitExplicitThis(aClass, expression);
                }
                if (aClass.isInheritor(this.getPsiClass(), true)) {
                    this.myClassSuperClasses.add(aClass);
                    this.visitExplicitThis(aClass, expression);
                }
            }
            ref.accept((PsiElementVisitor)this);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (containingClass != null && this.getPsiClass().getManager().areElementsEquivalent((PsiElement)this.getPsiClass(), (PsiElement)containingClass)) {
                this.visitExplicitThis(this.getPsiClass(), expression);
            }
        }
    }

    public void visitSuperExpression(PsiSuperExpression expression) {
        PsiJavaCodeReferenceElement ref = expression.getQualifier();
        if (ref != null) {
            PsiElement element = ref.resolve();
            if (element instanceof PsiClass) {
                PsiClass aClass = (PsiClass)element;
                if (this.myClassSuperClasses.contains(aClass)) {
                    this.visitExplicitSuper(aClass.getSuperClass(), expression);
                }
                if (aClass.isInheritor(this.getPsiClass(), true)) {
                    this.myClassSuperClasses.add(aClass);
                    this.visitExplicitSuper(aClass.getSuperClass(), expression);
                }
            }
            ref.accept((PsiElementVisitor)this);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
            if (containingClass != null && this.getPsiClass().getManager().areElementsEquivalent((PsiElement)this.getPsiClass(), (PsiElement)containingClass)) {
                this.visitExplicitSuper(this.getPsiClass().getSuperClass(), expression);
            }
        }
    }

    protected abstract void visitExplicitThis(PsiClass var1, PsiThisExpression var2);

    protected abstract void visitExplicitSuper(PsiClass var1, PsiSuperExpression var2);
}

