/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.duplicates;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class GotoReturnValue
implements ReturnValue {
    @Override
    @Nullable
    public PsiStatement createReplacement(PsiMethod extractedMethod, PsiMethodCallExpression methodCallExpression) throws IncorrectOperationException {
        if (!TypeConversionUtil.isBooleanType((PsiType)extractedMethod.getReturnType())) {
            return null;
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)methodCallExpression.getProject()).getElementFactory();
        PsiIfStatement statement2 = (PsiIfStatement)elementFactory.createStatementFromText(this.getGotoStatement(), null);
        PsiExpression condition = statement2.getCondition();
        assert (condition != null);
        condition.replace((PsiElement)methodCallExpression);
        return (PsiStatement)CodeStyleManager.getInstance((Project)statement2.getManager().getProject()).reformat((PsiElement)statement2);
    }

    @NonNls
    public abstract String getGotoStatement();
}

