/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.util.CloudAgent;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CloudServerRuntimeInstance<DC extends DeploymentConfiguration, A extends CloudAgent, SC extends CloudAgentConfigBase>
extends ServerRuntimeInstance<DC> {
    private final A myAgent;
    private final SC myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;
    private final AgentTaskExecutor myAgentTaskExecutor;

    public CloudServerRuntimeInstance(SC configuration, ServerTaskExecutor tasksExecutor, List<File> libraries, List<Class<?>> commonJarClasses, String specificsModuleName, String specificJarPath, Class<A> agentInterface, String agentClassName) throws Exception {
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
        RemoteAgentManager agentManager = RemoteAgentManager.getInstance();
        this.myAgent = (CloudAgent)agentManager.createAgent(agentManager.createReflectiveThreadProxyFactory(((Object)((Object)this)).getClass().getClassLoader()), libraries, commonJarClasses, specificsModuleName, specificJarPath, agentInterface, agentClassName, ((Object)((Object)this)).getClass());
        this.myAgentTaskExecutor = new AgentTaskExecutor();
    }

    public SC getConfiguration() {
        return this.myConfiguration;
    }

    public ServerTaskExecutor getTaskExecutor() {
        return this.myTasksExecutor;
    }

    public A getAgent() {
        return this.myAgent;
    }

    protected final AgentTaskExecutor getAgentTaskExecutor() {
        return this.myAgentTaskExecutor;
    }

    public void computeDeployments(final @NotNull ServerRuntimeInstance.ComputeDeploymentsCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/remoteServer/util/CloudServerRuntimeInstance", "computeDeployments"));
        }
        this.getTaskExecutor().submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                try {
                    for (CloudApplicationRuntime application : CloudServerRuntimeInstance.this.getApplications()) {
                        Deployment deployment = callback.addDeployment(application.getApplicationName(), (DeploymentRuntime)application, application.getStatus(), application.getStatusText());
                        application.setDeploymentModel(deployment);
                    }
                    callback.succeeded();
                }
                catch (ServerRuntimeException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }
        }, (RemoteOperationCallback)callback);
    }

    protected List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        return this.getAgentTaskExecutor().execute(new Computable<List<CloudApplicationRuntime>>(){

            public List<CloudApplicationRuntime> compute() {
                Object[] applications = CloudServerRuntimeInstance.this.getAgent().getApplications();
                if (applications == null) {
                    return Collections.emptyList();
                }
                return ContainerUtil.map((Object[])applications, (Function)new Function<CloudRemoteApplication, CloudApplicationRuntime>(){

                    public CloudApplicationRuntime fun(CloudRemoteApplication application) {
                        return CloudServerRuntimeInstance.this.createApplicationRuntime(application);
                    }
                });
            }
        });
    }

    protected abstract CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication var1);
}

