/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.HashSet;
import java.util.List;

public class SubstitutionHandler
extends MatchingHandler {
    private final String name;
    private final int maxOccurs;
    private final int minOccurs;
    private final boolean greedy;
    private boolean target;
    private MatchPredicate predicate;
    private MatchingHandler matchHandler;
    private boolean subtype;
    private boolean strictSubtype;
    private int matchedOccurs;
    private int totalMatchedOccurs = -1;
    private MatchResultImpl myNestedResult;
    private static final NodeFilter VARS_DELIM_FILTER = new NodeFilter(){

        @Override
        public boolean accepts(PsiElement element) {
            if (element == null) {
                return false;
            }
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile == null) {
                return false;
            }
            return profile.canBeVarDelimeter(element);
        }
    };

    public SubstitutionHandler(String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        this.name = name;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.target = target;
        this.greedy = greedy;
    }

    public SubstitutionHandler(SubstitutionHandler substitutionHandler) {
        this(substitutionHandler.getName(), substitutionHandler.isTarget(), substitutionHandler.getMinOccurs(), substitutionHandler.getMaxOccurs(), substitutionHandler.greedy);
    }

    public boolean isSubtype() {
        return this.subtype;
    }

    public boolean isStrictSubtype() {
        return this.strictSubtype;
    }

    public void setStrictSubtype(boolean strictSubtype) {
        this.strictSubtype = strictSubtype;
    }

    public void setSubtype(boolean subtype) {
        this.subtype = subtype;
    }

    public void setPredicate(MatchPredicate handler2) {
        this.predicate = handler2;
    }

    public MatchPredicate getPredicate() {
        return this.predicate;
    }

    private static boolean validateOneMatch(PsiElement match, int start, int end, MatchResultImpl result, MatchContext matchContext) {
        boolean matchresult = match != null ? (start == 0 && end == -1 && result.getStart() == 0 && result.getEnd() == -1 ? matchContext.getMatcher().match(match, result.getMatch()) : StructuralSearchUtil.getProfileByPsiElement(match).getText(match, start, end).equals(result.getMatchImage())) : result.isMatchImageNull();
        return matchresult;
    }

    public boolean validate(PsiElement match, int start, int end, MatchContext context) {
        if (this.predicate != null && !this.predicate.match(null, match, start, end, context)) {
            return false;
        }
        if (this.maxOccurs == 0) {
            ++this.totalMatchedOccurs;
            return false;
        }
        MatchResultImpl result = context.getResult().findSon(this.name);
        if (result == null && context.getPreviousResult() != null) {
            result = context.getPreviousResult().findSon(this.name);
        }
        if (result != null) {
            if (this.minOccurs == 1 && this.maxOccurs == 1) {
                return SubstitutionHandler.validateOneMatch(match, start, end, result, context);
            }
            if (this.maxOccurs > 1 && this.totalMatchedOccurs != -1) {
                int size = result.getAllSons().size();
                if (this.matchedOccurs >= size) {
                    return false;
                }
                result = size == 0 ? result : (MatchResultImpl)result.getAllSons().get(this.matchedOccurs);
                return SubstitutionHandler.validateOneMatch(match, start, end, result, context);
            }
        }
        return true;
    }

    @Override
    public boolean match(PsiElement node, PsiElement match, MatchContext context) {
        if (!super.match(node, match, context)) {
            return false;
        }
        return this.matchHandler == null ? context.getMatcher().match(node, match) : this.matchHandler.match(node, match, context);
    }

    public boolean handle(PsiElement match, MatchContext context) {
        return this.handle(match, 0, -1, context);
    }

    public void addResult(PsiElement match, int start, int end, MatchContext context) {
        if (this.totalMatchedOccurs == -1) {
            MatchResultImpl matchResult = context.getResult();
            MatchResultImpl substitution = matchResult.findSon(this.name);
            if (substitution == null) {
                matchResult.addSon(this.createMatch(match, start, end));
            } else if (this.maxOccurs > 1) {
                MatchResultImpl result = this.createMatch(match, start, end);
                if (!substitution.isMultipleMatch()) {
                    MatchResultImpl sonresult = new MatchResultImpl(substitution.getName(), substitution.getMatchImage(), substitution.getMatchRef(), substitution.getStart(), substitution.getEnd(), this.target);
                    substitution.setMatchRef(new SmartPsiPointer(match == null ? null : match));
                    substitution.setMultipleMatch(true);
                    if (substitution.isScopeMatch()) {
                        substitution.setScopeMatch(false);
                        sonresult.setScopeMatch(true);
                        for (MatchResult r : substitution.getAllSons()) {
                            sonresult.addSon((MatchResultImpl)r);
                        }
                        substitution.clearMatches();
                    }
                    substitution.addSon(sonresult);
                }
                substitution.addSon(result);
            }
        }
    }

    public boolean handle(PsiElement match, int start, int end, MatchContext context) {
        if (!this.validate(match, start, end, context)) {
            this.myNestedResult = null;
            return false;
        }
        if (!"__context__".equals(this.name)) {
            this.addResult(match, start, end, context);
        }
        return true;
    }

    private MatchResultImpl createMatch(PsiElement match, int start, int end) {
        MatchResultImpl result;
        String image = match == null ? null : StructuralSearchUtil.getProfileByPsiElement(match).getText(match, start, end);
        SmartPsiPointer ref = new SmartPsiPointer(match);
        MatchResultImpl matchResultImpl = result = this.myNestedResult == null ? new MatchResultImpl(this.name, image, ref, start, end, this.target) : this.myNestedResult;
        if (this.myNestedResult != null) {
            this.myNestedResult.setName(this.name);
            this.myNestedResult.setMatchImage(image);
            this.myNestedResult.setMatchRef(ref);
            this.myNestedResult.setStart(start);
            this.myNestedResult.setEnd(end);
            this.myNestedResult.setTarget(this.target);
            this.myNestedResult = null;
        }
        return result;
    }

    boolean validate(MatchContext context, Class elementContext) {
        MatchResultImpl substitution = context.getResult().findSon(this.name);
        if (this.minOccurs >= 1 && (substitution == null || StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType()).getElementContextByPsi(((MatchResult)substitution).getMatch()) != elementContext)) {
            return false;
        }
        if (this.maxOccurs <= 1 && substitution != null && ((MatchResult)substitution).hasSons()) {
            return false;
        }
        return this.maxOccurs != 0 || this.totalMatchedOccurs == -1;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    private void removeLastResults(int numberOfResults, MatchContext context) {
        if (numberOfResults == 0) {
            return;
        }
        MatchResultImpl substitution = context.getResult().findSon(this.name);
        if (substitution != null) {
            List<PsiElement> matchedNodes = context.getMatchedNodes();
            if (substitution.hasSons()) {
                List<MatchResult> sons = substitution.getMatches();
                while (numberOfResults > 0) {
                    --numberOfResults;
                    MatchResult matchResult = sons.remove(sons.size() - 1);
                    if (matchedNodes == null) continue;
                    matchedNodes.remove(matchResult.getMatch());
                }
                if (sons.isEmpty()) {
                    context.getResult().removeSon(this.name);
                }
            } else {
                MatchResultImpl matchResult = context.getResult().removeSon(this.name);
                if (matchedNodes != null) {
                    matchedNodes.remove(matchResult.getMatch());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchInAnyOrder(NodeIterator patternNodes, NodeIterator matchedNodes, MatchContext context) {
        MatchResultImpl saveResult = context.hasResult() ? context.getResult() : null;
        context.setResult(null);
        try {
            if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
                boolean bl = SubstitutionHandler.validateSatisfactionOfHandlers(patternNodes, context);
                return bl;
            }
            HashSet<PsiElement> matchedElements = null;
            while (patternNodes.hasNext()) {
                int matchedOccurs = 0;
                PsiElement patternNode = patternNodes.current();
                CompiledPattern pattern = context.getPattern();
                MatchingHandler handler2 = pattern.getHandler(patternNode);
                PsiElement startMatching = matchedNodes.current();
                while (true) {
                    boolean result;
                    PsiElement element;
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (element = handler2.getPinnedNode(null)) != null ? element : matchedNodes.current();
                    if (element == null) {
                        matchedNodes.advance();
                    }
                    if (!matchedNodes.hasNext()) {
                        matchedNodes.reset();
                    }
                    if (!(matchedOccurs > this.maxOccurs || matchedElements != null && matchedElements.contains(matchedNode))) {
                        if (handler2.match(patternNode, matchedNode, context)) {
                            ++matchedOccurs;
                            if (matchedElements == null) {
                                matchedElements = new HashSet<PsiElement>();
                            }
                            matchedElements.add(matchedNode);
                            if (handler2.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                                break;
                            }
                        } else if (element != null) {
                            boolean bl = false;
                            return bl;
                        }
                        clearingVisitor.clearState(pattern, patternNode);
                    }
                    if (startMatching != matchedNodes.current()) continue;
                    boolean bl = result = SubstitutionHandler.validateSatisfactionOfHandlers(patternNodes, context) && matchedOccurs >= this.minOccurs && matchedOccurs <= this.maxOccurs;
                    if (result && context.getMatchedElementsListener() != null) {
                        context.getMatchedElementsListener().matchedElements(matchedElements);
                    }
                    boolean bl2 = result;
                    return bl2;
                }
                if (!handler2.shouldAdvanceThePatternFor(patternNode, null)) {
                    patternNodes.rewind();
                }
                patternNodes.advance();
            }
            boolean result = SubstitutionHandler.validateSatisfactionOfHandlers(patternNodes, context);
            if (result && context.getMatchedElementsListener() != null) {
                context.getMatchedElementsListener().matchedElements(matchedElements);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (saveResult != null) {
                if (context.hasResult()) {
                    saveResult.getMatches().addAll(context.getResult().getMatches());
                }
                context.setResult(saveResult);
            }
        }
    }

    @Override
    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        return this.doMatchSequentially(nodes, nodes2, context);
    }

    protected boolean doMatchSequentiallyBySimpleHandler(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        boolean oldValue = context.shouldRecursivelyMatch();
        context.setShouldRecursivelyMatch(false);
        boolean result = super.matchSequentially(nodes, nodes2, context);
        context.setShouldRecursivelyMatch(oldValue);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doMatchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        int previousMatchedOccurs = this.matchedOccurs;
        FilteringNodeIterator fNodes2 = new FilteringNodeIterator(nodes2, VARS_DELIM_FILTER);
        try {
            MatchingHandler handler2 = context.getPattern().getHandler(nodes.current());
            this.matchedOccurs = 0;
            boolean flag = false;
            while (fNodes2.hasNext() && this.matchedOccurs < this.minOccurs && handler2.match(nodes.current(), nodes2.current(), context)) {
                ++this.matchedOccurs;
                fNodes2.advance();
                flag = true;
            }
            if (this.matchedOccurs != this.minOccurs) {
                this.removeLastResults(this.matchedOccurs, context);
                fNodes2.rewind(this.matchedOccurs);
                boolean bl = false;
                return bl;
            }
            if (this.greedy) {
                while (fNodes2.hasNext() && this.matchedOccurs < this.maxOccurs && handler2.match(nodes.current(), nodes2.current(), context)) {
                    ++this.matchedOccurs;
                    fNodes2.advance();
                    flag = true;
                }
                if (flag) {
                    fNodes2.rewind();
                    nodes2.advance();
                }
                nodes.advance();
                if (nodes.hasNext()) {
                    MatchingHandler nextHandler = context.getPattern().getHandler(nodes.current());
                    while (this.matchedOccurs >= this.minOccurs) {
                        if (nextHandler.matchSequentially(nodes, nodes2, context)) {
                            this.totalMatchedOccurs = this.matchedOccurs;
                            boolean bl = true;
                            return bl;
                        }
                        if (this.matchedOccurs > 0) {
                            nodes2.rewind();
                            this.removeLastResults(1, context);
                        }
                        --this.matchedOccurs;
                    }
                    if (this.matchedOccurs > 0) {
                        this.removeLastResults(this.matchedOccurs, context);
                    }
                    nodes.rewind();
                    boolean bl = false;
                    return bl;
                }
                if (handler2.isMatchSequentiallySucceeded(nodes2)) {
                    boolean nextHandler = this.checkSameOccurrencesConstraint();
                    return nextHandler;
                }
                this.removeLastResults(this.matchedOccurs, context);
                boolean nextHandler = false;
                return nextHandler;
            }
            nodes.advance();
            if (flag) {
                fNodes2.rewind();
                nodes2.advance();
            }
            if (nodes.hasNext()) {
                MatchingHandler nextHandler = context.getPattern().getHandler(nodes.current());
                flag = false;
                while (nodes2.hasNext() && this.matchedOccurs <= this.maxOccurs) {
                    if (nextHandler.matchSequentially(nodes, nodes2, context)) {
                        boolean bl = this.checkSameOccurrencesConstraint();
                        return bl;
                    }
                    if (flag) {
                        nodes2.rewind();
                        fNodes2.advance();
                    }
                    if (handler2.match(nodes.current(), nodes2.current(), context)) {
                        ++this.matchedOccurs;
                    } else {
                        nodes.rewind();
                        this.removeLastResults(this.matchedOccurs, context);
                        boolean bl = false;
                        return bl;
                    }
                    nodes2.advance();
                    flag = true;
                }
                nodes.rewind();
                this.removeLastResults(this.matchedOccurs, context);
                boolean bl = false;
                return bl;
            }
            boolean bl = this.checkSameOccurrencesConstraint();
            return bl;
        }
        finally {
            this.matchedOccurs = previousMatchedOccurs;
        }
    }

    private boolean checkSameOccurrencesConstraint() {
        if (this.totalMatchedOccurs == -1) {
            this.totalMatchedOccurs = this.matchedOccurs;
            return true;
        }
        return this.totalMatchedOccurs == this.matchedOccurs;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public void setMatchHandler(MatchingHandler matchHandler) {
        this.matchHandler = matchHandler;
    }

    public boolean isTarget() {
        return this.target;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void reset() {
        super.reset();
        this.totalMatchedOccurs = -1;
    }

    @Override
    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        if (this.maxOccurs > 1) {
            return false;
        }
        return super.shouldAdvanceThePatternFor(patternElement, matchedElement);
    }

    public void setNestedResult(MatchResultImpl nestedResult) {
        this.myNestedResult = nestedResult;
    }

    public MatchResultImpl getNestedResult() {
        return this.myNestedResult;
    }
}

