/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.EditorListenerTracker;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformTestCase
extends UsefulTestCase
implements DataProvider {
    private static IdeaTestApplication ourApplication;
    private static boolean ourReportedLeakedProjects;
    protected ProjectManagerEx myProjectManager;
    protected Project myProject;
    protected Module myModule;
    protected static final Collection<File> myFilesToDelete;
    protected boolean myAssertionsInTestDetected;
    protected static final Logger LOG;
    public static Thread ourTestThread;
    private static TestCase ourTestCase;
    private static final long DEFAULT_TEST_TIME = 300L;
    public static long ourTestTime;
    private EditorListenerTracker myEditorListenerTracker;
    private ThreadTracker myThreadTracker;
    private static boolean ourPlatformPrefixInitialized;
    private static Set<VirtualFile> ourEternallyLivingFilesCache;
    private static final String[] PREFIX_CANDIDATES;

    public static void synchronizeTempDirVfs(@NotNull VirtualFile tempDir) {
        if (tempDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tempDir", "com/intellij/testFramework/PlatformTestCase", "synchronizeTempDirVfs"));
        }
        tempDir.getChildren();
        tempDir.refresh(false, true);
    }

    protected void initApplication() throws Exception {
        boolean firstTime = ourApplication == null;
        ourApplication = IdeaTestApplication.getInstance(null);
        ourApplication.setDataProvider(this);
        if (firstTime) {
            PlatformTestCase.cleanPersistedVFSContent();
        }
    }

    public static void autodetectPlatformPrefix() {
        PlatformTestCase.doAutodetectPlatformPrefix();
    }

    public static void doAutodetectPlatformPrefix() {
        if (ourPlatformPrefixInitialized) {
            return;
        }
        URL resource = PlatformTestCase.class.getClassLoader().getResource("idea/ApplicationInfo.xml");
        if (resource == null) {
            for (String candidate : PREFIX_CANDIDATES) {
                resource = PlatformTestCase.class.getClassLoader().getResource("META-INF/" + candidate + "Plugin.xml");
                if (resource == null) continue;
                PlatformTestCase.setPlatformPrefix(candidate);
                break;
            }
        }
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        if (CodeStyleSchemes.getInstance().getCurrentScheme() == null) {
            return new CodeStyleSettings();
        }
        return CodeStyleSettingsManager.getSettings((Project)this.getProject());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File tempDir = new File(FileUtilRt.getTempDirectory());
        myFilesToDelete.add(tempDir);
        if (ourTestCase != null) {
            String message = "Previous test " + ourTestCase + " hasn't called tearDown(). Probably overridden without super call.";
            ourTestCase = null;
            PlatformTestCase.fail((String)message);
        }
        IdeaLogger.ourErrorsOccurred = null;
        LOG.info(((Object)((Object)this)).getClass().getName() + ".setUp()");
        this.initApplication();
        this.myEditorListenerTracker = new EditorListenerTracker();
        this.myThreadTracker = new ThreadTracker();
        this.setUpProject();
        this.storeSettings();
        ourTestCase = this;
        if (this.myProject != null) {
            ProjectManagerEx.getInstanceEx().openTestProject(this.myProject);
            CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(new CodeStyleSettings());
            InjectedLanguageManagerImpl.pushInjectors(this.getProject());
        }
        DocumentCommitThread.getInstance().clearQueue();
        UIUtil.dispatchAllInvocationEvents();
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final PsiManager getPsiManager() {
        return PsiManager.getInstance((Project)this.myProject);
    }

    public Module getModule() {
        return this.myModule;
    }

    protected void setUpProject() throws Exception {
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        PlatformTestCase.assertNotNull((String)"Cannot instantiate ProjectManager component", (Object)((Object)this.myProjectManager));
        File projectFile = this.getIprFile();
        this.myProject = this.doCreateProject(projectFile);
        this.myProjectManager.openTestProject(this.myProject);
        LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
        this.setUpModule();
        this.setUpJdk();
        LightPlatformTestCase.clearUncommittedDocuments(this.getProject());
        this.runStartupActivities();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected Project doCreateProject(@NotNull File projectFile) throws Exception {
        if (projectFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectFile", "com/intellij/testFramework/PlatformTestCase", "doCreateProject"));
        }
        return PlatformTestCase.createProject(projectFile, ((Object)((Object)this)).getClass().getName() + "." + this.getName());
    }

    @NotNull
    public static Project createProject(File projectFile, String creationPlace) {
        Project project2 = PlatformTestCase.createProject(projectFile.getPath(), creationPlace);
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
        }
        return project2;
    }

    @NotNull
    public static Project createProject(@NotNull String path, String creationPlace) {
        Project project2;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/PlatformTestCase", "createProject"));
        }
        String fileName = PathUtilRt.getFileName((String)path);
        try {
            String projectName = FileUtilRt.getNameWithoutExtension((String)fileName);
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(projectName, path, false, false);
            assert (project3 != null);
            project3.putUserData(CREATION_PLACE, (Object)creationPlace);
            project2 = project3;
        }
        catch (TooManyProjectLeakedException e) {
            if (ourReportedLeakedProjects) {
                PlatformTestCase.fail((String)"Too many projects leaked, again.");
                if (null == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
                }
                return null;
            }
            ourReportedLeakedProjects = true;
            StringBuilder leakers = new StringBuilder();
            leakers.append("Too many projects leaked: \n");
            for (Project project4 : e.getLeakedProjects()) {
                String presentableString = PlatformTestCase.getCreationPlace(project4);
                leakers.append(presentableString);
                leakers.append("\n");
            }
            String dumpPath = PathManager.getHomePath() + "/leakedProjects.hprof.zip";
            System.out.println("##teamcity[publishArtifacts 'leakedProjects.hprof.zip']");
            try {
                FileUtil.delete((File)new File(dumpPath));
                MemoryDumpHelper.captureMemoryDumpZipped((String)dumpPath);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            PlatformTestCase.fail((String)(leakers + "\nPlease see '" + dumpPath + "' for a memory dump"));
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
            }
            return null;
        }
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createProject"));
        }
        return project2;
    }

    @NotNull
    public static String getCreationPlace(@NotNull Project project2) {
        String base;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/testFramework/PlatformTestCase", "getCreationPlace"));
        }
        String place = (String)project2.getUserData(CREATION_PLACE);
        try {
            base = project2.isDisposed() ? "" : project2.getBaseDir();
        }
        catch (Exception e) {
            base = " (" + e + " while getting base dir)";
        }
        String string = project2 + (place != null ? place : "") + base;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "getCreationPlace"));
        }
        return string;
    }

    protected void runStartupActivities() {
        StartupManagerImpl startupManager = (StartupManagerImpl)StartupManager.getInstance((Project)this.myProject);
        startupManager.runStartupActivities();
        startupManager.startCacheUpdate();
        startupManager.runPostStartupActivities();
    }

    protected File getIprFile() throws IOException {
        File tempFile2 = FileUtil.createTempFile((String)this.getName(), (String)".ipr");
        myFilesToDelete.add(tempFile2);
        return tempFile2;
    }

    protected void setUpModule() {
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                PlatformTestCase.this.myModule = PlatformTestCase.this.createMainModule();
            }
        }.execute().throwException();
    }

    protected Module createMainModule() throws IOException {
        return this.createModule(this.myProject.getName());
    }

    protected Module createModule(@NonNls String moduleName) {
        return this.doCreateRealModule(moduleName);
    }

    protected Module doCreateRealModule(String moduleName) {
        return PlatformTestCase.doCreateRealModuleIn(moduleName, this.myProject, this.getModuleType());
    }

    protected static Module doCreateRealModuleIn(String moduleName, final Project project2, final ModuleType moduleType) {
        VirtualFile baseDir = project2.getBaseDir();
        PlatformTestCase.assertNotNull((Object)baseDir);
        final File moduleFile = new File(FileUtil.toSystemDependentName((String)baseDir.getPath()), moduleName + ".iml");
        FileUtil.createIfDoesntExist((File)moduleFile);
        myFilesToDelete.add(moduleFile);
        return (Module)new WriteAction<Module>(){

            protected void run(@NotNull Result<Module> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$2", "run"));
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleFile);
                TestCase.assertNotNull((Object)virtualFile);
                Module module2 = ModuleManager.getInstance((Project)project2).newModule(virtualFile.getPath(), moduleType.getId());
                module2.getModuleFile();
                result.setResult((Object)module2);
            }
        }.execute().getResultObject();
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    public static void cleanupApplicationCaches(Project project2) {
        ProjectManagerImpl projectManager;
        if (project2 != null && !project2.isDisposed()) {
            UndoManagerImpl globalInstance = (UndoManagerImpl)UndoManager.getGlobalInstance();
            if (globalInstance != null) {
                globalInstance.dropHistoryInTests();
            }
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }
        if ((projectManager = (ProjectManagerImpl)ProjectManager.getInstance()).isDefaultProjectInitialized()) {
            Project defaultProject = projectManager.getDefaultProject();
            ((PsiManagerImpl)PsiManager.getInstance((Project)defaultProject)).cleanupForNextTest();
        }
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).cleanupForNextTest();
        LocalFileSystemImpl localFileSystem = (LocalFileSystemImpl)LocalFileSystem.getInstance();
        if (localFileSystem != null) {
            localFileSystem.cleanupForNextTest();
        }
    }

    private static Set<VirtualFile> eternallyLivingFiles() {
        if (ourEternallyLivingFilesCache != null) {
            return ourEternallyLivingFilesCache;
        }
        HashSet<VirtualFile> survivors = new HashSet<VirtualFile>();
        for (IndexableSetContributor contributor : (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file2 : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                PlatformTestCase.registerSurvivor(survivors, file2);
            }
        }
        ourEternallyLivingFilesCache = survivors;
        return survivors;
    }

    public static void addSurvivingFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/testFramework/PlatformTestCase", "addSurvivingFiles"));
        }
        for (VirtualFile each : files) {
            PlatformTestCase.registerSurvivor(PlatformTestCase.eternallyLivingFiles(), each);
        }
    }

    private static void registerSurvivor(Set<VirtualFile> survivors, VirtualFile file2) {
        PlatformTestCase.addSubTree(file2, survivors);
        while (file2 != null && survivors.add(file2)) {
            file2 = file2.getParent();
        }
    }

    private static void addSubTree(VirtualFile root, Set<VirtualFile> to) {
        if (root instanceof VirtualDirectoryImpl) {
            for (VirtualFile child : ((VirtualDirectoryImpl)root).getCachedChildren()) {
                if (!(child instanceof VirtualDirectoryImpl)) continue;
                to.add(child);
                PlatformTestCase.addSubTree(child, to);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        SmartList exceptions = new SmartList();
        Project project2 = this.myProject;
        if (project2 != null) {
            try {
                LightPlatformTestCase.doTearDown(project2, ourApplication, false, (List<Throwable>)exceptions);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            this.disposeProject((List<Throwable>)exceptions);
        }
        try {
            this.checkForSettingsDamage((List<Throwable>)exceptions);
        }
        catch (Throwable e) {
            exceptions.add(e);
        }
        try {
            if (project2 != null) {
                try {
                    InjectedLanguageManagerImpl.checkInjectorsAreDisposed(project2);
                }
                catch (AssertionError e) {
                    exceptions.add(e);
                }
            }
            try {
                for (File fileToDelete : myFilesToDelete) {
                    this.delete(fileToDelete);
                }
                LocalFileSystem.getInstance().refreshIoFiles(myFilesToDelete);
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            if (!this.myAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
                exceptions.add(IdeaLogger.ourErrorsOccurred);
            }
            try {
                super.tearDown();
            }
            catch (Throwable e) {
                exceptions.add(e);
            }
            try {
                if (this.myEditorListenerTracker != null) {
                    this.myEditorListenerTracker.checkListenersLeak();
                }
            }
            catch (AssertionError error) {
                exceptions.add(error);
            }
            try {
                if (this.myThreadTracker != null) {
                    this.myThreadTracker.checkLeak();
                }
            }
            catch (AssertionError error) {
                exceptions.add(error);
            }
            try {
                LightPlatformTestCase.checkEditorsReleased((List<Throwable>)exceptions);
            }
            catch (Throwable error) {
                exceptions.add(error);
            }
        }
        finally {
            this.myProjectManager = null;
            this.myProject = null;
            this.myModule = null;
            myFilesToDelete.clear();
            this.myEditorListenerTracker = null;
            this.myThreadTracker = null;
            ourTestCase = null;
            CompoundRuntimeException.throwIfNotEmpty((List)exceptions);
        }
    }

    private void disposeProject(@NotNull List<Throwable> exceptions) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/testFramework/PlatformTestCase", "disposeProject"));
        }
        try {
            DocumentCommitThread.getInstance().clearQueue();
            if (SwingUtilities.isEventDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
        catch (Throwable e) {
            exceptions.add(e);
        }
        Project project2 = this.myProject;
        if (project2 == null) {
            return;
        }
        PlatformTestCase.closeAndDisposeProjectAndCheckThatNoOpenProjects(project2, exceptions);
        this.myProject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndDisposeProjectAndCheckThatNoOpenProjects(@NotNull Project projectToClose, @NotNull List<Throwable> exceptions) {
        block9: {
            if (projectToClose == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectToClose", "com/intellij/testFramework/PlatformTestCase", "closeAndDisposeProjectAndCheckThatNoOpenProjects"));
            }
            if (exceptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/testFramework/PlatformTestCase", "closeAndDisposeProjectAndCheckThatNoOpenProjects"));
            }
            try {
                ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
                if (!(projectManager instanceof ProjectManagerImpl)) break block9;
                for (Project project2 : projectManager.closeTestProject(projectToClose)) {
                    exceptions.add(new IllegalStateException("Test project is not disposed: " + project2 + ";\n created in: " + PlatformTestCase.getCreationPlace(project2)));
                    try {
                        ((ProjectManagerImpl)projectManager).closeProject(project2, false, true, false);
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                }
            }
            catch (Throwable e) {
                try {
                    exceptions.add(e);
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(projectToClose, exceptions){
                        final /* synthetic */ Project val$projectToClose;
                        final /* synthetic */ List val$exceptions;
                        {
                            this.val$projectToClose = project2;
                            this.val$exceptions = list;
                        }

                        @Override
                        public void run() {
                            try {
                                Disposer.dispose((Disposable)this.val$projectToClose);
                            }
                            catch (Throwable e) {
                                this.val$exceptions.add(e);
                            }
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().runWriteAction(new /* invalid duplicate definition of identical inner class */);
            }
        }
        ApplicationManager.getApplication().runWriteAction(new /* invalid duplicate definition of identical inner class */);
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    @Override
    protected final <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.myProject, disposable);
        return disposable;
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            PlatformTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        if (aClass == PlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private String getFullName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }

    private void delete(File file2) {
        boolean b = FileUtil.delete((File)file2);
        if (!b && file2.exists() && !this.myAssertionsInTestDetected) {
            PlatformTestCase.fail((String)("Can't delete " + file2.getAbsolutePath() + " in " + this.getFullName()));
        }
    }

    protected void setUpJdk() {
        Module[] modules;
        Sdk jdk = this.getTestProjectJdk();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootModificationUtil.setModuleSdk((Module)module2, (Sdk)jdk);
        }
    }

    @Nullable
    protected Sdk getTestProjectJdk() {
        return null;
    }

    @Override
    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        try {
            this.runBareImpl();
        }
        catch (Throwable throwable) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PlatformTestCase.cleanupApplicationCaches(PlatformTestCase.this.getProject());
                        PlatformTestCase.this.resetAllFields();
                    }
                });
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable throwable) {}
    }

    private void runBareImpl() throws Throwable {
        ThrowableRunnable<Throwable> runnable2 = new ThrowableRunnable<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws Throwable {
                ourTestThread = Thread.currentThread();
                ourTestTime = 300L;
                try {
                    try {
                        PlatformTestCase.this.myAssertionsInTestDetected = true;
                        PlatformTestCase.this.setUp();
                        PlatformTestCase.this.myAssertionsInTestDetected = false;
                    }
                    catch (Throwable e) {
                        try {
                            PlatformTestCase.this.tearDown();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        throw e;
                    }
                    Throwable exception = null;
                    try {
                        PlatformTestCase.this.myAssertionsInTestDetected = true;
                        PlatformTestCase.this.runTest();
                        PlatformTestCase.this.myAssertionsInTestDetected = false;
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    finally {
                        block20: {
                            try {
                                PlatformTestCase.this.tearDown();
                            }
                            catch (Throwable e) {
                                if (exception != null) break block20;
                                exception = e;
                            }
                        }
                    }
                    if (exception != null) {
                        throw exception;
                    }
                }
                finally {
                    ourTestThread = null;
                }
            }
        };
        this.runBareRunnable(runnable2);
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        PlatformTestCase.waitForAllLaters();
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private static void waitForAllLaters() throws InterruptedException, InvocationTargetException {
        for (int i = 0; i < 3; ++i) {
            SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        }
    }

    protected boolean isRunInEdt() {
        return true;
    }

    protected void runBareRunnable(ThrowableRunnable<Throwable> runnable2) throws Throwable {
        if (this.isRunInEdt()) {
            EdtTestUtil.runInEdtAndWait(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    @Override
    protected void invokeTestRunnable(final @NotNull Runnable runnable2) throws Exception {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/testFramework/PlatformTestCase", "invokeTestRunnable"));
        }
        final Exception[] e = new Exception[1];
        Runnable runnable1 = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ApplicationManager.getApplication().isDispatchThread() && PlatformTestCase.this.isRunInWriteAction()) {
                        ApplicationManager.getApplication().runWriteAction(runnable2);
                    } else {
                        runnable2.run();
                    }
                }
                catch (Exception e1) {
                    e[0] = e1;
                }
            }
        };
        if (this.annotatedWith(WrapInCommand.class)) {
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable1, "", null);
        } else {
            runnable1.run();
        }
        if (e[0] != null) {
            throw e[0];
        }
    }

    public Object getData(String dataId) {
        return this.myProject == null ? null : new TestDataProvider(this.myProject).getData(dataId);
    }

    public static File createTempDir(@NonNls String prefix) throws IOException {
        return PlatformTestCase.createTempDir(prefix, true);
    }

    public static File createTempDir(@NonNls String prefix, boolean refresh) throws IOException {
        File tempDirectory = FileUtilRt.createTempDirectory((String)("idea_test_" + prefix), null, (boolean)false);
        myFilesToDelete.add(tempDirectory);
        if (refresh) {
            PlatformTestCase.getVirtualFile(tempDirectory);
        }
        return tempDirectory;
    }

    protected static VirtualFile getVirtualFile(@NotNull File file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "getVirtualFile"));
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    protected File createTempDirectory() throws IOException {
        return PlatformTestCase.createTempDir(this.getTestName(true));
    }

    protected File createTempDirectory(boolean refresh) throws IOException {
        return PlatformTestCase.createTempDir(this.getTestName(true), refresh);
    }

    @NotNull
    protected File createTempFile(@NotNull String name, @Nullable String text) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/PlatformTestCase", "createTempFile"));
        }
        File directory = this.createTempDirectory();
        File file2 = new File(directory, name);
        if (!file2.createNewFile()) {
            throw new IOException("Can't create " + file2);
        }
        if (text != null) {
            FileUtil.writeToFile((File)file2, (String)text);
        }
        File file3 = file2;
        if (file3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/PlatformTestCase", "createTempFile"));
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContentOnDisk(@NotNull File file2, byte[] bom, @NotNull String content, @NotNull Charset charset) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "setContentOnDisk"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/PlatformTestCase", "setContentOnDisk"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/testFramework/PlatformTestCase", "setContentOnDisk"));
        }
        FileOutputStream stream = new FileOutputStream(file2);
        if (bom != null) {
            stream.write(bom);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);){
            writer.write(content);
        }
    }

    public static VirtualFile createTempFile(@NonNls @NotNull String ext, @Nullable byte[] bom, @NonNls @NotNull String content, @NotNull Charset charset) throws IOException {
        if (ext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/testFramework/PlatformTestCase", "createTempFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/PlatformTestCase", "createTempFile"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/testFramework/PlatformTestCase", "createTempFile"));
        }
        File temp = FileUtil.createTempFile((String)"copy", (String)("." + ext));
        PlatformTestCase.setContentOnDisk(temp, bom, content, charset);
        myFilesToDelete.add(temp);
        VirtualFile file2 = PlatformTestCase.getVirtualFile(temp);
        assert (file2 != null) : temp;
        return file2;
    }

    @Nullable
    protected PsiFile getPsiFile(Document document) {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(document);
    }

    public static void initPlatformLangPrefix() {
    }

    public static void initPlatformPrefix(String classToTest, String prefix) {
        if (!ourPlatformPrefixInitialized) {
            ourPlatformPrefixInitialized = true;
            boolean isUltimate = true;
            try {
                PlatformTestCase.class.getClassLoader().loadClass(classToTest);
            }
            catch (ClassNotFoundException e) {
                isUltimate = false;
            }
            if (!isUltimate) {
                PlatformTestCase.setPlatformPrefix(prefix);
            }
        }
    }

    private static void setPlatformPrefix(String prefix) {
        System.setProperty("idea.platform.prefix", prefix);
        ourPlatformPrefixInitialized = true;
    }

    protected static VirtualFile createChildData(final @NotNull VirtualFile dir, final @NotNull @NonNls String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/testFramework/PlatformTestCase", "createChildData"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/PlatformTestCase", "createChildData"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$7", "run"));
                }
                result.setResult((Object)dir.createChildData(null, name));
            }
        }.execute().throwException().getResultObject();
    }

    protected static VirtualFile createChildDirectory(final @NotNull VirtualFile dir, final @NotNull @NonNls String name) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/testFramework/PlatformTestCase", "createChildDirectory"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/PlatformTestCase", "createChildDirectory"));
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$8", "run"));
                }
                result.setResult((Object)dir.createChildDirectory(null, name));
            }
        }.execute().throwException().getResultObject();
    }

    protected static void rename(final @NotNull VirtualFile vFile1, final @NotNull String newName) {
        if (vFile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile1", "com/intellij/testFramework/PlatformTestCase", "rename"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/testFramework/PlatformTestCase", "rename"));
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                vFile1.rename((Object)this, newName);
            }
        }.execute().throwException();
    }

    protected static void delete(@NotNull VirtualFile vFile1) {
        if (vFile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile1", "com/intellij/testFramework/PlatformTestCase", "delete"));
        }
        VfsTestUtil.deleteFile(vFile1);
    }

    protected static void move(final @NotNull VirtualFile vFile1, final @NotNull VirtualFile newFile) {
        if (vFile1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile1", "com/intellij/testFramework/PlatformTestCase", "move"));
        }
        if (newFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFile", "com/intellij/testFramework/PlatformTestCase", "move"));
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                vFile1.move((Object)this, newFile);
            }
        }.execute().throwException();
    }

    protected static VirtualFile copy(final @NotNull VirtualFile file2, final @NotNull VirtualFile newParent, final @NotNull String copyName) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "copy"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/intellij/testFramework/PlatformTestCase", "copy"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/intellij/testFramework/PlatformTestCase", "copy"));
        }
        final VirtualFile[] copy = new VirtualFile[1];
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                copy[0] = file2.copy((Object)this, newParent, copyName);
            }
        }.execute().throwException();
        return copy[0];
    }

    public static void copyDirContentsTo(final @NotNull VirtualFile vTestRoot, final @NotNull VirtualFile toDir) {
        if (vTestRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vTestRoot", "com/intellij/testFramework/PlatformTestCase", "copyDirContentsTo"));
        }
        if (toDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDir", "com/intellij/testFramework/PlatformTestCase", "copyDirContentsTo"));
        }
        new WriteCommandAction.Simple(null, new PsiFile[0]){

            protected void run() throws Throwable {
                for (VirtualFile file2 : vTestRoot.getChildren()) {
                    VfsUtil.copy((Object)((Object)this), (VirtualFile)file2, (VirtualFile)toDir);
                }
            }
        }.execute().throwException();
    }

    public static void setFileText(final @NotNull VirtualFile file2, final @NotNull String text) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "setFileText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/PlatformTestCase", "setFileText"));
        }
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$13", "run"));
                }
                VfsUtil.saveText((VirtualFile)file2, (String)text);
            }
        }.execute().throwException();
    }

    public static void setBinaryContent(final @NotNull VirtualFile file2, final @NotNull byte[] content) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "setBinaryContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/PlatformTestCase", "setBinaryContent"));
        }
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$14", "run"));
                }
                file2.setBinaryContent(content);
            }
        }.execute().throwException();
    }

    /*
     * WARNING - void declaration
     */
    public static void setBinaryContent(final @NotNull VirtualFile file2, final @NotNull byte[] content, final long newModificationStamp, final long newTimeStamp, Object object) {
        void requestor;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/PlatformTestCase", "setBinaryContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/testFramework/PlatformTestCase", "setBinaryContent"));
        }
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PlatformTestCase$15", "run"));
                }
                file2.setBinaryContent(content, newModificationStamp, newTimeStamp, requestor);
            }
        }.execute().throwException();
    }

    static {
        myFilesToDelete = new HashSet<File>();
        LOG = Logger.getInstance((String)"#com.intellij.testFramework.PlatformTestCase");
        ourTestTime = 300L;
        Logger.setFactory(TestLoggerFactory.class);
        PREFIX_CANDIDATES = new String[]{"AppCode", "CLion", "CidrCommon", "Python", "PyCharmCore", "Ruby", "UltimateLangXml", "Idea", "PlatformLangXml"};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface WrapInCommand {
    }
}

