/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tokenindex;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.tokenindex.AnonymToken;
import com.intellij.tokenindex.IndentToken;
import com.intellij.tokenindex.PathMarkerToken;
import com.intellij.tokenindex.TextToken;
import com.intellij.tokenindex.Token;
import com.intellij.tokenindex.TokenIndexKey;
import com.intellij.tokenindex.TokenIndexKeyDescriptor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TokenIndex
extends FileBasedIndexExtension<TokenIndexKey, List<Token>> {
    private static final int FILE_BLOCK_SIZE = 100;
    public static final ID<TokenIndexKey, List<Token>> INDEX_ID = ID.create((String)"token.index");
    private static final int VERSION = 3;
    private final KeyDescriptor<TokenIndexKey> myKeyDescriptor = new TokenIndexKeyDescriptor();
    private static final int ANONYM_TOKEN_ID = 0;
    private static final int TEXT_TOKEN_ID = 1;
    private static final int MARKER_TOKEN_ID = 2;
    private static final int INDENT_TOKEN_ID = 3;
    private final DataExternalizer<List<Token>> myDataExternalizer = new DataExternalizer<List<Token>>(){

        public void save(@NotNull DataOutput out, List<Token> value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/tokenindex/TokenIndex$1", "save"));
            }
            out.writeInt(value.size());
            for (Token token : value) {
                if (token instanceof AnonymToken) {
                    out.writeByte(0);
                    out.writeInt(token.getStart());
                    out.writeInt(token.getEnd());
                    out.writeByte(((AnonymToken)token).getType());
                    continue;
                }
                if (token instanceof TextToken) {
                    out.writeByte(1);
                    out.writeInt(token.getStart());
                    out.writeInt(token.getEnd());
                    out.writeInt(((TextToken)token).getHash());
                    continue;
                }
                if (token instanceof PathMarkerToken) {
                    out.writeByte(2);
                    out.writeUTF(((PathMarkerToken)token).getPath());
                    continue;
                }
                if (token instanceof IndentToken) {
                    out.writeByte(3);
                    out.writeInt(token.getStart());
                    out.writeInt(token.getEnd());
                    continue;
                }
                assert (false) : "Unsupported token type " + token.getClass();
            }
        }

        public List<Token> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/tokenindex/TokenIndex$1", "read"));
            }
            ArrayList<Token> result = new ArrayList<Token>();
            int n = in.readInt();
            block6: for (int i = 0; i < n; ++i) {
                byte tokenTypeId = in.readByte();
                switch (tokenTypeId) {
                    case 0: {
                        int start = in.readInt();
                        int end = in.readInt();
                        byte anonymTokenTypeValue = in.readByte();
                        result.add(new AnonymToken(anonymTokenTypeValue, start, end));
                        continue block6;
                    }
                    case 1: {
                        int start = in.readInt();
                        int end = in.readInt();
                        int hash = in.readInt();
                        result.add(new TextToken(hash, start, end));
                        continue block6;
                    }
                    case 2: {
                        String path = in.readUTF();
                        result.add(new PathMarkerToken(path));
                        continue block6;
                    }
                    case 3: {
                        int start = in.readInt();
                        int end = in.readInt();
                        result.add(new IndentToken(start, end));
                    }
                }
            }
            return result;
        }
    };

    @NotNull
    public ID<TokenIndexKey, List<Token>> getName() {
        ID<TokenIndexKey, List<Token>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex", "getName"));
        }
        return iD;
    }

    private static int getBlockId(String filePath) {
        int h = filePath.hashCode();
        if (h < 0) {
            h = -h;
        }
        return h % 100;
    }

    @NotNull
    public DataIndexer<TokenIndexKey, List<Token>, FileContent> getIndexer() {
        DataIndexer<TokenIndexKey, List<Token>, FileContent> dataIndexer = new DataIndexer<TokenIndexKey, List<Token>, FileContent>(){

            @NotNull
            public Map<TokenIndexKey, List<Token>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/tokenindex/TokenIndex$2", "map"));
                }
                Map map = Collections.EMPTY_MAP;
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex$2", "map"));
                }
                return map;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<TokenIndexKey> getKeyDescriptor() {
        KeyDescriptor<TokenIndexKey> keyDescriptor = this.myKeyDescriptor;
        if (keyDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex", "getKeyDescriptor"));
        }
        return keyDescriptor;
    }

    @NotNull
    public DataExternalizer<List<Token>> getValueExternalizer() {
        DataExternalizer<List<Token>> dataExternalizer = this.myDataExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = new FileBasedIndex.InputFilter(){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/tokenindex/TokenIndex$3", "acceptInput"));
                }
                if (file2.getFileSystem() instanceof JarFileSystem) {
                    return false;
                }
                return file2.getFileType() instanceof LanguageFileType;
            }
        };
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tokenindex/TokenIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3;
    }

    public int getCacheSize() {
        return 1;
    }

    public static boolean supports(Language language) {
        return StructuralSearchUtil.getTokenizerForLanguage(language) != null;
    }

    static /* synthetic */ int access$000(String x0) {
        return TokenIndex.getBlockId(x0);
    }
}

