/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.beg;

import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;

public class BegListUI
extends BasicListUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new PatchedInputHandler(this.list);
    }

    @Override
    protected int convertYToRow(int y) {
        return super.convertYToRow(y);
    }

    public class PatchedInputHandler
    extends BasicListUI.MouseInputHandler {
        private final JList myList;

        PatchedInputHandler(JList list) {
            super(BegListUI.this);
            this.myList = list;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row;
            if (!this.myList.isEnabled()) {
                return;
            }
            if (!this.myList.hasFocus()) {
                this.myList.requestFocus();
            }
            if ((row = BegListUI.this.convertYToRow(e.getY())) != -1) {
                this.myList.setValueIsAdjusting(true);
                int anchorIndex = this.myList.getAnchorSelectionIndex();
                if (e.isControlDown()) {
                    if (this.myList.isSelectedIndex(row)) {
                        this.myList.removeSelectionInterval(row, row);
                    } else {
                        this.myList.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown() && anchorIndex != -1) {
                    this.myList.setSelectionInterval(anchorIndex, row);
                } else {
                    this.myList.setSelectionInterval(row, row);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.myList.setValueIsAdjusting(false);
        }
    }
}

