/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundle {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.JdkBundle");
    private static final Pattern[] VERSION_UPDATE_PATTERNS = new Pattern[]{Pattern.compile("^java version \"([\\d]+\\.[\\d]+\\.[\\d]+)_([\\d]+)\".*", 8), Pattern.compile("^openjdk version \"([\\d]+\\.[\\d]+\\.[\\d]+)_([\\d]+).*\".*", 8), Pattern.compile("^[a-zA-Z() \"\\d]*([\\d]+\\.[\\d]+\\.?[\\d]*).*", 8)};
    @NotNull
    private File myBundleAsFile;
    @NotNull
    private String myBundleName;
    @Nullable
    private Pair<Version, Integer> myVersionUpdate;
    private boolean myBoot;
    private boolean myBundled;

    JdkBundle(@NotNull File bundleAsFile, @NotNull String bundleName, @Nullable Pair<Version, Integer> versionUpdate, boolean boot, boolean bundled) {
        if (bundleAsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAsFile", "com/intellij/util/JdkBundle", "<init>"));
        }
        if (bundleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleName", "com/intellij/util/JdkBundle", "<init>"));
        }
        this.myBundleAsFile = bundleAsFile;
        this.myBundleName = bundleName;
        this.myVersionUpdate = versionUpdate;
        this.myBoot = boot;
        this.myBundled = bundled;
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled) {
        if (jvm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvm", "com/intellij/util/JdkBundle", "createBundle"));
        }
        String homeSubPath = SystemInfo.isMac ? "Contents/Home" : "";
        return JdkBundle.createBundle(jvm, homeSubPath, boot, bundled);
    }

    @Nullable
    static JdkBundle createBundle(@NotNull File jvm, @NotNull String homeSubPath, boolean boot, boolean bundled) {
        File javaHome;
        if (jvm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvm", "com/intellij/util/JdkBundle", "createBundle"));
        }
        if (homeSubPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homeSubPath", "com/intellij/util/JdkBundle", "createBundle"));
        }
        File file2 = javaHome = SystemInfo.isMac ? new File(jvm, homeSubPath) : jvm;
        if (bundled) {
            javaHome = new File(PathManager.getHomePath(), javaHome.getPath());
        }
        boolean isValidBundle = true;
        String jreCheck = System.getProperty("idea.jre.check");
        if (jreCheck != null && "true".equals(jreCheck)) {
            isValidBundle = new File(javaHome, "lib" + File.separator + "tools.jar").exists();
        }
        if (!SystemInfo.isMac && !isValidBundle) {
            return null;
        }
        File absJvmLocation = bundled ? new File(PathManager.getHomePath(), jvm.getPath()) : jvm;
        Pair<String, Pair<Version, Integer>> nameVersionAndUpdate = JdkBundle.getJDKNameVersionAndUpdate(absJvmLocation, homeSubPath);
        if (SystemInfo.isMac && nameVersionAndUpdate.second != null && ((Version)((Pair)nameVersionAndUpdate.second).first).isOrGreaterThan(Integer.valueOf(1), Integer.valueOf(7)) && !isValidBundle) {
            return null;
        }
        return new JdkBundle(jvm, (String)nameVersionAndUpdate.first, (Pair<Version, Integer>)((Pair)nameVersionAndUpdate.second), boot, bundled);
    }

    @Nullable
    public static JdkBundle createBoot() {
        return JdkBundle.createBoot(true);
    }

    @Nullable
    static JdkBundle createBoot(boolean adjustToMacBundle) {
        File bootJDK = new File(System.getProperty("java.home")).getParentFile();
        if (SystemInfo.isMac && adjustToMacBundle) {
            bootJDK = bootJDK.getParentFile().getParentFile();
            return JdkBundle.createBundle(bootJDK, true, false);
        }
        return JdkBundle.createBundle(bootJDK, "", true, false);
    }

    @NotNull
    File getAbsoluteLocation() {
        File file2 = this.myBundled ? new File(PathManager.getHomePath(), this.myBundleAsFile.getPath()) : this.myBundleAsFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getAbsoluteLocation"));
        }
        return file2;
    }

    @NotNull
    public File getLocation() {
        File file2 = this.myBundleAsFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getLocation"));
        }
        return file2;
    }

    public String getVisualRepresentation() {
        StringBuilder representation = new StringBuilder(this.myBundleName);
        if (this.myVersionUpdate != null) {
            representation.append(((Version)this.myVersionUpdate.first).toString()).append((Integer)this.myVersionUpdate.second > 0 ? "_" + this.myVersionUpdate.second : "");
        }
        if (this.myBoot || this.myBundled) {
            representation.append(" [");
            if (this.myBoot) {
                representation.append(this.myBundled ? "boot, " : "boot");
            }
            if (this.myBundled) {
                representation.append("bundled");
            }
            representation.append("]");
        }
        return representation.toString();
    }

    public void setBundled(boolean bundled) {
        this.myBundled = bundled;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    @NotNull
    public String getBundleName() {
        String string = this.myBundleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getBundleName"));
        }
        return string;
    }

    @Nullable
    Pair<Version, Integer> getVersionUpdate() {
        return this.myVersionUpdate;
    }

    @Nullable
    public Version getVersion() {
        return this.myVersionUpdate != null ? (Version)this.myVersionUpdate.first : null;
    }

    @NotNull
    String getNameVersion() {
        String string = this.myBundleName + (this.myVersionUpdate != null ? ((Version)this.myVersionUpdate.first).toString() : "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/JdkBundle", "getNameVersion"));
        }
        return string;
    }

    private static Pair<String, Pair<Version, Integer>> getJDKNameVersionAndUpdate(File jvm, String homeSubPath) {
        GeneralCommandLine commandLine = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.NONE);
        commandLine.setExePath(new File(jvm, homeSubPath + File.separator + "jre" + File.separator + "bin" + File.separator + "java").getAbsolutePath());
        commandLine.addParameter("-version");
        String displayVersion = null;
        Pair versionAndUpdate = null;
        try {
            displayVersion = ExecUtil.readFirstLine((InputStream)commandLine.createProcess().getErrorStream(), null);
        }
        catch (ExecutionException e) {
            if (SystemInfo.isMac) {
                commandLine.setExePath(new File(jvm, homeSubPath + File.separator + "bin" + File.separator + "java").getAbsolutePath());
                try {
                    displayVersion = ExecUtil.readFirstLine((InputStream)commandLine.createProcess().getErrorStream(), null);
                }
                catch (ExecutionException e1) {
                    LOG.debug((Throwable)e);
                }
            }
            LOG.debug((Throwable)e);
        }
        if (displayVersion != null) {
            versionAndUpdate = VersionUtil.parseVersionAndUpdate((String)displayVersion, (Pattern[])VERSION_UPDATE_PATTERNS);
            displayVersion = displayVersion.replaceFirst("\".*\"", "");
        } else {
            displayVersion = jvm.getName();
        }
        return Pair.create((Object)displayVersion, (Object)versionAndUpdate);
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public void setBoot(boolean boot) {
        this.myBoot = boot;
    }
}

