/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.containers.RandomAccessIntContainer;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;

public class IdSet
extends TIntHashSet
implements RandomAccessIntContainer {
    public IdSet(int initialCapacity) {
        super(initialCapacity, 0.98f);
    }

    @Override
    public void compact() {
        if ((int)((float)this.capacity() * this._loadFactor) / Math.max(1, this.size()) >= 3) {
            super.compact();
        }
    }

    @Override
    public RandomAccessIntContainer ensureContainerCapacity(int diff) {
        return this;
    }

    @Override
    public ValueContainer.IntPredicate intPredicate() {
        return new ValueContainer.IntPredicate(){

            @Override
            public boolean contains(int id) {
                return IdSet.this.contains(id);
            }
        };
    }

    @Override
    public ValueContainer.IntIterator intIterator() {
        return new IntSetIterator();
    }

    private class IntSetIterator
    implements ValueContainer.IntIterator {
        private final TIntIterator mySetIterator;
        private final int mySize;

        public IntSetIterator() {
            this.mySetIterator = IdSet.this.iterator();
            this.mySize = IdSet.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.mySetIterator.hasNext();
        }

        @Override
        public int next() {
            return this.mySetIterator.next();
        }

        @Override
        public int size() {
            return this.mySize;
        }

        @Override
        public boolean hasAscendingOrder() {
            return false;
        }

        @Override
        public ValueContainer.IntIterator createCopyInInitialState() {
            return new IntSetIterator();
        }
    }
}

