/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.treeWithCheckedNodes;

import com.intellij.util.Processor;
import com.intellij.util.TreeNodeState;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedState<T> {
    private final Set<T> mySelected;
    private final SLRUMap<T, TreeNodeState> myCache;
    private final int mySelectedSize;

    public SelectedState(int selectedSize, int queueSize) {
        this.mySelectedSize = selectedSize;
        assert (queueSize > 0);
        this.mySelected = new HashSet();
        this.myCache = new SLRUMap(queueSize, queueSize);
    }

    @Nullable
    public TreeNodeState get(T node) {
        if (this.mySelected.contains(node)) {
            return TreeNodeState.SELECTED;
        }
        return (TreeNodeState)this.myCache.get(node);
    }

    public void clear(T node) {
        this.myCache.remove(node);
        this.mySelected.remove(node);
    }

    public void clearAllCachedMatching(Processor<T> processor2) {
        Set entries = this.myCache.entrySet();
        for (Map.Entry entry : entries) {
            if (!processor2.process(entry.getKey())) continue;
            this.myCache.remove(entry.getKey());
        }
    }

    public void remove(T node) {
        this.mySelected.remove(node);
        this.myCache.remove(node);
    }

    @NotNull
    public TreeNodeState putAndPass(T node, @NotNull TreeNodeState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/util/treeWithCheckedNodes/SelectedState", "putAndPass"));
        }
        if (TreeNodeState.SELECTED.equals((Object)state)) {
            this.mySelected.add(node);
            this.myCache.remove(node);
        } else {
            this.mySelected.remove(node);
            this.myCache.put(node, (Object)state);
        }
        TreeNodeState treeNodeState = state;
        if (treeNodeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/treeWithCheckedNodes/SelectedState", "putAndPass"));
        }
        return treeNodeState;
    }

    public boolean canAddSelection() {
        return this.mySelected.size() < this.mySelectedSize;
    }

    public Set<T> getSelected() {
        return Collections.unmodifiableSet(this.mySelected);
    }

    public void setSelection(Collection<T> files) {
        this.mySelected.clear();
        this.mySelected.addAll(files);
    }
}

