/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.paths.PathReference;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomResolveConverter;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.converters.PathReferenceConverter;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConverterManagerImpl
implements ConverterManager {
    private final ImplementationClassCache myImplementationClassCache = new ImplementationClassCache(DomImplementationClassEP.CONVERTER_EP_NAME);
    private final ConcurrentInstanceMap<Object> myConverterInstances = new ConcurrentInstanceMap<Object>(){

        @NotNull
        protected Object create(Class key) {
            Class implementation = ConverterManagerImpl.this.myImplementationClassCache.get(key);
            Object object = super.create(implementation == null ? key : implementation);
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ConverterManagerImpl$1", "create"));
            }
            return object;
        }
    };
    private final Map<Class, Converter> mySimpleConverters = new HashMap<Class, Converter>();

    ConverterManagerImpl() {
        this.mySimpleConverters.put(Integer.TYPE, Converter.INTEGER_CONVERTER);
        this.mySimpleConverters.put(Integer.class, Converter.INTEGER_CONVERTER);
        this.mySimpleConverters.put(Boolean.TYPE, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(Boolean.class, ResolvingConverter.BOOLEAN_CONVERTER);
        this.mySimpleConverters.put(String.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(Object.class, Converter.EMPTY_CONVERTER);
        this.mySimpleConverters.put(PathReference.class, PathReferenceConverter.INSTANCE);
    }

    public void addConverter(Class clazz, Converter converter) {
        this.mySimpleConverters.put(clazz, converter);
    }

    @NotNull
    public final Converter getConverterInstance(Class<? extends Converter> converterClass) {
        Converter converter = this.getInstance(converterClass);
        assert (converter != null) : "Converter not found for " + converterClass;
        Converter converter2 = converter;
        if (converter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/ConverterManagerImpl", "getConverterInstance"));
        }
        return converter2;
    }

    <T> T getInstance(Class<T> clazz) {
        return (T)this.myConverterInstances.get(clazz);
    }

    @Nullable
    public final Converter getConverterByClass(Class<?> convertingClass) {
        Converter converter = this.mySimpleConverters.get(convertingClass);
        if (converter != null) {
            return converter;
        }
        if (Enum.class.isAssignableFrom(convertingClass)) {
            return EnumConverter.createEnumConverter(convertingClass);
        }
        if (DomElement.class.isAssignableFrom(convertingClass)) {
            return DomResolveConverter.createConverter(convertingClass);
        }
        return null;
    }

    public <T extends Converter> void registerConverterImplementation(Class<T> converterInterface, T converterImpl) {
        this.myConverterInstances.put(converterInterface, converterImpl);
    }
}

