/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUiImpl myUi;

    public VcsLogImpl(@NotNull VcsLogDataHolder holder, @NotNull VcsLogUiImpl ui) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/impl/VcsLogImpl", "<init>"));
        }
        this.myDataHolder = holder;
        this.myUi = ui;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        AbstractList<CommitId> abstractList = new AbstractList<CommitId>(){

            @Override
            @NotNull
            public CommitId get(int index) {
                CommitId commitId = ((GraphTableModel)VcsLogImpl.this.myUi.getTable().getModel()).getCommitIdAtRow(rows[index]);
                if (commitId == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl$1", "get"));
                }
                return commitId;
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedCommits"));
        }
        return abstractList;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        final int[] rows = this.myUi.getTable().getSelectedRows();
        AbstractList<VcsFullCommitDetails> abstractList = new AbstractList<VcsFullCommitDetails>(){

            @Override
            @NotNull
            public VcsFullCommitDetails get(int index) {
                VcsFullCommitDetails vcsFullCommitDetails = (VcsFullCommitDetails)VcsLogImpl.this.myDataHolder.getCommitDetailsGetter().getCommitData(rows[index], (GraphTableModel)VcsLogImpl.this.myUi.getTable().getModel());
                if (vcsFullCommitDetails == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl$2", "get"));
                }
                return vcsFullCommitDetails;
            }

            @Override
            public int size() {
                return rows.length;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getSelectedDetails"));
        }
        return abstractList;
    }

    public void requestSelectedDetails(@NotNull Consumer<List<VcsFullCommitDetails>> consumer, @Nullable ProgressIndicator indicator) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/impl/VcsLogImpl", "requestSelectedDetails"));
        }
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myDataHolder.getCommitDetailsGetter().loadCommitsData(rowsList, (GraphTableModel)this.myUi.getTable().getModel(), (Consumer)consumer, indicator);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsLogImpl", "getContainingBranches"));
        }
        return this.myDataHolder.getContainingBranchesGetter().getContainingBranchesFromCache(root, commitHash);
    }

    @NotNull
    public Collection<VcsRef> getAllReferences() {
        Collection<VcsRef> collection = this.myUi.getDataPack().getRefsModel().getAllRefs();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getAllReferences"));
        }
        return collection;
    }

    @NotNull
    public Future<Boolean> jumpToReference(final String reference) {
        Collection<VcsRef> references = this.getAllReferences();
        VcsRef ref = (VcsRef)ContainerUtil.find(references, (Condition)new Condition<VcsRef>(){

            public boolean value(VcsRef ref) {
                return ref.getName().startsWith(reference);
            }
        });
        if (ref != null) {
            Future<Boolean> future2 = this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot());
            if (future2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "jumpToReference"));
            }
            return future2;
        }
        Future<Boolean> future3 = this.myUi.jumpToCommitByPartOfHash(reference);
        if (future3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "jumpToReference"));
        }
        return future3;
    }

    @NotNull
    public Collection<VcsLogProvider> getLogProviders() {
        Collection<VcsLogProvider> collection = this.myDataHolder.getLogProviders();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogImpl", "getLogProviders"));
        }
        return collection;
    }
}

