/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.actions.EditBreakpointActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class XDebuggerEditBreakpointActionHandler
extends EditBreakpointActionHandler {
    @Override
    protected void doShowPopup(Project project2, JComponent component, Point whereToShow, Object breakpoint) {
        DebuggerUIUtil.showXBreakpointEditorBalloon(project2, whereToShow, component, false, (XBreakpoint)breakpoint);
    }

    @Override
    public boolean isEnabled(@NotNull Project project2, AnActionEvent event) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/actions/XDebuggerEditBreakpointActionHandler", "isEnabled"));
        }
        DataContext dataContext = event.getDataContext();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        Pair<GutterIconRenderer, Object> pair = XBreakpointUtil.findSelectedBreakpoint(project2, editor);
        return pair.first != null && pair.second instanceof XLineBreakpointImpl;
    }
}

