/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XVariablesView
extends XVariablesViewBase {
    public static final Key<InlineVariablesInfo> DEBUG_VARIABLES = Key.create((String)"debug.variables");
    public static final Key<ObjectLongHashMap<VirtualFile>> DEBUG_VARIABLES_TIMESTAMPS = Key.create((String)"debug.variables.timestamps");
    private final JComponent myComponent;

    public XVariablesView(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XVariablesView", "<init>"));
        }
        super(session.getProject(), session.getDebugProcess().getEditorsProvider(), session.getValueMarkers());
        this.myComponent = new MyPanel();
        this.myComponent.add(super.getPanel());
    }

    @Override
    public JComponent getPanel() {
        return this.myComponent;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XVariablesView", "processSessionEvent"));
        }
        XDebugSession session = XVariablesView.getSession(this.getPanel());
        XStackFrame stackFrame = session == null ? null : session.getCurrentStackFrame();
        XDebuggerTree tree = this.getTree();
        if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
            this.saveCurrentTreeState(stackFrame);
            if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        tree.markNodesObsolete();
        if (stackFrame != null) {
            this.cancelClear();
            this.buildTreeAndRestoreState(stackFrame);
        } else {
            this.requestClear();
        }
    }

    @Override
    public void dispose() {
        XVariablesView.clearInlineData(this.getTree());
        super.dispose();
    }

    private static void clearInlineData(XDebuggerTree tree) {
        tree.getProject().putUserData(DEBUG_VARIABLES, null);
        tree.getProject().putUserData(DEBUG_VARIABLES_TIMESTAMPS, null);
        tree.updateEditor();
    }

    @Override
    protected void clear() {
        MessageTreeNode node;
        XDebuggerTree tree = this.getTree();
        tree.setSourcePosition(null);
        XVariablesView.clearInlineData(tree);
        XDebugSession session = XVariablesView.getSession(this.getPanel());
        if (session == null || !session.isStopped() && session.isPaused()) {
            node = MessageTreeNode.createInfoMessage(tree, "Frame is not available");
        } else {
            XDebugProcess debugProcess = session.getDebugProcess();
            node = MessageTreeNode.createInfoMessage(tree, debugProcess.getCurrentStateMessage(), debugProcess.getCurrentStateHyperlinkListener());
        }
        tree.setRoot(node, true);
        super.clear();
    }

    private class MyPanel
    extends BorderLayoutPanel
    implements DataProvider {
        private MyPanel() {
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return XVariablesView.this.getCurrentFile((Component)((Object)XVariablesView.this.getTree()));
            }
            return null;
        }
    }

    public static class InlineVariablesInfo {
        private final Map<Pair<VirtualFile, Integer>, Set<Entry>> myData = new THashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<XValueNodeImpl> get(@NotNull VirtualFile file2, int line) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "get"));
            }
            Map<Pair<VirtualFile, Integer>, Set<Entry>> map = this.myData;
            synchronized (map) {
                Set<Entry> entries = this.myData.get(Pair.create((Object)file2, (Object)line));
                if (entries == null) {
                    return null;
                }
                return ContainerUtil.map(entries, (Function)new Function<Entry, XValueNodeImpl>(){

                    public XValueNodeImpl fun(Entry entry) {
                        return entry.myNode;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(@NotNull VirtualFile file2, @NotNull XSourcePosition position, @NotNull XValueNodeImpl node) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "put"));
            }
            Map<Pair<VirtualFile, Integer>, Set<Entry>> map = this.myData;
            synchronized (map) {
                Pair key = Pair.create((Object)file2, (Object)position.getLine());
                Set<Entry> entries = this.myData.get(key);
                if (entries == null) {
                    entries = new TreeSet<Entry>();
                    this.myData.put((Pair<VirtualFile, Integer>)key, entries);
                }
                entries.add(new Entry(position.getOffset(), node));
            }
        }

        private static class Entry
        implements Comparable<Entry> {
            private final long myOffset;
            private final XValueNodeImpl myNode;

            /*
             * WARNING - void declaration
             */
            public Entry(long offset, @NotNull XValueNodeImpl xValueNodeImpl) {
                void node;
                if (xValueNodeImpl == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo$Entry", "<init>"));
                }
                this.myOffset = offset;
                this.myNode = node;
            }

            @Override
            public int compareTo(Entry o) {
                if (this.myNode == o.myNode) {
                    return 0;
                }
                int res = Comparing.compare((long)this.myOffset, (long)o.myOffset);
                if (res == 0) {
                    return XValueNodeImpl.COMPARATOR.compare(this.myNode, o.myNode);
                }
                return res;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                return this.myNode.equals(entry.myNode);
            }

            public int hashCode() {
                return this.myNode.hashCode();
            }
        }
    }
}

