/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent {
    public static final String DISPLAY_NAME = XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);
    static final Configurable[] EMPTY_CONFIGURABLES = new Configurable[0];
    private static final DebuggerSettingsCategory[] MERGED_CATEGORIES = new DebuggerSettingsCategory[]{DebuggerSettingsCategory.STEPPING, DebuggerSettingsCategory.HOTSWAP};
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger";
    }

    public Configurable[] getConfigurables() {
        this.compute();
        if (this.myChildren.length == 0 && this.myRootConfigurable instanceof SearchableConfigurable.Parent) {
            return ((SearchableConfigurable.Parent)this.myRootConfigurable).getConfigurables();
        }
        return this.myChildren;
    }

    private void compute() {
        if (this.myChildren != null) {
            return;
        }
        SmartList configurables = new SmartList();
        configurables.add(new DataViewsConfigurable());
        DebuggerConfigurableProvider[] providers = (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions();
        DebuggerConfigurable.computeMergedConfigurables(providers, (List<Configurable>)configurables);
        for (DebuggerConfigurableProvider provider : providers) {
            configurables.addAll(provider.getConfigurables(DebuggerSettingsCategory.ROOT));
        }
        MergedCompositeConfigurable mergedGeneralConfigurable = DebuggerConfigurable.computeGeneralConfigurables(providers);
        if (configurables.isEmpty() && mergedGeneralConfigurable == null) {
            this.myRootConfigurable = null;
            this.myChildren = EMPTY_CONFIGURABLES;
        } else if (configurables.size() == 1) {
            Configurable firstConfigurable = (Configurable)configurables.get(0);
            if (mergedGeneralConfigurable == null) {
                this.myRootConfigurable = firstConfigurable;
                this.myChildren = EMPTY_CONFIGURABLES;
            } else {
                Configurable[] generalConfigurables = mergedGeneralConfigurable.children;
                Configurable[] mergedArray = new Configurable[generalConfigurables.length + 1];
                System.arraycopy(generalConfigurables, 0, mergedArray, 0, generalConfigurables.length);
                mergedArray[generalConfigurables.length] = firstConfigurable;
                this.myRootConfigurable = new MergedCompositeConfigurable("", "", mergedArray);
                this.myChildren = firstConfigurable instanceof SearchableConfigurable.Parent ? ((SearchableConfigurable.Parent)firstConfigurable).getConfigurables() : EMPTY_CONFIGURABLES;
            }
        } else {
            this.myChildren = configurables.toArray(new Configurable[configurables.size()]);
            this.myRootConfigurable = mergedGeneralConfigurable;
        }
    }

    private static void computeMergedConfigurables(@NotNull DebuggerConfigurableProvider[] providers, @NotNull List<Configurable> result) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "computeMergedConfigurables"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "computeMergedConfigurables"));
        }
        for (DebuggerSettingsCategory category : MERGED_CATEGORIES) {
            List<Configurable> configurables = DebuggerConfigurable.getConfigurables(category, providers);
            if (configurables.isEmpty()) continue;
            String id = category.name().toLowerCase(Locale.ENGLISH);
            result.add((Configurable)new MergedCompositeConfigurable("debugger." + id, XDebuggerBundle.message((String)("debugger." + id + ".display.name"), (Object[])new Object[0]), configurables.toArray(new Configurable[configurables.size()])));
        }
    }

    @Nullable
    private static MergedCompositeConfigurable computeGeneralConfigurables(@NotNull DebuggerConfigurableProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "computeGeneralConfigurables"));
        }
        List<Configurable> rootConfigurables = DebuggerConfigurable.getConfigurables(DebuggerSettingsCategory.GENERAL, providers);
        if (rootConfigurables.isEmpty()) {
            return null;
        }
        Configurable[] mergedRootConfigurables = rootConfigurables.toArray(new Configurable[rootConfigurables.size()]);
        Arrays.sort(mergedRootConfigurables, new Comparator<Configurable>(){

            @Override
            public int compare(@NotNull Configurable o1, @NotNull Configurable o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable$1", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable$1", "compare"));
                }
                boolean c1e = StringUtil.isEmpty((String)o1.getDisplayName());
                return c1e == StringUtil.isEmpty((String)o2.getDisplayName()) ? 0 : (c1e ? -1 : 1);
            }
        });
        return new MergedCompositeConfigurable("", "", mergedRootConfigurables);
    }

    public void apply() throws ConfigurationException {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        this.compute();
        return this.myRootConfigurable != null;
    }

    public boolean isVisible() {
        return ((XBreakpointType[])XBreakpointType.EXTENSION_POINT_NAME.getExtensions()).length != 0;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        this.compute();
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.propDebugger" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getId"));
        }
        return "project.propDebugger";
    }

    @NotNull
    static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getConfigurables"));
        }
        List<Configurable> list = DebuggerConfigurable.getConfigurables(category, (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getConfigurables"));
        }
        return list;
    }

    @NotNull
    private static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category, @NotNull DebuggerConfigurableProvider[] providers) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getConfigurables"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getConfigurables"));
        }
        List configurables = null;
        for (DebuggerConfigurableProvider provider : providers) {
            Collection providerConfigurables = provider.getConfigurables(category);
            if (providerConfigurables.isEmpty()) continue;
            if (configurables == null) {
                configurables = new SmartList();
            }
            configurables.addAll(providerConfigurables);
        }
        List list = ContainerUtil.notNullize(configurables);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/settings/DebuggerConfigurable", "getConfigurables"));
        }
        return list;
    }
}

