/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UseOfCloneInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.of.clone.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/UseOfCloneInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object errorElement = infos[0];
        if (errorElement instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/UseOfCloneInspection", "buildErrorString"));
            }
            return string;
        }
        if (errorElement instanceof PsiMethod) {
            String string = InspectionGadgetsBundle.message("use.of.clone.call.method.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/UseOfCloneInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("use.of.clone.reference.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/cloneable/UseOfCloneInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfCloneVisitor();
    }

    private static class UseOfCloneVisitor
    extends BaseInspectionVisitor {
        private UseOfCloneVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiType type;
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"clone".equals(referenceName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 0) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null && (type = qualifierExpression.getType()) instanceof PsiArrayType) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiMethod) || !CloneUtils.isClone((PsiMethod)target)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            String qualifiedName = reference.getQualifiedName();
            if (!"java.lang.Cloneable".equals(qualifiedName)) {
                return;
            }
            this.registerError((PsiElement)reference, reference);
        }

        public void visitMethod(PsiMethod method) {
            if (!CloneUtils.isClone(method) || CloneUtils.onlyThrowsException(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

