/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodCallInLoopConditionInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.call.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCallInLoopConditionVisitor();
    }

    private static class MethodCallInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private MethodCallInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor", "visitDoWhileStatement"));
            }
            super.visitDoWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        private void checkForMethodCalls(PsiExpression condition) {
            JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/MethodCallInLoopConditionInspectionBase$MethodCallInLoopConditionVisitor$1", "visitMethodCallExpression"));
                    }
                    super.visitMethodCallExpression(expression);
                    this.registerMethodCallError(expression, new Object[0]);
                }
            };
            condition.accept((PsiElementVisitor)visitor);
        }
    }
}

